DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -8.50886383385411E-12   0.00000000000000E+00  -3.15728012861914E-10   1.64192157848242E-22
      8.82476145375115E-09   8.50903344088940E-09  -7.92652838203049E-19  -2.49110336317875E-01  -2.49110336321286E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41073657028334E-09   0.00000000000000E+00   3.41073657028334E-09
      3.70243398395263E-18  -2.49110336317874E-01  -2.45355022493273E-01   0.00000000000000E+00   1.00220414240010E-11
     -6.61813851647758E-23  -1.19297920525955E-08  -1.19197700111715E-08  -2.90978114574958E-18
      1.17500000000000E-12
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -2.08520972545533E-11   1.60806811900502E-22
      8.53860979125373E-09   8.51775769399934E-09  -7.94640859345697E-19  -2.48252192543821E-01  -2.48252192547033E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21239898784305E-09   0.00000000000000E+00   3.21239898784305E-09
      3.70460235326943E-18  -2.48252192543810E-01  -2.44556663160701E-01   0.00000000000000E+00   1.35338917871435E-11
     -9.71552416869215E-23  -1.17436905736291E-08  -1.17301566818420E-08  -2.90996149392373E-18
      2.08625000000000E-12
      0.00000000000000E+00  -8.52760016024444E-12   0.00000000000000E+00  -6.84222483039640E-13   1.55341586077309E-22
      8.52823904813665E-09   8.52755482565377E-09  -7.97023785080242E-19  -2.47244517435915E-01  -2.47244517438825E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90984813470597E-09   0.00000000000000E+00   2.90984813470597E-09
      3.70725395238218E-18  -2.47244517435903E-01  -2.43641133222675E-01   0.00000000000000E+00   1.54907891188663E-11
     -9.85719050879635E-23  -1.14528937494770E-08  -1.14374029603582E-08  -2.91023016730193E-18
      3.31643750000000E-12
      0.00000000000000E+00  -8.53926444186980E-12   0.00000000000000E+00   3.44736250766548E-13   1.48230131205314E-22
      8.53891163905060E-09   8.53925637530151E-09  -7.99785651219529E-19  -2.46075878863378E-01  -2.46075878865898E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51986710761075E-09   0.00000000000000E+00   2.51986710761075E-09
      3.71035386139962E-18  -2.46075878863368E-01  -2.42591677183201E-01   0.00000000000000E+00   1.47291381783722E-11
     -9.78868383504075E-23  -1.10738526210898E-08  -1.10591234829116E-08  -2.91056821018009E-18
      4.97719062500000E-12
      0.00000000000000E+00  -8.55221454981606E-12   0.00000000000000E+00   3.38885668092323E-13   1.40703855339804E-22
      8.55193645524886E-09   8.55227534091709E-09  -8.02852569735689E-19  -2.44775766755825E-01  -2.44775766757903E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07744424578002E-09   0.00000000000000E+00   2.07744424578002E-09
      3.71380398342281E-18  -2.44775766755821E-01  -2.41426854953945E-01   0.00000000000000E+00   1.23675264231895E-11
     -9.77485570188662E-23  -1.06420871131209E-08  -1.06297195866978E-08  -2.91095141368712E-18
      7.21920734375000E-12
      0.00000000000000E+00  -8.56599126039719E-12   0.00000000000000E+00   3.02469366320543E-13   1.32266927112703E-22
      8.56571858723343E-09   8.56602105659988E-09  -8.06082300792539E-19  -2.43404171690068E-01  -2.43404171691689E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62093961325399E-09   0.00000000000000E+00   1.62093961325399E-09
      3.71743815713581E-18  -2.43404171690080E-01  -2.40194760917021E-01   0.00000000000000E+00   9.44504537519001E-12
     -9.75734849325503E-23  -1.01964057152280E-08  -1.01869606698529E-08  -2.91135585634327E-18
      1.02459299140625E-11
      0.00000000000000E+00  -8.57949243676670E-12   0.00000000000000E+00   2.79267657882112E-13   1.24716355075340E-22
      8.57934008135557E-09   8.57961934901358E-09  -8.09269512905681E-19  -2.42048458961096E-01  -2.42048458962283E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18680729874986E-09   0.00000000000000E+00   1.18680729874986E-09
      3.72103029357355E-18  -2.42048458961079E-01  -2.38971550820375E-01   0.00000000000000E+00   6.62890481005219E-12
     -9.74975434898615E-23  -9.77305555257323E-09  -9.76642664776328E-09  -2.91176078066787E-18
      1.43320053839844E-11
      0.00000000000000E+00  -8.59189147628971E-12   0.00000000000000E+00   2.65329515259871E-13   1.18279100748708E-22
      8.59177477236057E-09   8.59204010187595E-09  -8.12176075239556E-19  -2.40810670894334E-01  -2.40810670895141E-01
      0.00000000000000E+00   0.00000000000000E+00   8.06936964080405E-10   0.00000000000000E+00   8.06936964080405E-10
      3.72432749890825E-18  -2.40810670894355E-01  -2.37849541633409E-01   0.00000000000000E+00   4.25308220728036E-12
     -9.78681453103751E-23  -9.40323014816333E-09  -9.39897706595615E-09  -2.91215142366870E-18
      1.98482072683789E-11
      0.00000000000000E+00  -8.60217808685695E-12   0.00000000000000E+00   2.45069614746809E-13   1.13226730526017E-22
      8.60209181665945E-09   8.60233688627431E-09  -8.14587191411408E-19  -2.39783527978236E-01  -2.39783527978741E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04434009115576E-10   0.00000000000000E+00   5.04434009115576E-10
      3.72711005873989E-18  -2.39783527978270E-01  -2.36914466577387E-01   0.00000000000000E+00   2.45981641162170E-12
     -9.77177832594863E-23  -9.10923071180152E-09  -9.10677089539000E-09  -2.91252286732848E-18
      2.72950798123115E-11
      0.00000000000000E+00  -8.60980120004518E-12   0.00000000000000E+00   2.02006148289365E-13   1.09724854450550E-22
      8.60974219628373E-09   8.60994420243213E-09  -8.16377478868317E-19  -2.39021762689118E-01  -2.39021762689407E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88866339304779E-10   0.00000000000000E+00   2.88866339304779E-10
      3.72926120955092E-18  -2.39021762689104E-01  -2.36218216171730E-01   0.00000000000000E+00   1.26598747006513E-12
     -9.82779000435500E-23  -8.90007652920690E-09  -8.89881054173693E-09  -2.91288373068260E-18
      3.73483577466206E-11
      0.00000000000000E+00  -8.61476081585439E-12   0.00000000000000E+00   1.36351571726748E-13   1.07662064332341E-22
      8.61474884398801E-09   8.61488519555985E-09  -8.17553961132196E-19  -2.38523150870799E-01  -2.38523150870953E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54238492167929E-10   0.00000000000000E+00   1.54238492167929E-10
      3.73081181198086E-18  -2.38523150870861E-01  -2.35760448119116E-01   0.00000000000000E+00   5.85468290061847E-13
     -9.71735788457242E-23  -8.76970915601777E-09  -8.76912368772780E-09  -2.91325785084866E-18
      5.09202829579378E-11
      0.00000000000000E+00  -8.61769984744503E-12   0.00000000000000E+00   7.01041415764120E-14   1.06731815070388E-22
      8.61765974709463E-09   8.61772985123631E-09  -8.18244318774654E-19  -2.38233160519106E-01  -2.38233160519188E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21830753986903E-11   0.00000000000000E+00   8.21830753986903E-11
      3.73192719453380E-18  -2.38233160519571E-01  -2.35492245272460E-01   0.00000000000000E+00   2.62279784701689E-13
     -9.82396135045144E-23  -8.70017520641958E-09  -8.69991292663497E-09  -2.91368287575915E-18
      6.92423819932160E-11
      0.00000000000000E+00  -8.61926120797756E-12   0.00000000000000E+00   2.62344832688715E-14   1.06553386825493E-22
      8.61926913699511E-09   8.61929537147849E-09  -8.18631827551946E-19  -2.38072713937722E-01  -2.38072713937771E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97276531636108E-11   0.00000000000000E+00   4.97276531636108E-11
      3.73283830951986E-18  -2.38072713938435E-01  -2.35341518289108E-01   0.00000000000000E+00   1.34281159760975E-13
     -9.79305166052747E-23  -8.66915730580173E-09  -8.66902302464207E-09  -2.91420648196791E-18
      8.92423819932160E-11
      0.00000000000000E+00  -8.62017965534963E-12   0.00000000000000E+00   5.18416865552040E-15   1.06747279713959E-22
      8.62015509263404E-09   8.62016027680280E-09  -8.18846925831994E-19  -2.37984288749116E-01  -2.37984288749155E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82198615341930E-11   0.00000000000000E+00   3.82198615341930E-11
      3.73360270675054E-18  -2.37984288749931E-01  -2.35256440022633E-01   0.00000000000000E+00   9.60204615599374E-14
     -9.81692545795187E-23  -8.65847615879844E-09  -8.65838013833698E-09  -2.91475578091855E-18
      1.09242381993216E-10
      0.00000000000000E+00  -8.62073072377288E-12   0.00000000000000E+00   1.78523437790247E-15   1.07032280468532E-22
      8.62076107362032E-09   8.62076285885481E-09  -8.18992003534243E-19  -2.37923746280741E-01  -2.37923746280775E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41865939125824E-11   0.00000000000000E+00   3.41865939125824E-11
      3.73428643862879E-18  -2.37923746281485E-01  -2.35196977463457E-01   0.00000000000000E+00   7.98249141817764E-14
     -9.35768205357572E-23  -8.65502927768148E-09  -8.65494945276739E-09  -2.91529443509455E-18
      1.29242381993216E-10
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00   1.90452810382983E-15   1.07502460808701E-22
      8.62127228602928E-09   8.62127419055749E-09  -8.19110586086784E-19  -2.37872644270179E-01  -2.37872644270212E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25138006067547E-11   0.00000000000000E+00   3.25138006067547E-11
      3.73493671464093E-18  -2.37872644271466E-01  -2.35146241436303E-01   0.00000000000000E+00   7.25634428545590E-14
     -9.92453712011305E-23  -8.65386055460702E-09  -8.65378799116427E-09  -2.91582612855415E-18
      1.49242381993216E-10
      0.00000000000000E+00  -8.62174101588216E-12   0.00000000000000E+00   1.37656252542850E-15   1.07698131293696E-22
      8.62174711539036E-09   8.62174849195299E-09  -8.19216653888075E-19  -2.37825169788917E-01  -2.37825169788949E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16013675673378E-11   0.00000000000000E+00   3.16013675673378E-11
      3.73556874199228E-18  -2.37825169790662E-01  -2.35098904813056E-01   0.00000000000000E+00   6.99271315404705E-14
     -9.61267004366048E-23  -8.65341978665171E-09  -8.65334985952027E-09  -2.91635208810420E-18
      1.69242381993216E-10
      0.00000000000000E+00  -8.62220023956820E-12   0.00000000000000E+00   1.18200533948005E-15   1.08176868230685E-22
      8.62220418001939E-09   8.62220536202484E-09  -8.19314899164881E-19  -2.37779467681473E-01  -2.37779467681504E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09463241756033E-11   0.00000000000000E+00   3.09463241756033E-11
      3.73618766847579E-18  -2.37779467682467E-01  -2.35053265057208E-01   0.00000000000000E+00   6.82756298267553E-14
     -9.85115622449800E-23  -8.65321996183022E-09  -8.65315168620049E-09  -2.91687276931091E-18
      1.89242381993216E-10
      0.00000000000000E+00  -8.62265946325423E-12   0.00000000000000E+00   1.25931857858368E-15   1.08605405022692E-22
      8.62264964642285E-09   8.62265090574154E-09  -8.19407078455998E-19  -2.37734924082011E-01  -2.37734924082042E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03895457343122E-11   0.00000000000000E+00   3.03895457343122E-11
      3.73679545939048E-18  -2.37734924080368E-01  -2.35008756499583E-01   0.00000000000000E+00   6.68286298373327E-14
     -9.94144163042485E-23  -8.65310728010562E-09  -8.65304045147588E-09  -2.91738838093448E-18
      2.09242381993216E-10
      0.00000000000000E+00  -8.62311868694027E-12   0.00000000000000E+00   1.06776273311341E-15   1.08869880039500E-22
      8.62308575846339E-09   8.62308682622624E-09  -8.19494006893263E-19  -2.37691315808834E-01  -2.37691315808864E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98798733544285E-11   0.00000000000000E+00   2.98798733544285E-11
      3.73739305685756E-18  -2.37691315803081E-01  -2.34965171372013E-01   0.00000000000000E+00   6.58589642794281E-14
     -9.74508282013875E-23  -8.65303255854487E-09  -8.65296669958069E-09  -2.91789904996430E-18
      2.29242381993216E-10
      0.00000000000000E+00  -8.62357791062631E-12   0.00000000000000E+00   9.46073560742940E-16   1.09165285721349E-22
      8.62351348395122E-09   8.62351443002489E-09  -8.19576180969179E-19  -2.37648545655830E-01  -2.37648545655859E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93999154677227E-11   0.00000000000000E+00   2.93999154677227E-11
      3.73798105516692E-18  -2.37648545647107E-01  -2.34922417646069E-01   0.00000000000000E+00   6.49331530730347E-14
     -9.62590708013573E-23  -8.65297927864562E-09  -8.65291434549265E-09  -2.91840487419774E-18
      2.49242381993216E-10
      0.00000000000000E+00  -8.62394528957514E-12   0.00000000000000E+00   1.02337863581509E-15   1.09476005024512E-22
      8.62393339004699E-09   8.62393441342573E-09  -8.19653980134040E-19  -2.37606557401196E-01  -2.37606557401225E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89431706037694E-11   0.00000000000000E+00   2.89431706037694E-11
      3.73855991857899E-18  -2.37606557387436E-01  -2.34880440966624E-01   0.00000000000000E+00   6.38896027742135E-14
     -9.61483708619070E-23  -8.65294147363211E-09  -8.65287758402943E-09  -2.91890593844495E-18
      2.69242381993216E-10
      0.00000000000000E+00  -8.62440451326118E-12   0.00000000000000E+00   9.22980399803953E-16   1.09803576535951E-22
      8.62434588877043E-09   8.62434681175094E-09  -8.19727730243829E-19  -2.37565309640829E-01  -2.37565309640858E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85066094217819E-11   0.00000000000000E+00   2.85066094217819E-11
      3.73913005076743E-18  -2.37565309623277E-01  -2.34839200757484E-01   0.00000000000000E+00   6.30882130535194E-14
     -9.67490047357846E-23  -8.65291650938568E-09  -8.65285342117272E-09  -2.91940232052360E-18
      2.89242381993216E-10
      0.00000000000000E+00  -8.62477189221001E-12   0.00000000000000E+00   9.85224576045080E-16   1.10103850318268E-22
      8.62475133178352E-09   8.62475231700820E-09  -8.19797724685538E-19  -2.37524767344987E-01  -2.37524767345016E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80883590082344E-11   0.00000000000000E+00   2.80883590082344E-11
      3.73969181794759E-18  -2.37524767327348E-01  -2.34798662470745E-01   0.00000000000000E+00   6.21802386757704E-14
     -9.49018521100010E-23  -8.65290285625513E-09  -8.65284067601655E-09  -2.91989409326206E-18
      3.09242381993216E-10
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   9.07675467025738E-16   1.10416350661304E-22
      8.62515003232804E-09   8.62515094000362E-09  -8.19864232849168E-19  -2.37484898946476E-01  -2.37484898946504E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76870218260432E-11   0.00000000000000E+00   2.76870218260432E-11
      3.74024555838411E-18  -2.37484898935969E-01  -2.34758794884266E-01   0.00000000000000E+00   6.14606793890082E-14
     -9.47746877726985E-23  -8.65289942250890E-09  -8.65283796182961E-09  -2.92038132553495E-18
      3.29242381993216E-10
      0.00000000000000E+00  -8.62559849484488E-12   0.00000000000000E+00   9.50262808036091E-16   1.10716153608900E-22
      8.62554228379133E-09   8.62554323405425E-09  -8.19927503254048E-19  -2.37445675409784E-01  -2.37445675409811E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73013832463269E-11   0.00000000000000E+00   2.73013832463269E-11
      3.74079158604904E-18  -2.37445675416807E-01  -2.34719569256025E-01   0.00000000000000E+00   6.06647396092253E-14
     -9.39262942707503E-23  -8.65290528204015E-09  -8.65284461730063E-09  -2.92086408279499E-18
      3.49242381993216E-10
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00   8.90299110605722E-16   1.11022491208220E-22
      8.62592835305942E-09   8.62592924335864E-09  -8.19987766059816E-19  -2.37407069724980E-01  -2.37407069725007E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69303772199319E-11   0.00000000000000E+00   2.69303772199319E-11
      3.74133019359344E-18  -2.37407069762318E-01  -2.34680958830198E-01   0.00000000000000E+00   6.00099010441195E-14
     -9.39752358541173E-23  -8.65291963047950E-09  -8.65285962057855E-09  -2.92134242753362E-18
      3.69242381993216E-10
      0.00000000000000E+00  -8.62633325274254E-12   0.00000000000000E+00   9.18015108647644E-16   1.11325323166929E-22
      8.62630849594112E-09   8.62630941395634E-09  -8.20045234230695E-19  -2.37369056752990E-01  -2.37369056753017E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65730106239041E-11   0.00000000000000E+00   2.65730106239041E-11
      3.74186165380592E-18  -2.37369056832950E-01  -2.34642938699579E-01   0.00000000000000E+00   5.93023270018089E-14
     -9.38337353630767E-23  -8.65294172690706E-09  -8.65288242458016E-09  -2.92181641957522E-18
      3.89242381993216E-10
      0.00000000000000E+00  -8.62670063169137E-12   0.00000000000000E+00   8.71273336353827E-16   1.11626655794309E-22
      8.62668294525491E-09   8.62668381652835E-09  -8.20100105181982E-19  -2.37331612992712E-01  -2.37331612992738E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62283886570586E-11   0.00000000000000E+00   2.62283886570586E-11
      3.74238622157906E-18  -2.37331613122177E-01  -2.34605485566154E-01   0.00000000000000E+00   5.87001510246887E-14
     -9.38187643971015E-23  -8.65297090533638E-09  -8.65291220518544E-09  -2.92228611639708E-18
      4.09242381993216E-10
      0.00000000000000E+00  -8.62706801064019E-12   0.00000000000000E+00   8.88220980533941E-16   1.11925589138903E-22
      8.62705192524820E-09   8.62705281346929E-09  -8.20152561645232E-19  -2.37294716514700E-01  -2.37294716514726E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58956701423900E-11   0.00000000000000E+00   2.58956701423900E-11
      3.74290413498191E-18  -2.37294716687731E-01  -2.34568577682067E-01   0.00000000000000E+00   5.80624383152064E-14
     -9.38690007799869E-23  -8.65300654604992E-09  -8.65294848361170E-09  -2.92275157333667E-18
      4.29242381993216E-10
      0.00000000000000E+00  -8.62743538958903E-12   0.00000000000000E+00   8.51408270770001E-16   1.12221489120327E-22
      8.62741564192101E-09   8.62741649332940E-09  -8.20202772998048E-19  -2.37258346789394E-01  -2.37258346789419E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55740925669111E-11   0.00000000000000E+00   2.55740925669111E-11
      3.74341561683324E-18  -2.37258346978092E-01  -2.34532194671091E-01   0.00000000000000E+00   5.75035249838589E-14
     -9.38785109426373E-23  -8.65304808942119E-09  -8.65299058589630E-09  -2.92321284383520E-18
      4.49242381993216E-10
      0.00000000000000E+00  -8.62780276853786E-12   0.00000000000000E+00   8.60653185998931E-16   1.12513441155916E-22
      8.62777429251800E-09   8.62777515317130E-09  -8.20250896030917E-19  -2.37222484628598E-01  -2.37222484628623E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52629396579703E-11   0.00000000000000E+00   2.52629396579703E-11
      3.74392087562640E-18  -2.37222484774802E-01  -2.34496317478325E-01   0.00000000000000E+00   5.69214216570880E-14
     -9.38642336346302E-23  -8.65309501425084E-09  -8.65303809282927E-09  -2.92366997959549E-18
      4.69242381993216E-10
      0.00000000000000E+00  -8.62817014748668E-12   0.00000000000000E+00   8.31305107718861E-16   1.12802810240474E-22
      8.62812805767926E-09   8.62812888898448E-09  -8.20297076068172E-19  -2.37187112041766E-01  -2.37187112041791E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49615611136013E-11   0.00000000000000E+00   2.49615611136013E-11
      3.74442010684868E-18  -2.37187112052458E-01  -2.34460928226307E-01   0.00000000000000E+00   5.63983153197324E-14
     -9.38707111315725E-23  -8.65314684841334E-09  -8.65309045009811E-09  -2.92412303078051E-18
      4.89242381993216E-10
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00   8.35072543061260E-16   1.13089597246791E-22
      8.62847710783122E-09   8.62847794290388E-09  -8.20341447656332E-19  -2.37152212179587E-01  -2.37152212179611E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46693476618193E-11   0.00000000000000E+00   2.46693476618193E-11
      3.74491349380191E-18  -2.37152211931888E-01  -2.34426010174158E-01   0.00000000000000E+00   5.58608051051939E-14
     -9.38553568747238E-23  -8.65320315137071E-09  -8.65314729056570E-09  -2.92457204614558E-18
      5.09242381993216E-10
      0.00000000000000E+00  -8.62881306064714E-12   0.00000000000000E+00   8.11331490143911E-16   1.13373587321768E-22
      8.62882159511213E-09   8.62882240644373E-09  -8.20384135526634E-19  -2.37117769206389E-01  -2.37117769206413E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43857471319571E-11   0.00000000000000E+00   2.43857471319571E-11
      3.74540120874455E-18  -2.37117768568293E-01  -2.34391547603088E-01   0.00000000000000E+00   5.53675237122447E-14
     -9.38518977924613E-23  -8.65326352109934E-09  -8.65320815357572E-09  -2.92501707321792E-18
      5.29242381993216E-10
      0.00000000000000E+00  -8.62918043959597E-12   0.00000000000000E+00   8.11215386789441E-16   1.13652954326999E-22
      8.62916166109820E-09   8.62916247231370E-09  -8.20425255191560E-19  -2.37083768254314E-01  -2.37083768254338E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41102431675858E-11   0.00000000000000E+00   2.41102431675858E-11
      3.74588341360790E-18  -2.37083767126366E-01  -2.34357525795900E-01   0.00000000000000E+00   5.48659735800903E-14
     -9.38200818733744E-23  -8.65332758145471E-09  -8.65327271548123E-09  -2.92545815841634E-18
      5.49242381993216E-10
      0.00000000000000E+00  -8.62954781854480E-12   0.00000000000000E+00   7.91649387382021E-16   1.13935069239365E-22
      8.62949742444555E-09   8.62949821609505E-09  -8.20464913793937E-19  -2.37050195300514E-01  -2.37050195300537E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38423702296965E-11   0.00000000000000E+00   2.38423702296965E-11
      3.74636026101250E-18  -2.37050193682168E-01  -2.34323930937926E-01   0.00000000000000E+00   5.43975645089050E-14
     -9.40195396092384E-23  -8.65339498388911E-09  -8.65334058632470E-09  -2.92589534721856E-18
      5.69242381993216E-10
      0.00000000000000E+00  -8.62982335275642E-12   0.00000000000000E+00   7.88759131866207E-16   1.14216851859199E-22
      8.62982899185110E-09   8.62982978061034E-09  -8.20503210613101E-19  -2.37017037134438E-01  -2.37017037134461E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35816928475563E-11   0.00000000000000E+00   2.35816928475563E-11
      3.74683189486945E-18  -2.37017035211029E-01  -2.34290750108108E-01   0.00000000000000E+00   5.39250535331272E-14
     -9.40419433006809E-23  -8.65346539851134E-09  -8.65341147345790E-09  -2.92632868425635E-18
      5.89242381993216E-10
      0.00000000000000E+00  -8.63019073170525E-12   0.00000000000000E+00   7.72267885210161E-16   1.14487206107611E-22
      8.63015645399824E-09   8.63015722626624E-09  -8.20540237738074E-19  -2.36984281275090E-01  -2.36984281275113E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33278145389396E-11   0.00000000000000E+00   2.33278145389396E-11
      3.74729845116023E-18  -2.36984279510229E-01  -2.34257971200055E-01   0.00000000000000E+00   5.34773297164140E-14
     -9.41849918174937E-23  -8.65353851813486E-09  -8.65348504080524E-09  -2.92675821342215E-18
      6.09242381993216E-10
      0.00000000000000E+00  -8.63046626591687E-12   0.00000000000000E+00   7.67425367261099E-16   1.14727108848711E-22
      8.63047990001787E-09   8.63048066744336E-09  -8.20576080458447E-19  -2.36951915966210E-01  -2.36951915966233E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30803581457826E-11   0.00000000000000E+00   2.30803581457826E-11
      3.74776005832314E-18  -2.36951915169682E-01  -2.34225582894444E-01   0.00000000000000E+00   5.30283043530059E-14
     -9.39269951957303E-23  -8.65361405389339E-09  -8.65356102558913E-09  -2.92718397786469E-18
      6.29242381993216E-10
      0.00000000000000E+00  -8.63083364486570E-12   0.00000000000000E+00   7.53280025056961E-16   1.14979441491455E-22
      8.63079942415153E-09   8.63080017743166E-09  -8.20610817748635E-19  -2.36919930146939E-01  -2.36919930146962E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28389680149298E-11   0.00000000000000E+00   2.28389680149298E-11
      3.74821683768344E-18  -2.36919931470004E-01  -2.34193574554224E-01   0.00000000000000E+00   5.25979380700846E-14
     -9.39204012152563E-23  -8.65369174338460E-09  -8.65363914544662E-09  -2.92760601993480E-18
      6.49242381993216E-10
      0.00000000000000E+00  -8.63110917907733E-12   0.00000000000000E+00   7.47261297682110E-16   1.15189610771789E-22
      8.63111515176922E-09   8.63111589903064E-09  -8.20644522483827E-19  -2.36888313505636E-01  -2.36888313505658E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26032883446913E-11   0.00000000000000E+00   2.26032883446913E-11
      3.74866890345034E-18  -2.36888318302770E-01  -2.34161936143559E-01   0.00000000000000E+00   5.21684520979984E-14
     -9.43028847842989E-23  -8.65377135582729E-09  -8.65371918737529E-09  -2.92802438096651E-18
      6.69242381993216E-10
      0.00000000000000E+00  -8.63147655802616E-12   0.00000000000000E+00   7.35239730240082E-16   1.15518056971415E-22
      8.63142725461894E-09   8.63142798985878E-09  -8.20677261737474E-19  -2.36857056509231E-01  -2.36857056509254E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23729632199799E-11   0.00000000000000E+00   2.23729632199799E-11
      3.74911636271474E-18  -2.36857066001360E-01  -2.34130658053795E-01   0.00000000000000E+00   5.17536665399581E-14
     -9.45907447942341E-23  -8.65385270674527E-09  -8.65380095307883E-09  -2.92843910097726E-18
      6.89242381993216E-10
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00   7.29038102224538E-16   1.15677306603884E-22
      8.63173597820151E-09   8.63173670723973E-09  -8.20709096889536E-19  -2.36826150488619E-01  -2.36826150488641E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21476205100167E-11   0.00000000000000E+00   2.21476205100167E-11
      3.74955931512493E-18  -2.36826165182982E-01  -2.34099730941993E-01   0.00000000000000E+00   5.13421649983281E-14
     -9.38489856910548E-23  -8.65393566991468E-09  -8.65388432774977E-09  -2.92885021823540E-18
      7.09242381993216E-10
      0.00000000000000E+00  -8.63202762644940E-12   0.00000000000000E+00   7.19427766117122E-16   1.15881725601498E-22
      8.63204164459224E-09   8.63204236402012E-09  -8.20740083909565E-19  -2.36795587652569E-01  -2.36795587652591E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19268829295205E-11   0.00000000000000E+00   2.19268829295205E-11
      3.74999785278353E-18  -2.36795606524238E-01  -2.34069145502071E-01   0.00000000000000E+00   5.09436548302442E-14
     -9.39525482609190E-23  -8.65402019060427E-09  -8.65396924694953E-09  -2.92925776887396E-18
      7.29242381993216E-10
      0.00000000000000E+00  -8.63239500539823E-12   0.00000000000000E+00   7.14133108230301E-16   1.16758949916038E-22
      8.63234464153851E-09   8.63234535567174E-09  -8.20770273686087E-19  -2.36765361056041E-01  -2.36765361056063E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17103777165653E-11   0.00000000000000E+00   2.17103777165653E-11
      3.75043206033786E-18  -2.36765380596761E-01  -2.34038892300902E-01   0.00000000000000E+00   5.05513687010275E-14
     -9.37772475437450E-23  -8.65410628475692E-09  -8.65405573338831E-09  -2.92966178665177E-18
      7.49242381993216E-10
      0.00000000000000E+00  -8.63267053960985E-12   0.00000000000000E+00   7.07190321857971E-16   1.15519361711964E-22
      8.63264536412070E-09   8.63264607131114E-09  -8.20799712754492E-19  -2.36735464389078E-01  -2.36735464389100E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14977803931044E-11   0.00000000000000E+00   2.14977803931044E-11
      3.75086201594572E-18  -2.36735477764275E-01  -2.34008961679944E-01   0.00000000000000E+00   5.01717513545529E-14
     -9.31546828939608E-23  -8.65419402345553E-09  -8.65414385170427E-09  -2.93006230319123E-18
      7.69242381993216E-10
      0.00000000000000E+00  -8.63294607382148E-12   0.00000000000000E+00   7.03028057566707E-16   1.16685094216502E-22
      8.63294410880110E-09   8.63294481182928E-09  -8.20828444409330E-19  -2.36705891567181E-01  -2.36705891567202E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12888704301029E-11   0.00000000000000E+00   2.12888704301029E-11
      3.75128779335432E-18  -2.36705888300414E-01  -2.33979343888993E-01   0.00000000000000E+00   4.98003099198316E-14
     -8.33716552607456E-23  -8.65428348256921E-09  -8.65423368225938E-09  -2.93045934894499E-18
      7.89242381993216E-10
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00   6.97397286284472E-16   1.18361456758409E-22
      8.63324090053708E-09   8.63324159793448E-09  -8.20856510465482E-19  -2.36676636020534E-01  -2.36676636020555E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10836183928875E-11   0.00000000000000E+00   2.10836183928875E-11
      3.75170946572218E-18  -2.36676602780541E-01  -2.33950029505020E-01   0.00000000000000E+00   4.94393408361363E-14
     -1.02149622102560E-22  -8.65437465566806E-09  -8.65432521632732E-09  -2.93085295525670E-18
      8.09242381993216E-10
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   6.91782513870376E-16   1.16849852251387E-22
      8.63353528513854E-09   8.63353597692117E-09  -8.20883953445942E-19  -2.36647689762647E-01  -2.36647689762668E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08822671331790E-11   0.00000000000000E+00   2.08822671331790E-11
      3.75212711106484E-18  -2.36647612924376E-01  -2.33921010314708E-01   0.00000000000000E+00   4.90831098717402E-14
     -4.80785904926333E-23  -8.65446732716422E-09  -8.65441824405440E-09  -2.93124315761890E-18
      8.29242381993216E-10
      0.00000000000000E+00  -8.63386452119355E-12   0.00000000000000E+00   6.82519412456631E-16   2.36234307473269E-22
      8.63382610063930E-09   8.63382678315895E-09  -8.20910819133596E-19  -2.36619042281302E-01  -2.36619042281322E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06854054295132E-11   0.00000000000000E+00   2.06854054295132E-11
      3.75254081917343E-18  -2.36618912839719E-01  -2.33892280606977E-01   0.00000000000000E+00   4.87275045420951E-14
     -3.85888982414257E-22  -8.65456091609255E-09  -8.65451218858840E-09  -2.93163000003983E-18
      8.49242381993216E-10
      0.00000000000000E+00  -8.63414005540518E-12   0.00000000000000E+00   6.68753247816637E-16   1.37421366417186E-22
      8.63411133543691E-09   8.63411200419029E-09  -8.20937158661189E-19  -2.36590679616311E-01  -2.36590679616331E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04939615092364E-11   0.00000000000000E+00   2.04939615092364E-11
      3.75295069840362E-18  -2.36590500647363E-01  -2.33863838844617E-01   0.00000000000000E+00   4.83625360175231E-14
      3.48333553841992E-23  -8.65465432823567E-09  -8.65460596569961E-09  -2.93201353974243E-18
      8.69242381993217E-10
      0.00000000000000E+00  -8.63441558961680E-12   0.00000000000000E+00   6.47726095264700E-16   1.23224495666674E-22
      8.63438816705519E-09   8.63438881478141E-09  -8.20963029286847E-19  -2.36562584030702E-01  -2.36562584030722E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03090842444028E-11   0.00000000000000E+00   2.03090842444028E-11
      3.75335688008851E-18  -2.36562380093866E-01  -2.33835689302079E-01   0.00000000000000E+00   4.79775992394229E-14
     -9.19457423456656E-23  -8.65474587662497E-09  -8.65469789902582E-09  -2.93239385080166E-18
      8.79242381993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.96033340711891E-16   1.20199988819968E-22
      8.63452310544304E-09   8.63452380147650E-09  -8.20975860256965E-19  -2.36548598137104E-01  -2.36548598137125E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02193851817241E-11   0.00000000000000E+00   2.02193851817241E-11
      3.75355907394032E-18  -2.36548393595579E-01  -2.33821688543897E-01   0.00000000000000E+00   4.77048729992879E-14
     -9.77844049791194E-23  -8.65479089153111E-09  -8.65474318665821E-09  -2.93258321368336E-18
      8.80929881993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.47844834006571E-16   1.19780885235228E-22
      8.63454646730595E-09   8.63454711515091E-09  -8.20978021397400E-19  -2.36546240303603E-01  -2.36546240303623E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02032873595795E-11   0.00000000000000E+00   2.02032873595795E-11
      3.75359316698774E-18  -2.36546035652839E-01  -2.33819328305024E-01   0.00000000000000E+00   4.77473028791015E-14
     -9.92265819651369E-23  -8.65479814981284E-09  -8.65475040251006E-09  -2.93261514559034E-18
      8.83208006993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.33345270863187E-16   1.19383836363695E-22
      8.63457734391703E-09   8.63457797726242E-09  -8.20980933161379E-19  -2.36543060602339E-01  -2.36543060602359E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01825767468207E-11   0.00000000000000E+00   2.01825767468207E-11
      3.75363914542039E-18  -2.36542856296341E-01  -2.33816145747419E-01   0.00000000000000E+00   4.76961315527842E-14
     -9.67974065058161E-23  -8.65480825013999E-09  -8.65476055400853E-09  -2.93265821225902E-18
      8.86283475743216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.26523059408266E-16   1.19045115596387E-22
      8.63461860515810E-09   8.63461923168127E-09  -8.20984854207596E-19  -2.36538773900174E-01  -2.36538773900194E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01550760304135E-11   0.00000000000000E+00   2.01550760304135E-11
      3.75370113172688E-18  -2.36538571169652E-01  -2.33811856283738E-01   0.00000000000000E+00   4.76318776769296E-14
     -9.83960483602222E-23  -8.65482193958962E-09  -8.65477430771204E-09  -2.93271627751928E-18
      8.90435358555716E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   6.20014237762040E-16   1.18795344894018E-22
      8.63467376555355E-09   8.63467438556791E-09  -8.20990130321605E-19  -2.36532997389766E-01  -2.36532997389786E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01183383720377E-11   0.00000000000000E+00   2.01183383720377E-11
      3.75378466071018E-18  -2.36532799114655E-01  -2.33806078421468E-01   0.00000000000000E+00   4.75458578932884E-14
     -9.91965529275382E-23  -8.65484026979742E-09  -8.65479272393963E-09  -2.93279453038858E-18
      8.96040400352591E-10
      0.00000000000000E+00  -8.63478296856563E-12   0.00000000000000E+00   6.10898315693552E-16   1.18638895097801E-22
      8.63474720756833E-09   8.63474781846676E-09  -8.20997222927876E-19  -2.36525217832864E-01  -2.36525217832885E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00693869547933E-11   0.00000000000000E+00   2.00693869547933E-11
      3.75389715046290E-18  -2.36525030608553E-01  -2.33798302195414E-01   0.00000000000000E+00   4.74271486948236E-14
     -9.53830194457479E-23  -8.65486463257039E-09  -8.65481720542179E-09  -2.93289992753502E-18
      9.03607206778373E-10
      0.00000000000000E+00  -8.63487481330283E-12   0.00000000000000E+00   5.97310611221933E-16   1.18591744590039E-22
      8.63484429090924E-09   8.63484488821997E-09  -8.21006746488389E-19  -2.36514748341398E-01  -2.36514748341418E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00045277515846E-11   0.00000000000000E+00   2.00045277515846E-11
      3.75404852085204E-18  -2.36514587362494E-01  -2.33787848791918E-01   0.00000000000000E+00   4.72608440432618E-14
     -9.44297110749586E-23  -8.65489667681552E-09  -8.65484941597157E-09  -2.93304177436365E-18
      9.13822395453177E-10
      0.00000000000000E+00  -8.63496665804004E-12   0.00000000000000E+00   5.76687605661061E-16   1.18639955480258E-22
      8.63497112375029E-09   8.63497170043801E-09  -8.21019518138951E-19  -2.36500671400387E-01  -2.36500671400407E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99193021243057E-11   0.00000000000000E+00   1.99193021243057E-11
      3.75425200028151E-18  -2.36500572331701E-01  -2.33773820646494E-01   0.00000000000000E+00   4.70239047144060E-14
     -9.42052075014206E-23  -8.65493802646689E-09  -8.65489100256227E-09  -2.93323248214255E-18
      9.27612900164164E-10
      0.00000000000000E+00  -8.63515034751446E-12   0.00000000000000E+00   5.45715757483128E-16   1.17928320365193E-22
      8.63513377431794E-09   8.63513432003382E-09  -8.21036624187538E-19  -2.36481764120283E-01  -2.36481764120302E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98084785190446E-11   0.00000000000000E+00   1.98084785190446E-11
      3.75452516919784E-18  -2.36481812019882E-01  -2.33755043999206E-01   0.00000000000000E+00   4.66798233431454E-14
     -9.51865707826129E-23  -8.65498947837612E-09  -8.65494279855287E-09  -2.93348854501030E-18
      9.46230081523995E-10
      0.00000000000000E+00  -8.63533403698887E-12   0.00000000000000E+00   5.01909451955613E-16   1.19180438989879E-22
      8.63533807787191E-09   8.63533857978149E-09  -8.21059500414219E-19  -2.36456405497308E-01  -2.36456405497327E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96649408398424E-11   0.00000000000000E+00   1.96649408398424E-11
      3.75489127496789E-18  -2.36456797578463E-01  -2.33730010403454E-01   0.00000000000000E+00   4.61816394127165E-14
     -9.63375823394015E-23  -8.65504970226066E-09  -8.65500352062135E-09  -2.93383177455367E-18
      9.51230081523995E-10
      0.00000000000000E+00  -8.63533403698887E-12   0.00000000000000E+00   4.93034776651528E-16   1.19028070846762E-22
      8.63539172603916E-09   8.63539221907406E-09  -8.21065628862238E-19  -2.36449606888005E-01  -2.36449606888024E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96267333204381E-11   0.00000000000000E+00   1.96267333204381E-11
      3.75498940863449E-18  -2.36450102580816E-01  -2.33723310539018E-01   0.00000000000000E+00   4.60395096142007E-14
     -9.83232334369804E-23  -8.65506499190400E-09  -8.65501895239448E-09  -2.93392377977225E-18
      9.57980081523995E-10
      0.00000000000000E+00  -8.63542588172608E-12   0.00000000000000E+00   4.80026314236768E-16   1.19208498728890E-22
      8.63546243962012E-09   8.63546291964655E-09  -8.21073875160359E-19  -2.36440450288910E-01  -2.36440450288929E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95757866277616E-11   0.00000000000000E+00   1.95757866277616E-11
      3.75512154519423E-18  -2.36441107067366E-01  -2.33714308793664E-01   0.00000000000000E+00   4.58503948049981E-14
     -9.83781840462248E-23  -8.65508455666919E-09  -8.65503870627449E-09  -2.93404767003387E-18
      9.67092581523995E-10
      0.00000000000000E+00  -8.63551772646329E-12   0.00000000000000E+00   4.64154795113573E-16   1.18913287957008E-22
      8.63555500414870E-09   8.63555546830361E-09  -8.21084957926683E-19  -2.36428128651240E-01  -2.36428128651260E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95076128636366E-11   0.00000000000000E+00   1.95076128636366E-11
      3.75529930831645E-18  -2.36429043004808E-01  -2.33702237040726E-01   0.00000000000000E+00   4.55922206766437E-14
     -9.72498487370694E-23  -8.65510867338760E-09  -8.65506308116702E-09  -2.93421435038976E-18
      9.79394456523995E-10
      0.00000000000000E+00  -8.63570141593770E-12   0.00000000000000E+00   4.52521328244108E-16   1.31038948380510E-22
      8.63567710915900E-09   8.63567756168046E-09  -8.21099818324074E-19  -2.36411572768023E-01  -2.36411572768042E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94148613078476E-11   0.00000000000000E+00   1.94148613078476E-11
      3.75553814751340E-18  -2.36412904746027E-01  -2.33686089522990E-01   0.00000000000000E+00   4.52494218959430E-14
     -9.51962743916283E-23  -8.65513767241001E-09  -8.65509242298821E-09  -2.93443832918932E-18
      9.96001987773995E-10
      0.00000000000000E+00  -8.63588510541212E-12   0.00000000000000E+00   4.69602192080350E-16   1.11734245911757E-22
      8.63584770978038E-09   8.63584817938269E-09  -8.21119623888643E-19  -2.36389400045079E-01  -2.36389400045098E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92816379436478E-11   0.00000000000000E+00   1.92816379436478E-11
      3.75585836791810E-18  -2.36391379307046E-01  -2.33664552283177E-01   0.00000000000000E+00   4.48464588942755E-14
      2.46117795586225E-22  -8.65517466378554E-09  -8.65512981732640E-09  -2.93473874402945E-18
      1.01600198777400E-09
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   5.69017501745167E-16   1.19780679631994E-22
      8.63609324185700E-09   8.63609381087462E-09  -8.21142857810317E-19  -2.36363073167846E-01  -2.36363073167865E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90930884746064E-11   0.00000000000000E+00   1.90930884746064E-11
      3.75624022968759E-18  -2.36365763394667E-01  -2.33638918363685E-01   0.00000000000000E+00   4.45782866035701E-14
     -9.58207842990355E-23  -8.65523147763579E-09  -8.65518689934928E-09  -2.93509737187727E-18
      1.03600198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00   1.17678301483897E-15   1.20265010599608E-22
      8.63642069940114E-09   8.63642187618427E-09  -8.21165112107151E-19  -2.36337293373721E-01  -2.36337293373740E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88582872742369E-11   0.00000000000000E+00   1.88582872742369E-11
      3.75661739543307E-18  -2.36340302702165E-01  -2.33613428392474E-01   0.00000000000000E+00   4.42769382237381E-14
     -9.78832655241773E-23  -8.65532444039662E-09  -8.65528016345850E-09  -2.93545228332592E-18
      1.05600198777400E-09
      0.00000000000000E+00  -8.63689539752140E-12   0.00000000000000E+00   1.13820765154132E-16   1.20515365284725E-22
      8.63688360851433E-09   8.63688372233522E-09  -8.21185903276804E-19  -2.36312290180631E-01  -2.36312290180650E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85564859132011E-11   0.00000000000000E+00   1.85564859132011E-11
      3.75698852515134E-18  -2.36314745422411E-01  -2.33587820226696E-01   0.00000000000000E+00   4.63440852298236E-14
     -1.06248270475954E-22  -8.65548655233351E-09  -8.65544020824839E-09  -2.93580262187453E-18
      1.06100198777400E-09
      0.00000000000000E+00  -8.63707908699582E-12   0.00000000000000E+00   1.17734112624626E-15   1.28137156613061E-22
      8.63700682084004E-09   8.63700799818130E-09  -8.21191001536126E-19  -2.36306091540042E-01  -2.36306091540061E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84772425146475E-11   0.00000000000000E+00   1.84772425146475E-11
      3.75708091136391E-18  -2.36308347129634E-01  -2.33581408052403E-01   0.00000000000000E+00   4.55583909035387E-14
     -1.00014151896726E-22  -8.65553079908673E-09  -8.65548524069593E-09  -2.93588990982779E-18
      1.06775198777400E-09
      0.00000000000000E+00  -8.63717093173302E-12   0.00000000000000E+00   1.32912738837884E-15   1.20801267771576E-22
      8.63719292455024E-09   8.63719425367775E-09  -8.21197686550218E-19  -2.36297826777406E-01  -2.36297826777424E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83616517744388E-11   0.00000000000000E+00   1.83616517744388E-11
      3.75720485251339E-18  -2.36299679284541E-01  -2.33572717938369E-01   0.00000000000000E+00   4.58886990635614E-14
     -9.70250626182780E-23  -8.65560179415088E-09  -8.65555590545192E-09  -2.93600716596317E-18
      1.07686448777400E-09
      0.00000000000000E+00  -8.63744646594465E-12   0.00000000000000E+00   1.53591313581294E-15   1.25343294402497E-22
      8.63748204693536E-09   8.63748358284863E-09  -8.21206303254567E-19  -2.36286880440795E-01  -2.36286880440813E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81895142120502E-11   0.00000000000000E+00   1.81895142120502E-11
      3.75737060446165E-18  -2.36287889267290E-01  -2.33560890989323E-01   0.00000000000000E+00   4.64971113896061E-14
     -8.92796824732888E-23  -8.65571959417196E-09  -8.65567309706066E-09  -2.93616430120708E-18
      1.08916636277400E-09
      0.00000000000000E+00  -8.63799753436789E-12   0.00000000000000E+00   1.84859014628440E-15  -6.08920716258934E-23
      8.63794956773001E-09   8.63795141632010E-09  -8.21217087334772E-19  -2.36272538373267E-01  -2.36272538373285E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79276425734865E-11   0.00000000000000E+00   1.79276425734865E-11
      3.75759114807963E-18  -2.36271718883270E-01  -2.33544655702662E-01   0.00000000000000E+00   4.75961296344141E-14
      5.79214743134750E-23  -8.65592665502330E-09  -8.65587905889361E-09  -2.93637406074486E-18
      1.10577389402400E-09
      0.00000000000000E+00  -8.63873229226555E-12   0.00000000000000E+00   2.27233250824921E-15   1.11786712813303E-22
      8.63872228572041E-09   8.63872455805303E-09  -8.21229976370810E-19  -2.36254034502508E-01  -2.36254034502525E-01
      0.00000000000000E+00   0.00000000000000E+00   1.75336591127228E-11   0.00000000000000E+00   1.75336591127228E-11
      3.75788233887127E-18  -2.36249185475511E-01  -2.33522002820585E-01   0.00000000000000E+00   4.95277716426220E-14
     -9.42761591470531E-23  -8.65630774493735E-09  -8.65625821716580E-09  -2.93665236250046E-18
      1.12577389402400E-09
      0.00000000000000E+00  -8.63983442911204E-12   0.00000000000000E+00   2.54093307775465E-15   1.27264834120351E-22
      8.63978232596275E-09   8.63978486689595E-09  -8.21243477779526E-19  -2.36232824958238E-01  -2.36232824958255E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70670578829231E-11   0.00000000000000E+00   1.70670578829231E-11
      3.75822368002893E-18  -2.36220717600440E-01  -2.33493347854599E-01   0.00000000000000E+00   5.21196988118618E-14
     -9.61271134055648E-23  -8.65690404447756E-09  -8.65685192477885E-09  -2.93698020224940E-18
      1.13577389402400E-09
      0.00000000000000E+00  -8.64029365279808E-12   0.00000000000000E+00   2.56286622565287E-15   1.21278022877062E-22
      8.64032326572347E-09   8.64032582858982E-09  -8.21249815948067E-19  -2.36222446723524E-01  -2.36222446723541E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68485234957794E-11   0.00000000000000E+00   1.68485234957794E-11
      3.75839216526389E-18  -2.36206135248303E-01  -2.33478663897007E-01   0.00000000000000E+00   5.33918570216403E-14
     -9.14358495893878E-23  -8.65722774394250E-09  -8.65717435208557E-09  -2.93714234931582E-18
      1.14927389402400E-09
      0.00000000000000E+00  -8.64102841069574E-12   0.00000000000000E+00   2.57677000835753E-15   1.21575411933679E-22
      8.64103311684553E-09   8.64103569361566E-09  -8.21258122400733E-19  -2.36208626357842E-01  -2.36208626357858E-01
      0.00000000000000E+00   0.00000000000000E+00   1.66157960371168E-11   0.00000000000000E+00   1.66157960371168E-11
      3.75861647851039E-18  -2.36185785205821E-01  -2.33458163541334E-01   0.00000000000000E+00   5.46192347542983E-14
     -1.09795642921776E-22  -8.65770610888736E-09  -8.65765148965271E-09  -2.93735835610965E-18
      1.16749889402400E-09
      0.00000000000000E+00  -8.64167132385619E-12   0.00000000000000E+00   1.67284294006943E-15   1.21644769567869E-22
      8.64165695602962E-09   8.64165862887268E-09  -8.21271003585397E-19  -2.36189337122861E-01  -2.36189337122877E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65670730914852E-11   0.00000000000000E+00   1.65670730914852E-11
      3.75891841341748E-18  -2.36157579185961E-01  -2.33429776589517E-01   0.00000000000000E+00   5.46640687548384E-14
     -9.92374648351402E-23  -8.65828036603278E-09  -8.65822570196412E-09  -2.93764740983208E-18
      1.18749889402399E-09
      0.00000000000000E+00  -8.64139578964457E-12   0.00000000000000E+00  -5.12042668309383E-16   1.21854115918230E-22
      8.64143795128215E-09   8.64143743923961E-09  -8.21291632034201E-19  -2.36165334403584E-01  -2.36165334403601E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70694551533659E-11   0.00000000000000E+00   1.70694551533659E-11
      3.75925980252055E-18  -2.36127269608973E-01  -2.33399378408642E-01   0.00000000000000E+00   5.05426508559634E-14
     -1.02540755645631E-22  -8.65855743704370E-09  -8.65850689439295E-09  -2.93796817048635E-18
      1.20749889402399E-09
      0.00000000000000E+00  -8.63965073963763E-12   0.00000000000000E+00  -4.13158869647496E-15   1.21987209147909E-22
      8.63970216071475E-09   8.63969802912618E-09  -8.21324594643404E-19  -2.36135771713803E-01  -2.36135771713822E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83648780445052E-11   0.00000000000000E+00   1.83648780445052E-11
      3.75962710008144E-18  -2.36100307177845E-01  -2.33372555870462E-01   0.00000000000000E+00   4.00645246902274E-14
     -9.77616568775389E-23  -8.65810297169525E-09  -8.65806290717066E-09  -2.93830250543803E-18
      1.22749889402399E-09
      0.00000000000000E+00  -8.63588510541212E-12   0.00000000000000E+00  -9.08620226890668E-15   1.21839898676622E-22
      8.63587364313223E-09   8.63586455693009E-09  -8.21376078526545E-19  -2.36097731196291E-01  -2.36097731196312E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05982982926914E-11   0.00000000000000E+00   2.05982982926914E-11
      3.76003906604729E-18  -2.36080575951301E-01  -2.33353328790646E-01   0.00000000000000E+00   2.15377810285713E-14
     -8.21538523922034E-23  -8.65648439300380E-09  -8.65646285522285E-09  -2.93866298752075E-18
      1.24749889402399E-09
      0.00000000000000E+00  -8.62963966328201E-12   0.00000000000000E+00  -1.52102961501377E-14   1.20726608625806E-22
      8.62966534251151E-09   8.62965013221548E-09  -8.21450580581931E-19  -2.36049037071096E-01  -2.36049037071119E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36865464058897E-11   0.00000000000000E+00   2.36865464058897E-11
      3.76051279697541E-18  -2.36072696995464E-01  -2.33346434655012E-01   0.00000000000000E+00  -4.62048669034297E-15
     -6.59236189456549E-23  -8.65333205813454E-09  -8.65333667862130E-09  -2.93906221639348E-18
      1.26749889402399E-09
      0.00000000000000E+00  -8.62137363693333E-12   0.00000000000000E+00  -2.04076104764729E-14   1.20841863360532E-22
      8.62144015552285E-09   8.62141974791249E-09  -8.21547725742351E-19  -2.35989729802223E-01  -2.35989729802250E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71501999478162E-11   0.00000000000000E+00   2.71501999478162E-11
      3.76105580097437E-18  -2.36080920141041E-01  -2.33356159503793E-01   0.00000000000000E+00  -3.61050969077311E-14
     -9.44462893349937E-23  -8.64853384276331E-09  -8.64856994786031E-09  -2.93950807523202E-18
      1.28749889402399E-09
      0.00000000000000E+00  -8.61264838689861E-12   0.00000000000000E+00  -2.14667235078495E-14   1.20696176069390E-22
      8.61264090048554E-09   8.61261943376215E-09  -8.21658143228676E-19  -2.35923991636584E-01  -2.35923991636614E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99484476793209E-11   0.00000000000000E+00   2.99484476793209E-11
      3.76165476992795E-18  -2.36107190868814E-01  -2.33384321327085E-01   0.00000000000000E+00  -6.61962268628599E-14
     -9.21881621213234E-23  -8.64250168521459E-09  -8.64256788144155E-09  -2.93999662669928E-18
      1.30749889402399E-09
      0.00000000000000E+00  -8.60612741055688E-12   0.00000000000000E+00  -1.61235864791917E-14   1.20923282659974E-22
      8.60618599861255E-09   8.60616987502620E-09  -8.21759149854001E-19  -2.35862185627278E-01  -2.35862185627308E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03838483349909E-11   0.00000000000000E+00   3.03838483349909E-11
      3.76226244689465E-18  -2.36148404061830E-01  -2.33427429186226E-01   0.00000000000000E+00  -8.06055971369459E-14
     -9.69102688885852E-23  -8.63647311776393E-09  -8.63655372336116E-09  -2.94050329704065E-18
      1.32749889402399E-09
      0.00000000000000E+00  -8.60667847898012E-12   0.00000000000000E+00   1.31866579470787E-15   1.21038502059996E-22
      8.60664971086176E-09   8.60665102952768E-09  -8.21811713566522E-19  -2.35822328400061E-01  -2.35822328400087E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61745256251269E-11   0.00000000000000E+00   2.61745256251269E-11
      3.76278593740716E-18  -2.36193194295937E-01  -2.33473394140137E-01   0.00000000000000E+00  -6.24434392907689E-14
     -9.17284892241626E-23  -8.63276311171342E-09  -8.63282555515280E-09  -2.94097422384064E-18
      1.34749889402399E-09
      0.00000000000000E+00  -8.61999596587522E-12   0.00000000000000E+00   3.41351382778656E-14   1.21389389243074E-22
      8.61997748532453E-09   8.62001162046293E-09  -8.21761059147478E-19  -2.35829902882089E-01  -2.35829902882104E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48130749548371E-11   0.00000000000000E+00   1.48130749548371E-11
      3.76308219890625E-18  -2.36219016007028E-01  -2.33498586374716E-01   0.00000000000000E+00   1.03987439664651E-14
     -9.01320172257412E-23  -8.63483509416167E-09  -8.63482469541779E-09  -2.94132113975877E-18
      1.36749889402399E-09
      0.00000000000000E+00  -8.65250900284668E-12   0.00000000000000E+00   8.05596675339888E-14   1.22796432930853E-22
      8.65244825728031E-09   8.65252881694796E-09  -8.21543815943554E-19  -2.35914653261925E-01  -2.35914653261919E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68360985638385E-12   0.00000000000000E+00  -5.68360985638385E-12
      3.76296852670912E-18  -2.36190857637798E-01  -2.33466640636613E-01   0.00000000000000E+00   1.60552423142008E-13
     -9.70788185439729E-23  -8.64700575951466E-09  -8.64684520709161E-09  -2.94142471076557E-18
      1.38749889402399E-09
      0.00000000000000E+00  -8.70871798201769E-12   0.00000000000000E+00   1.39467556138179E-13   1.24511373594712E-22
      8.70860889792021E-09   8.70874836547648E-09  -8.21104687013093E-19  -2.36102957858163E-01  -2.36102957858127E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.55779080829083E-11   0.00000000000000E+00  -3.55779080829083E-11
      3.76225696854746E-18  -2.36063430697380E-01  -2.33330919904365E-01   0.00000000000000E+00   3.93612116935141E-13
     -9.94646410354367E-23  -8.67356406951041E-09  -8.67317045739358E-09  -2.94115228153437E-18
      1.39749889402399E-09
      0.00000000000000E+00  -8.74315975847051E-12   0.00000000000000E+00   1.70878577290120E-13   1.25243673389293E-22
      8.74300434817162E-09   8.74317522674903E-09  -8.20824138154934E-19  -2.36225666895801E-01  -2.36225666895749E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27462848331154E-11   0.00000000000000E+00  -5.27462848331154E-11
      3.76172950569914E-18  -2.35968644879266E-01  -2.33230696760717E-01   0.00000000000000E+00   5.30626957185705E-13
     -9.84980561508350E-23  -8.69095956887293E-09  -8.69042894191584E-09  -2.94090536754420E-18
      1.41099889402399E-09
      0.00000000000000E+00  -8.80093009817404E-12   0.00000000000000E+00   2.14589789027571E-13   1.26207207145582E-22
      8.80074861461247E-09   8.80096320440162E-09  -8.20328266726436E-19  -2.36446549119317E-01  -2.36446549119238E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.89703916884585E-11   0.00000000000000E+00  -7.89703916884585E-11
      3.76066340541134E-18  -2.35768395215424E-01  -2.33020503406245E-01   0.00000000000000E+00   7.47110790650922E-13
     -9.47029985791624E-23  -8.72273992350360E-09  -8.72199281271304E-09  -2.94033513868491E-18
      1.42922389402399E-09
      0.00000000000000E+00  -8.89259114590715E-12   0.00000000000000E+00   2.52049870799343E-13   1.27975575148717E-22
      8.89232706039901E-09   8.89257911026993E-09  -8.19482748376171E-19  -2.36829333295098E-01  -2.36829333294984E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13807170610705E-10   0.00000000000000E+00  -1.13807170610705E-10
      3.75858926972696E-18  -2.35336635435741E-01  -2.32570855052311E-01   0.00000000000000E+00   1.06201850418985E-12
     -9.74763632264245E-23  -8.77983395816337E-09  -8.77877193965928E-09  -2.93910652135079E-18
      1.44922389402399E-09
      0.00000000000000E+00  -8.98590539891000E-12   0.00000000000000E+00   2.32758488894691E-13   1.30121412483079E-22
      8.98565349082711E-09   8.98588624931613E-09  -8.18513978731929E-19  -2.37273826034917E-01  -2.37273826034780E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36508938666402E-10   0.00000000000000E+00  -1.36508938666402E-10
      3.75585909095363E-18  -2.34668291762468E-01  -2.31880265932820E-01   0.00000000000000E+00   1.32543348910518E-12
     -9.74752555301738E-23  -8.85070274413868E-09  -8.84937731064967E-09  -2.93734511222170E-18
      1.46922389402399E-09
      0.00000000000000E+00  -9.02999087276961E-12   0.00000000000000E+00   1.17939893332966E-13   1.31488916870259E-22
      9.02993207416298E-09   9.03005001405645E-09  -8.17837530997406E-19  -2.37589891194922E-01  -2.37589891194800E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21608433623991E-10   0.00000000000000E+00  -1.21608433623991E-10
      3.75342692228115E-18  -2.33880362533520E-01  -2.31073729665114E-01   0.00000000000000E+00   1.32782204899570E-12
     -9.73821146803169E-23  -8.90976940248126E-09  -8.90844158043236E-09  -2.93558939128374E-18
      1.48922389402399E-09
      0.00000000000000E+00  -8.96450557514065E-12   0.00000000000000E+00  -1.12692897032652E-13   1.31293902442176E-22
      8.96463139726863E-09   8.96451870437173E-09  -8.17968888332977E-19  -2.37538890926520E-01  -2.37538890926479E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.12826591176426E-11   0.00000000000000E+00  -4.12826591176426E-11
      3.75260126909880E-18  -2.33162364643608E-01  -2.30351082668004E-01   0.00000000000000E+00   8.19782741240019E-13
     -9.73356957951266E-23  -8.92405582799529E-09  -8.92323604525414E-09  -2.93463238076582E-18
      1.50922389402399E-09
      0.00000000000000E+00  -8.71735138731519E-12   0.00000000000000E+00  -6.11808463890991E-13   1.28293961063701E-22
      8.71797535928546E-09   8.71736355082170E-09  -8.19586198341833E-19  -2.36803872040607E-01  -2.36803872040740E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32871102131649E-10   0.00000000000000E+00   1.32871102131649E-10
      3.75525869114143E-18  -2.32843985397475E-01  -2.30055686155413E-01   0.00000000000000E+00  -3.25927049549554E-13
     -9.73978304238909E-23  -8.84990872590364E-09  -8.85023465295329E-09  -2.93567249279960E-18
      1.52922389402399E-09
      0.00000000000000E+00  -8.22589019851772E-12   0.00000000000000E+00  -6.14576925651985E-13   1.20870316265900E-22
      8.22714141477678E-09   8.22652683785125E-09  -8.23435384362557E-19  -2.35031397887515E-01  -2.35031397887934E-01
      0.00000000000000E+00   0.00000000000000E+00   4.18377251160682E-10   0.00000000000000E+00   4.18377251160682E-10
      3.76362623616465E-18  -2.33378369794594E-01  -2.30654949680869E-01   0.00000000000000E+00  -3.08186019916127E-12
     -9.76346028743881E-23  -8.64182222881278E-09  -8.64490408901203E-09  -2.94019085180209E-18
      1.54922389402399E-09
      0.00000000000000E+00  -7.47257966394158E-12   0.00000000000000E+00  -1.87096341331375E-12   1.09124796257313E-22
      7.47447036064134E-09   7.47259939722813E-09  -8.30125126106244E-19  -2.31925304831799E-01  -2.31925304832602E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03139596074152E-10   0.00000000000000E+00   8.03139596074152E-10
      3.77968902808613E-18  -2.35242186110872E-01  -2.32634881644064E-01   0.00000000000000E+00  -5.64491825235689E-12
     -9.81337042362503E-23  -8.27009407504979E-09  -8.27573899330224E-09  -2.94956390197989E-18
      1.56922389402399E-09
      0.00000000000000E+00  -6.53052819440398E-12   0.00000000000000E+00  -2.34364521701801E-12   9.33239071847070E-23
      6.53284651025875E-09   6.53050286504183E-09  -8.39716642216113E-19  -2.27437140144207E-01  -2.27437140145427E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21952295807171E-09   0.00000000000000E+00   1.21952295807171E-09
      3.80407948724756E-18  -2.38754847858950E-01  -2.36313170965230E-01   0.00000000000000E+00  -9.54860915284549E-12
     -9.89674776270406E-23  -7.74047721396069E-09  -7.75002582311363E-09  -2.96436284503145E-18
      1.58922389402399E-09
      0.00000000000000E+00  -5.59857964595921E-12   0.00000000000000E+00  -2.32448745470187E-12   7.62413349481458E-23
      5.60090329581009E-09   5.59857880835547E-09  -8.51118457743732E-19  -2.22054518411613E-01  -2.22054518413138E-01
      0.00000000000000E+00   0.00000000000000E+00   1.52565598406050E-09   0.00000000000000E+00   1.52565598406050E-09
      3.83459260692877E-18  -2.43856761473838E-01  -2.41612243163314E-01   0.00000000000000E+00  -1.32058785250021E-11
     -1.00058948715601E-22  -7.11102891389087E-09  -7.12423479241597E-09  -2.98347414918504E-18
      1.60922389402399E-09
      0.00000000000000E+00  -4.99304729354998E-12   0.00000000000000E+00  -1.51964205497740E-12   6.26231033715152E-23
      4.99460216826202E-09   4.99308252620711E-09  -8.61399521840644E-19  -2.17137065852422E-01  -2.17137065853934E-01
      0.00000000000000E+00   0.00000000000000E+00   1.51258144729808E-09   0.00000000000000E+00   1.51258144729808E-09
      3.86484423587473E-18  -2.49988422742612E-01  -2.47938790466393E-01   0.00000000000000E+00  -1.46955030041092E-11
     -1.01202829291447E-22  -6.49096847050097E-09  -6.50566397350518E-09  -3.00344471403409E-18
      1.62922389402399E-09
      0.00000000000000E+00  -5.07910581231344E-12   0.00000000000000E+00   1.97416299783562E-13   5.79653177315188E-23
      5.07895393946218E-09   5.07915135576202E-09  -8.65696810252679E-19  -2.14975573286274E-01  -2.14975573287246E-01
      0.00000000000000E+00   0.00000000000000E+00   9.72007630634057E-10   0.00000000000000E+00   9.72007630634057E-10
      3.88428438848742E-18  -2.56115418690107E-01  -2.54208986877209E-01   0.00000000000000E+00  -1.15304115028549E-11
     -1.02148648910241E-22  -6.03962857489300E-09  -6.05115898639595E-09  -3.01858757823474E-18
      1.64922389402399E-09
      0.00000000000000E+00  -6.16204710872739E-12   0.00000000000000E+00   2.68062836578345E-12   6.82872363210390E-23
      6.15936501128816E-09   6.16204563965401E-09  -8.58927219409569E-19  -2.17968594969573E-01  -2.17968594969420E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53126662683814E-10   0.00000000000000E+00  -1.53126662683814E-10
      3.88122185523374E-18  -2.60737339444203E-01  -2.58844227513418E-01   0.00000000000000E+00  -2.44303741480899E-12
     -1.01291679055961E-22  -6.00647593955537E-09  -6.00891897697028E-09  -3.02229463582417E-18
      1.66922389402399E-09
      0.00000000000000E+00  -8.37357653594742E-12   0.00000000000000E+00   5.49264841742481E-12   9.98659008329019E-23
      8.36809468054102E-09   8.37358732895854E-09  -8.39523262460127E-19  -2.26821173424481E-01  -2.26821173422866E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61452329880731E-09   0.00000000000000E+00  -1.61452329880731E-09
      3.84893138925759E-18  -2.61769467224119E-01  -2.59640033593251E-01   0.00000000000000E+00   1.02577284461407E-11
     -1.01472711910392E-22  -6.76932175859724E-09  -6.75906403015120E-09  -3.00940812679747E-18
      1.68922389402399E-09
      0.00000000000000E+00  -1.15192587853052E-11   0.00000000000000E+00   7.81426235810593E-12   1.54427523423578E-22
      1.15114646811478E-08   1.15192789435061E-08  -8.12018449748058E-19  -2.39397729042861E-01  -2.39397729039934E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92704215390774E-09   0.00000000000000E+00  -2.92704215390774E-09
      3.79039054617944E-18  -2.56789680521995E-01  -2.54082706821578E-01   0.00000000000000E+00   2.14917244603907E-11
     -9.96390180927228E-23  -8.61372851405856E-09  -8.59223678959827E-09  -2.97837209643138E-18
      1.70922389402399E-09
      0.00000000000000E+00  -1.50011846175798E-11   0.00000000000000E+00   8.64658066341773E-12   2.23855123983664E-22
      1.49925617596487E-08   1.50012083403124E-08  -7.83947890926049E-19  -2.52307256051347E-01  -2.52307256047575E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.77226658282048E-09   0.00000000000000E+00  -3.77226658282048E-09
      3.71494521452303E-18  -2.44094168813343E-01  -2.40556482377789E-01   0.00000000000000E+00   2.83614480447195E-11
     -9.69941016966443E-23  -1.12573032055366E-08  -1.12289417574920E-08  -2.93099732359698E-18
      1.72922389402399E-09
      0.00000000000000E+00  -1.82106989592968E-11   0.00000000000000E+00   7.96965365372960E-12   2.93816573777544E-22
      1.82027377770185E-08   1.82107074306725E-08  -7.59718014584137E-19  -2.63683616008521E-01  -2.63683616004216E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.30510205238128E-09   0.00000000000000E+00  -4.30510205238128E-09
      3.62884317347541E-18  -2.23312261305708E-01  -2.18931253744354E-01   0.00000000000000E+00   3.20822278609298E-11
     -9.37095279589010E-23  -1.39376876061520E-08  -1.39056053782912E-08  -2.86912515889127E-18
      1.74922389402399E-09
      0.00000000000000E+00  -2.09501519359857E-11   0.00000000000000E+00   6.80328232082975E-12   3.54866923947336E-22
      2.09433194344936E-08   2.09501227168148E-08  -7.39257622804627E-19  -2.73661751060340E-01  -2.73661751055453E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.88704686905935E-09   0.00000000000000E+00  -4.88704686905935E-09
      3.53110223609422E-18  -1.94745743376469E-01  -1.89684974762825E-01   0.00000000000000E+00   3.41656733335669E-11
     -8.98176597085254E-23  -1.60972415210889E-08  -1.60630758477554E-08  -2.79184461328959E-18
      1.76922389402399E-09
      0.00000000000000E+00  -2.32469132793343E-11   0.00000000000000E+00   5.71000934099090E-12   4.05900287771994E-22
      2.32412119055563E-08   2.32469219148977E-08  -7.20934394336456E-19  -2.83025436722724E-01  -2.83025436717045E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.67958562203446E-09   0.00000000000000E+00  -5.67958562203446E-09
      3.41751052365353E-18  -1.59072244325399E-01  -1.53537505834683E-01   0.00000000000000E+00   3.42218832441671E-11
     -8.53204395058971E-23  -1.76015581761074E-08  -1.75673362928633E-08  -2.69657612931707E-18
      1.78922389402399E-09
      0.00000000000000E+00  -2.48552064725753E-11   0.00000000000000E+00   4.00512076282640E-12   4.42206324755706E-22
      2.48512291700456E-08   2.48552342908088E-08  -7.04236681185732E-19  -2.92009489872130E-01  -2.92009489865633E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49692779478915E-09   0.00000000000000E+00  -6.49692779478915E-09
      3.28757196775775E-18  -1.18484508380018E-01  -1.12700524085866E-01   0.00000000000000E+00   3.12548455089468E-11
     -7.58009316199120E-23  -1.83895613415285E-08  -1.83583064960196E-08  -2.58333528657201E-18
      1.80922389402399E-09
      0.00000000000000E+00  -2.53929574089254E-11   0.00000000000000E+00   1.63943842527774E-12   4.55004303637048E-22
      2.53916248191195E-08   2.53932642575452E-08  -6.88432529962272E-19  -3.00844313157424E-01  -3.00844313150279E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.14454420328672E-09   0.00000000000000E+00  -7.14454420328672E-09
      3.14468108369201E-18  -7.78168917306279E-02  -7.20674857241838E-02   0.00000000000000E+00   2.56042918267310E-11
     -1.74324099134839E-23  -1.82743243460853E-08  -1.82487200542586E-08  -2.45624855372974E-18
      1.82922389402399E-09
      0.00000000000000E+00  -2.44125148392350E-11   0.00000000000000E+00  -2.36323273685721E-12   4.62919205406314E-22
      2.44148771057705E-08   2.44125138730341E-08  -6.67489542273911E-19  -3.11671553511887E-01  -3.11671553504317E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.56906341805617E-09   0.00000000000000E+00  -7.56906341805617E-09
      2.99329981533089E-18  -4.55939071036784E-02  -4.02871425044333E-02   0.00000000000000E+00   2.02817669096559E-11
      1.58783169101658E-22  -1.68637322218878E-08  -1.68434504549779E-08  -2.32581027305698E-18
      1.84922389402399E-09
      0.00000000000000E+00  -2.24021253864995E-11   0.00000000000000E+00  -4.91543456810834E-12   4.93776196886941E-22
      2.24070824666409E-08   2.24021670320733E-08  -6.35314109696477E-19  -3.26552505024522E-01  -3.26552505016791E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.73169230922397E-09   0.00000000000000E+00  -7.73169230922397E-09
      2.83866596914641E-18  -2.71225089675794E-02  -2.25003515446264E-02   0.00000000000000E+00   1.52666706388212E-11
      3.95589820939892E-22  -1.46857413934885E-08  -1.46704747228493E-08  -2.20335185944993E-18
      1.86922389402399E-09
      0.00000000000000E+00  -2.07192542666460E-11   0.00000000000000E+00  -4.10952501007340E-12   5.27432129875679E-22
      2.07233347091914E-08   2.07192251841818E-08  -5.96779848173330E-19  -3.43604392595850E-01  -3.43604392588201E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.64838916391719E-09   0.00000000000000E+00  -7.64838916391719E-09
      2.68569818586806E-18  -1.83528650733421E-02  -1.42346895007942E-02   0.00000000000000E+00   1.01036776935989E-11
      5.95551939580857E-22  -1.30809396979589E-08  -1.30708360202647E-08  -2.08891833769473E-18
      1.88922389402399E-09
      0.00000000000000E+00  -1.96061878964279E-11   0.00000000000000E+00  -2.70743730607414E-12   5.36522432094788E-22
      1.96089359609518E-08   1.96062285236462E-08  -5.58595387873046E-19  -3.60388971466617E-01  -3.60388971459258E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.35890492967185E-09   0.00000000000000E+00  -7.35890492967185E-09
      2.53852008727463E-18  -1.41423447731948E-02  -1.02836239235174E-02   0.00000000000000E+00   6.35928910363057E-12
      7.01021413037803E-22  -1.22536828830786E-08  -1.22473235939743E-08  -1.97992469940158E-18
      1.90922389402399E-09
      0.00000000000000E+00  -1.86432876715442E-11   0.00000000000000E+00  -2.34193173925448E-12   5.06579716341404E-22
      1.86456651209190E-08   1.86433231891802E-08  -5.24834552505238E-19  -3.75387627419811E-01  -3.75387627413047E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76382882555465E-09   0.00000000000000E+00  -6.76382882555465E-09
      2.40324351076353E-18  -1.18886347570929E-02  -8.14580026132448E-03   0.00000000000000E+00   4.14204199547531E-12
      7.12012646181732E-22  -1.18836364056218E-08  -1.18794943636256E-08  -1.87840895825829E-18
      1.92922389402399E-09
      0.00000000000000E+00  -1.72465129080922E-11   0.00000000000000E+00  -3.42091566609051E-12   4.44709785420385E-22
      1.72498816440788E-08   1.72464607284131E-08  -5.00040016906564E-19  -3.86714320014298E-01  -3.86714320008857E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44090351826032E-09   0.00000000000000E+00  -5.44090351826032E-09
      2.29442544039833E-18  -1.05870994046478E-02  -6.86755641564547E-03   0.00000000000000E+00   2.34321620125774E-12
      6.46380153649932E-22  -1.18079004263547E-08  -1.18055572101528E-08  -1.79438542349176E-18
      1.94922389402399E-09
      0.00000000000000E+00  -1.44139293678748E-11   0.00000000000000E+00  -6.97445176885413E-12   3.57145030216504E-22
      1.44208825016741E-08   1.44139080499056E-08  -4.93666527283067E-19  -3.90362955077848E-01  -3.90362955075362E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48616564811855E-09   0.00000000000000E+00  -2.48616564811855E-09
      2.24470212743596E-18  -9.80754964973655E-03  -6.04950771371698E-03   0.00000000000000E+00   1.10135914123743E-13
      5.30108216418346E-22  -1.19278525377017E-08  -1.19277424017871E-08  -1.75103560015289E-18
      1.96922389402399E-09
      0.00000000000000E+00  -9.37257174255369E-12   0.00000000000000E+00  -1.24463904631493E-11   2.50433397193421E-22
      9.38499996766210E-09   9.37255357719920E-09  -5.19798902195283E-19  -3.80497401406799E-01  -3.80497401409441E-01
      0.00000000000000E+00   0.00000000000000E+00   2.64196606227882E-09   0.00000000000000E+00   2.64196606227882E-09
      2.29754144868153E-18  -9.36144942652302E-03  -5.57606540646008E-03   0.00000000000000E+00  -2.92662413627744E-12
      3.72535453102734E-22  -1.20115930153421E-08  -1.20145196394780E-08  -1.77774254648625E-18
      1.98922389402399E-09
      0.00000000000000E+00  -3.30934957106160E-12   0.00000000000000E+00  -1.50160233350331E-11   1.32006256202849E-22
      3.32440675541265E-09   3.30939073207775E-09  -5.88650041353553E-19  -3.52996563686521E-01  -3.52996563695139E-01
      0.00000000000000E+00   0.00000000000000E+00   8.61835900925589E-09   0.00000000000000E+00   8.61835900925589E-09
      2.46990862886665E-18  -9.71391556084043E-03  -5.95587023361254E-03   0.00000000000000E+00  -7.69483768204455E-12
      1.83692400344262E-22  -1.19200549036517E-08  -1.19277497413336E-08  -1.88125858751310E-18
      2.00922389402399E-09
      0.00000000000000E+00   1.51654030077068E-12   0.00000000000000E+00  -1.20512764621391E-11   2.68577054883471E-23
     -1.50451085260915E-09  -1.51656212907127E-09  -6.96833867566428E-19  -3.08363635434804E-01  -3.08363635447812E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30079649819317E-08   0.00000000000000E+00   1.30079649819317E-08
      2.73006792850528E-18  -1.28455119876989E-02  -9.22494728041681E-03   0.00000000000000E+00  -1.55099868966258E-11
      6.49925843465710E-24  -1.14758928659639E-08  -1.14914028528605E-08  -2.03323406093886E-18
      2.02922389402399E-09
      0.00000000000000E+00   4.39605650170106E-12   0.00000000000000E+00  -7.35591490654635E-12  -2.89648870888335E-23
     -4.38864268952750E-09  -4.39599860443407E-09  -8.22928046162444E-19  -2.52813525462326E-01  -2.52813525477039E-01
      0.00000000000000E+00   0.00000000000000E+00   1.47126310528261E-08   0.00000000000000E+00   1.47126310528261E-08
      3.02432054956181E-18  -2.34027436691524E-02  -2.01523113118197E-02   0.00000000000000E+00  -2.82255332469340E-11
     -7.42953007294588E-23  -1.02884069151449E-08  -1.03166324483919E-08  -2.20139250339936E-18
      2.04922389402399E-09
      0.00000000000000E+00   5.54631999048813E-12   0.00000000000000E+00  -3.18899935092739E-12  -4.22083314032755E-23
     -5.54312339457505E-09  -5.54631239392602E-09  -9.45076119917991E-19  -1.94399998296429E-01  -1.94399998310846E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44169304598108E-08   0.00000000000000E+00   1.44169304598108E-08
      3.31265915875803E-18  -4.24028460905418E-02  -3.96080024006094E-02   0.00000000000000E+00  -4.81965687370876E-11
     -8.55699595245002E-23  -8.82242149714771E-09  -8.87061806588488E-09  -2.36758303884003E-18
      2.06922389402399E-09
      0.00000000000000E+00   5.34150622651534E-12   0.00000000000000E+00   7.07527001578203E-14  -4.46768195479727E-23
     -5.34158184137486E-09  -5.34151108867474E-09  -1.05371281548876E-18  -1.38390885117467E-01  -1.38390885130549E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30816544653416E-08   0.00000000000000E+00   1.30816544653416E-08
      3.57429224806485E-18  -6.67934208311698E-02  -6.43547490494870E-02   0.00000000000000E+00  -7.45581322648732E-11
     -9.37459468653610E-23  -7.66558524440188E-09  -7.74014337666685E-09  -2.52057943257609E-18
      2.07922389402399E-09
      0.00000000000000E+00   4.88026195625914E-12   0.00000000000000E+00   1.78261238393031E-12  -4.53691449952247E-23
     -4.88203097088933E-09  -4.88024835850545E-09  -1.10264475808694E-18  -1.11822975797406E-01  -1.11822975809389E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19827464638263E-08   0.00000000000000E+00   1.19827464638263E-08
      3.69411971270312E-18  -8.03730519653274E-02  -7.81352720788150E-02   0.00000000000000E+00  -9.68150708148386E-11
     -9.81469887335867E-23  -7.00568303450601E-09  -7.10249810532095E-09  -2.59147495461618E-18
      2.09272389402399E-09
      0.00000000000000E+00   4.16543436657296E-12   0.00000000000000E+00   2.13169807809247E-12  -4.62075725654158E-23
     -4.16753127532164E-09  -4.16539957724360E-09  -1.15842360916070E-18  -8.03774912456195E-02  -8.03774912561866E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05670799620493E-08   0.00000000000000E+00   1.05670799620493E-08
      3.83677529219078E-18  -1.00452514444469E-01  -9.84355392652796E-02   0.00000000000000E+00  -1.11949153046762E-10
     -1.03992064602135E-22  -6.28973123175868E-09  -6.40168038480555E-09  -2.67835168303009E-18
      2.11094889402399E-09
      0.00000000000000E+00   2.93462304325489E-12   0.00000000000000E+00   2.93789041200682E-12  -4.70453458765438E-23
     -2.93752033686302E-09  -2.93458244645106E-09  -1.21095395910508E-18  -4.94840379857716E-02  -4.94840379940787E-02
      0.00000000000000E+00   0.00000000000000E+00   8.30715135366483E-09   0.00000000000000E+00   8.30715135366483E-09
      3.98817312561132E-18  -1.30614937932157E-01  -1.28922203712629E-01   0.00000000000000E+00  -1.22245714928021E-10
     -1.11377611431110E-22  -5.25032319228563E-09  -5.37256890721376E-09  -2.77721916650624E-18
      2.13094889402399E-09
      0.00000000000000E+00   1.58579123262516E-12   0.00000000000000E+00   3.09651040073166E-12  -4.75058002265168E-23
     -1.58886618911662E-09  -1.58576967871594E-09  -1.24154833417850E-18  -3.06904973681949E-02  -3.06904973739925E-02
      0.00000000000000E+00   0.00000000000000E+00   5.79756113265199E-09   0.00000000000000E+00   5.79756113265199E-09
      4.10412434826436E-18  -1.66054591413826E-01  -1.64727580307258E-01   0.00000000000000E+00  -1.22980318071169E-10
     -1.18228715094554E-22  -4.08881113586477E-09  -4.21179145393605E-09  -2.86257601408586E-18
      2.15094889402399E-09
      0.00000000000000E+00   7.68373071478169E-13   0.00000000000000E+00   1.91154110087927E-12  -4.77002140391977E-23
     -7.70298378077152E-10  -7.68386836976320E-10  -1.25579910983492E-18  -2.15151076046723E-02  -2.15151076087236E-02
      0.00000000000000E+00   0.00000000000000E+00   4.05138210301677E-09   0.00000000000000E+00   4.05138210301677E-09
      4.18515199032470E-18  -2.00122156715153E-01  -1.99087778449380E-01   0.00000000000000E+00  -1.17784931813015E-10
     -1.24241567599104E-22  -3.16521033422727E-09  -3.28299526604041E-09  -2.92935288048977E-18
      2.17094889402399E-09
      0.00000000000000E+00   4.12199180587380E-13   0.00000000000000E+00   8.32336788393594E-13  -4.77915236564961E-23
     -4.13052259211168E-10  -4.12219922422822E-10  -1.26294512749773E-18  -1.67153533325992E-02  -1.67153533355621E-02
      0.00000000000000E+00   0.00000000000000E+00   2.96291489247958E-09   0.00000000000000E+00   2.96291489247958E-09
      4.24441028817429E-18  -2.29387631171084E-01  -2.28583977533845E-01   0.00000000000000E+00  -1.06593531075103E-10
     -1.29165181316787E-22  -2.44410143898162E-09  -2.55069497005685E-09  -2.98146516067656E-18
      2.19094889402399E-09
      0.00000000000000E+00   2.67727408959940E-13   0.00000000000000E+00   3.33091709574869E-13  -4.78429471181185E-23
     -2.68102524920992E-10  -2.67769433211465E-10  -1.26722005123239E-18  -1.38215065941109E-02  -1.38215065963022E-02
      0.00000000000000E+00   0.00000000000000E+00   2.19124675128236E-09   0.00000000000000E+00   2.19124675128236E-09
      4.28823522319994E-18  -2.52217607092198E-01  -2.51611571761686E-01   0.00000000000000E+00  -8.86797766788697E-11
     -1.32999086565920E-22  -1.83479754139186E-09  -1.92347731807086E-09  -3.02101517196755E-18
      2.21094889402399E-09
      0.00000000000000E+00   2.02150266593766E-13   0.00000000000000E+00   1.48862244781987E-13  -4.78752487959050E-23
     -2.02276097590529E-10  -2.02127235345795E-10  -1.27019641025752E-18  -1.18863654717350E-02  -1.18863654733292E-02
      0.00000000000000E+00   0.00000000000000E+00   1.59420569317310E-09   0.00000000000000E+00   1.59420569317310E-09
      4.32011933706340E-18  -2.68612417840890E-01  -2.68173812780330E-01   0.00000000000000E+00  -6.69672777838613E-11
     -1.35771975882144E-22  -1.32511118004331E-09  -1.39207845782731E-09  -3.04992292680589E-18
      2.23094889402399E-09
      0.00000000000000E+00   1.66606353294454E-13   0.00000000000000E+00   7.99776635338100E-14  -4.78963561936751E-23
     -1.66695835161301E-10  -1.66615857497815E-10  -1.27247329783968E-18  -1.05188599595026E-02  -1.05188599606385E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13588439737215E-09   0.00000000000000E+00   1.13588439737215E-09
      4.34283702501084E-18  -2.79518387317774E-01  -2.79213000042883E-01   0.00000000000000E+00  -4.57363258324053E-11
     -1.37649326710302E-22  -9.23532214041767E-10  -9.69268539874310E-10  -3.07036372717117E-18
      2.25094889402399E-09
      0.00000000000000E+00   1.40155068978686E-13   0.00000000000000E+00   6.16365681634256E-14  -4.79082948973003E-23
     -1.40232994265377E-10  -1.40171357697261E-10  -1.27423011291212E-18  -9.55388178164813E-03  -9.55388178248829E-03
      0.00000000000000E+00   0.00000000000000E+00   8.40155256915353E-10   0.00000000000000E+00   8.40155256915353E-10
      4.35964013014915E-18  -2.86934156745386E-01  -2.86713615328501E-01   0.00000000000000E+00  -3.09768263773029E-11
     -1.38872978275570E-22  -6.69007072840574E-10  -6.99983899218016E-10  -3.08541001723702E-18
      2.27094889402399E-09
      0.00000000000000E+00   1.19673692581407E-13   0.00000000000000E+00   5.00489950957522E-14  -4.79131111413417E-23
     -1.19731734238966E-10  -1.19681685243918E-10  -1.27558562912182E-18  -8.85879040184624E-03  -8.85879040255461E-03
      0.00000000000000E+00   0.00000000000000E+00   7.08369819297359E-10   0.00000000000000E+00   7.08369819297359E-10
      4.37380752653510E-18  -2.93040149266507E-01  -2.92854674759894E-01   0.00000000000000E+00  -2.51004494322471E-11
     -1.39785606723767E-22  -5.63587684621112E-10  -5.88688134053498E-10  -3.09822189741328E-18
      2.29094889402399E-09
      0.00000000000000E+00   1.07182808321184E-13   0.00000000000000E+00   3.20358441951026E-14  -4.79139639469999E-23
     -1.07236946130540E-10  -1.07204910286392E-10  -1.27670025981165E-18  -8.30869451353601E-03  -8.30869451419755E-03
      0.00000000000000E+00   0.00000000000000E+00   6.61540351680567E-10   0.00000000000000E+00   6.61540351680567E-10
      4.38703833356871E-18  -2.98826156483517E-01  -2.98651505729734E-01   0.00000000000000E+00  -2.36942237081085E-11
     -1.40743412730566E-22  -5.30641217685908E-10  -5.54335441394157E-10  -3.11033807375706E-18
      2.30094889402399E-09
      0.00000000000000E+00   1.01580279351525E-13   0.00000000000000E+00   2.98745680171228E-14  -4.79134014001633E-23
     -1.01582639647521E-10  -1.01552765079552E-10  -1.27720320676317E-18  -8.06811492009489E-03  -8.06811492072611E-03
      0.00000000000000E+00   0.00000000000000E+00   6.31229324178192E-10   0.00000000000000E+00   6.31229324178192E-10
      4.39335062681049E-18  -3.01573130011464E-01  -3.01406248738485E-01   0.00000000000000E+00  -2.24140626110573E-11
     -1.41185532696397E-22  -5.07262496487509E-10  -5.29676559098708E-10  -3.11614742004732E-18
      2.31444889402399E-09
      0.00000000000000E+00   9.13855135214891E-14   0.00000000000000E+00   4.07124520185264E-14  -4.79100949484206E-23
     -9.13836253073732E-11  -9.13429128554026E-11  -1.27774874182415E-18  -7.80523922311772E-03  -7.80523922378454E-03
      0.00000000000000E+00   0.00000000000000E+00   6.66819643010384E-10   0.00000000000000E+00   6.66819643010384E-10
      4.40235269199113E-18  -3.05845012922252E-01  -3.05663700709563E-01   0.00000000000000E+00  -2.62021365286627E-11
     -1.41852187078014E-22  -5.49274593626129E-10  -5.75476730154933E-10  -3.12460395016699E-18
      2.33267389402399E-09
      0.00000000000000E+00   7.66903555682848E-14   0.00000000000000E+00   4.52914686616569E-14  -4.79010360794506E-23
     -7.67057208502618E-11  -7.66604293816480E-11  -1.27822770603862E-18  -7.53684734859953E-03  -7.53684734940829E-03
      0.00000000000000E+00   0.00000000000000E+00   8.08760523865950E-10   0.00000000000000E+00   8.08760523865950E-10
      4.41709235253859E-18  -3.13912200772588E-01  -3.13681539226653E-01   0.00000000000000E+00  -3.80839564582839E-11
     -1.43106545955046E-22  -6.94016138025763E-10  -7.32100094484190E-10  -3.13886464649997E-18
      2.35267389402399E-09
      0.00000000000000E+00   6.59445213150042E-14   0.00000000000000E+00   3.33939369814302E-14  -4.78879334325749E-23
     -6.59791750061010E-11  -6.59457810691675E-11  -1.27855407057501E-18  -7.26423487793359E-03  -7.26423487894567E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01208506965912E-09   0.00000000000000E+00   1.01208506965912E-09
      4.43733405393177E-18  -3.26110576317211E-01  -3.25812474670652E-01   0.00000000000000E+00  -5.51601004092714E-11
     -1.45104506785964E-22  -8.90979188180520E-10  -9.46139288589937E-10  -3.15877998335677E-18
      2.37267389402399E-09
      0.00000000000000E+00   7.19144292334934E-14   0.00000000000000E+00  -9.07895235988630E-15  -4.78784866682212E-23
     -7.18788491378444E-11  -7.18879280902522E-11  -1.27901509846558E-18  -6.85666072494120E-03  -6.85666072607578E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13457538596707E-09   0.00000000000000E+00   1.13457538596707E-09
      4.46002556165111E-18  -3.40018064624794E-01  -3.39683240481331E-01   0.00000000000000E+00  -6.63774640443369E-11
     -1.47281723032462E-22  -9.96309993832367E-10  -1.06268745787685E-09  -3.18101046318553E-18
      2.39267389402399E-09
      0.00000000000000E+00   8.61503635006601E-14   0.00000000000000E+00  -3.24550963445553E-14  -4.78749352631269E-23
     -8.60988550786659E-11  -8.61313101750583E-11  -1.27977596672043E-18  -6.25637511069832E-03  -6.25637511187052E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17219635352121E-09   0.00000000000000E+00   1.17219635352121E-09
      4.48346948872154E-18  -3.54169765859036E-01  -3.53827575562481E-01   0.00000000000000E+00  -7.13387233414849E-11
     -1.49713340253962E-22  -1.01472632000457E-09  -1.08606504334621E-09  -3.20369352200111E-18
      2.41267389402399E-09
      0.00000000000000E+00   9.33142530028472E-14   0.00000000000000E+00  -1.68461487916124E-14  -4.78741090282548E-23
     -9.33441752339058E-11  -9.33610213827453E-11  -1.28069549252210E-18  -5.56565042277661E-03  -5.56565042393636E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15975981979775E-09   0.00000000000000E+00   1.15975981979775E-09
      4.50666468511749E-18  -3.68011968797553E-01  -3.67675974719989E-01   0.00000000000000E+00  -7.31005957414435E-11
     -1.52100433841597E-22  -9.93298202673276E-10  -1.06639879841487E-09  -3.22596919259539E-18
      2.43267389402399E-09
      0.00000000000000E+00   7.81598713636053E-14   0.00000000000000E+00   4.06586271588721E-14  -4.78667655422438E-23
     -7.81867691353832E-11  -7.81461105082722E-11  -1.28132516650250E-18  -5.05788978980304E-03  -5.05788979090618E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10314325664885E-09   0.00000000000000E+00   1.10314325664885E-09
      4.52872755025047E-18  -3.81462153747718E-01  -3.81139204434137E-01   0.00000000000000E+00  -7.28153490169374E-11
     -1.54435539608219E-22  -9.52181797123565E-10  -1.02499714614066E-09  -3.24740238374797E-18
      2.45267389402399E-09
      0.00000000000000E+00   2.75534211622580E-15   0.00000000000000E+00   2.01341368541479E-13  -4.78294209690972E-23
     -2.92802668821464E-12  -2.72668531972099E-12  -1.28046535182131E-18  -5.45167822357286E-03  -5.45167822452427E-03
      0.00000000000000E+00   0.00000000000000E+00   9.51411706754717E-10   0.00000000000000E+00   9.51411706754717E-10
      4.54775578438556E-18  -3.94634735889895E-01  -3.94335831330089E-01   0.00000000000000E+00  -6.87560869687169E-11
     -1.56594089544493E-22  -8.79928934466067E-10  -9.48685021434940E-10  -3.26729043256425E-18
      2.47267389402399E-09
      0.00000000000000E+00  -3.68021861990560E-13   0.00000000000000E+00   9.89069706646367E-13  -4.76437941124431E-23
      3.67074664869705E-10   3.68063734576303E-10  -1.27223698103486E-18  -1.02524454195449E-02  -1.02524454198746E-02
      0.00000000000000E+00   0.00000000000000E+00   3.29710994322932E-10   0.00000000000000E+00   3.29710994322932E-10
      4.55435000427202E-18  -4.08028855250500E-01  -4.07809009791350E-01   0.00000000000000E+00  -4.62371701270748E-11
     -1.58001456495012E-22  -6.51537558771924E-10  -6.97774728899157E-10  -3.28211302323716E-18
      2.49267389402399E-09
      0.00000000000000E+00  -1.20849305217664E-12   0.00000000000000E+00   2.27362376180537E-12  -4.71396256736562E-23
      1.20618582097133E-09   1.20845944473309E-09  -1.24735561541756E-18  -2.48121501701298E-02  -2.48121501690968E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.03304471141231E-09   0.00000000000000E+00  -1.03304471141231E-09
      4.53368911004377E-18  -4.22301939004228E-01  -4.22246684889993E-01   0.00000000000000E+00   5.62953917811673E-12
     -1.57833035854883E-22  -1.81044272498858E-10  -1.75414733320899E-10  -3.28633349462621E-18
      2.51267389402399E-09
      0.00000000000000E+00  -1.94398570773451E-12   0.00000000000000E+00   2.12065075269116E-12  -4.64104421229592E-23
      1.94184807594566E-09   1.94396872669831E-09  -1.20819184249783E-18  -4.72108149552013E-02  -4.72108149530094E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.19184736103019E-09   0.00000000000000E+00  -2.19184736103019E-09
      4.48985216282317E-18  -4.37094061782093E-01  -4.37172191271923E-01   0.00000000000000E+00   4.77216823646879E-11
     -1.56348333777453E-22   2.00156951967377E-10   2.47878634331909E-10  -3.28166032032534E-18
      2.53267389402399E-09
      0.00000000000000E+00  -2.55383476279249E-12   0.00000000000000E+00   1.83108326145819E-12  -4.55370049161416E-23
      2.55196949987393E-09   2.55380058313534E-09  -1.15799599980486E-18  -7.49749912959568E-02  -7.49749912928873E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.06951778457773E-09   0.00000000000000E+00  -3.06951778457773E-09
      4.42846180713162E-18  -4.52006786012102E-01  -4.52169309900475E-01   0.00000000000000E+00   7.51292449296500E-11
     -1.54015671297804E-22   4.40587956512865E-10   5.15717201442361E-10  -3.27046580732675E-18
      2.54267389402399E-09
      0.00000000000000E+00  -2.97705531184477E-12   0.00000000000000E+00   2.40357415109203E-12  -4.50324234406331E-23
      2.97466683105529E-09   2.97707040520634E-09  -1.12927877417355E-18  -9.04182392671710E-02  -9.04182392635417E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.62929711554185E-09   0.00000000000000E+00  -3.62929711554185E-09
      4.39216883597620E-18  -4.59453065054969E-01  -4.59658602574269E-01   0.00000000000000E+00   8.94752996158511E-11
     -1.52611677132513E-22   5.62751410719893E-10   6.52226710335591E-10  -3.26289006180265E-18
      2.55617389402399E-09
      0.00000000000000E+00  -3.54594161410819E-12   0.00000000000000E+00   2.40199002826171E-12  -4.41152179091883E-23
      3.54354899956371E-09   3.54595098959193E-09  -1.08505677275530E-18  -1.13579671351278E-01  -1.13579671347013E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.26526942898248E-09   0.00000000000000E+00  -4.26526942898248E-09
      4.33458769868493E-18  -4.69423892121740E-01  -4.69650582247131E-01   0.00000000000000E+00   1.04548381049268E-10
     -1.50361414749094E-22   6.14770058341360E-10   7.19318439390478E-10  -3.24953092592963E-18
      2.57439889402399E-09
      0.00000000000000E+00  -4.56890829712563E-12   0.00000000000000E+00   3.07565186429328E-12  -4.10571319392776E-23
      4.56583425382346E-09   4.56890990568771E-09  -1.01726064048476E-18  -1.47741873363440E-01  -1.47741873358433E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.00651980066787E-09   0.00000000000000E+00  -5.00651980066787E-09
      4.24334387531776E-18  -4.81959900096700E-01  -4.82097871746273E-01   0.00000000000000E+00   1.18594316758391E-10
     -1.46811071230533E-22   3.19015578221925E-10   4.37609894980170E-10  -3.22608323483300E-18
      2.59439889402399E-09
      0.00000000000000E+00  -6.55661209977092E-12   0.00000000000000E+00   5.15778652414565E-12  -2.79848722817228E-23
      6.55143300476890E-09   6.55659079129301E-09  -9.38926725789241E-19  -1.85373046228258E-01  -1.85373046222726E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53167941563937E-09   0.00000000000000E+00  -5.53167941563937E-09
      4.13271028700498E-18  -4.92175170948771E-01  -4.91852449852344E-01   0.00000000000000E+00   1.24216256574442E-10
     -1.42487210295092E-22  -1.14912763222795E-09  -1.02491137565365E-09  -3.19378356121574E-18
      2.61439889402399E-09
      0.00000000000000E+00  -1.06178026896133E-11   0.00000000000000E+00   1.02026531085794E-11   1.20174847337129E-23
      1.06076227666207E-08   1.06178254197293E-08  -8.64038724204366E-19  -2.19763753057229E-01  -2.19763753051367E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86220630518641E-09   0.00000000000000E+00  -5.86220630518641E-09
      4.01546616090125E-18  -4.94341677242868E-01  -4.92843733806178E-01   0.00000000000000E+00   1.28504940788418E-10
     -1.37569838759673E-22  -4.88412405533108E-09  -4.75561911454280E-09  -3.15142743669688E-18
      2.63439889402399E-09
      0.00000000000000E+00  -1.74312126746165E-11   0.00000000000000E+00   1.69351402520279E-11   8.24400977919242E-23
      1.74142787658878E-08   1.74312139061399E-08  -7.99372400904434E-19  -2.48566846757359E-01  -2.48566846751191E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16711208528861E-09   0.00000000000000E+00  -6.16711208528861E-09
      3.89212391919547E-18  -4.82821185505991E-01  -4.79272904389378E-01   0.00000000000000E+00   1.37986208276956E-10
     -1.31556688483774E-22  -1.14020880291283E-08  -1.12641018208514E-08  -3.09275151829104E-18
      2.65439889402399E-09
      0.00000000000000E+00  -2.56301923651324E-11   0.00000000000000E+00   2.03366376146507E-11   1.67769156041876E-22
      2.56098116988575E-08   2.56301483364723E-08  -7.49040013077123E-19  -2.70849244441140E-01  -2.70849244434648E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49191175039052E-09   0.00000000000000E+00  -6.49191175039052E-09
      3.76228568418766E-18  -4.53688569327196E-01  -4.47659607160101E-01   0.00000000000000E+00   1.48047149305595E-10
     -1.24074576403430E-22  -1.92862837353873E-08  -1.91382365860818E-08  -3.01324567111054E-18
      2.67439889402399E-09
      0.00000000000000E+00  -3.23803213261996E-11   0.00000000000000E+00   1.67567898859550E-11   2.40580826658769E-22
      3.23635995023747E-08   3.23803562922609E-08  -7.13826631841264E-19  -2.86873848848955E-01  -2.86873848842146E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80949000074168E-09   0.00000000000000E+00  -6.80949000074168E-09
      3.62609588417283E-18  -4.06303572980206E-01  -3.98247908517090E-01   0.00000000000000E+00   1.50820081979033E-10
     -1.15336049074465E-22  -2.57216863734980E-08  -2.55708662915191E-08  -2.91226925233156E-18
      2.69439889402399E-09
      0.00000000000000E+00  -3.53848382144694E-11   0.00000000000000E+00   7.48734890367974E-12   2.78005178224794E-22
      3.53773720204967E-08   3.53848593694007E-08  -6.92404009243367E-19  -2.97466132730418E-01  -2.97466132723319E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.09873600540950E-09   0.00000000000000E+00  -7.09873600540950E-09
      3.48412116406464E-18  -3.43022607323203E-01  -3.34111290142067E-01   0.00000000000000E+00   1.42425017441962E-10
     -1.06204580106335E-22  -2.84285483814331E-08  -2.82861233639912E-08  -2.79171715482128E-18
      2.71439889402399E-09
      0.00000000000000E+00  -3.47736114883533E-11   0.00000000000000E+00  -1.46313096404125E-12   2.78423245185637E-22
      3.47750576917995E-08   3.47735945608358E-08  -6.80770578767873E-19  -3.04307654055617E-01  -3.04307654048314E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30259337159680E-09   0.00000000000000E+00  -7.30259337159680E-09
      3.33806929663271E-18  -2.71549262548771E-01  -2.62894545079927E-01   0.00000000000000E+00   1.18605261632729E-10
     -9.70494491191183E-23  -2.75896064508716E-08  -2.74710011892390E-08  -2.65729871786483E-18
      2.73439889402399E-09
      0.00000000000000E+00  -3.29052139993406E-11   0.00000000000000E+00  -4.47778857660956E-12   2.61577604163989E-22
      3.29097586335193E-08   3.29052808449429E-08  -6.72499746360705E-19  -3.09908809752483E-01  -3.09908809745134E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34897652442928E-09   0.00000000000000E+00  -7.34897652442928E-09
      3.19108976614412E-18  -2.03029072691636E-01  -1.94977467423164E-01   0.00000000000000E+00   8.40338037161180E-11
     -8.81290559186360E-23  -2.56403381242297E-08  -2.55563043205136E-08  -2.51859001978341E-18
      2.75439889402399E-09
      0.00000000000000E+00  -3.10910967500175E-11   0.00000000000000E+00  -4.47659865521740E-12   2.40409109081343E-22
      3.10955905945655E-08   3.10911139959106E-08  -6.64418835616661E-19  -3.15477967536838E-01  -3.15477967529532E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30621692218568E-09   0.00000000000000E+00  -7.30621692218568E-09
      3.04496542770041E-18  -1.41376192288092E-01  -1.33882540341124E-01   0.00000000000000E+00   5.67166567422520E-11
     -8.13518369514345E-23  -2.38416137304671E-08  -2.37848970737249E-08  -2.38054659208374E-18
      2.77439889402399E-09
      0.00000000000000E+00  -2.93194117692844E-11   0.00000000000000E+00  -4.36867708899445E-12   2.19728936098854E-22
      2.93238224922814E-08   2.93194538151926E-08  -6.55123696200015E-19  -3.21521830610658E-01  -3.21521830603436E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22183498473776E-09   0.00000000000000E+00  -7.22183498473776E-09
      2.90052872800565E-18  -8.79290354122709E-02  -8.09669136511037E-02   0.00000000000000E+00   3.89572289755579E-11
     -6.38135156751906E-23  -2.21365760594303E-08  -2.20976188304548E-08  -2.24540503180564E-18
      2.78439889402399E-09
      0.00000000000000E+00  -2.78712957977333E-11   0.00000000000000E+00  -7.11735881400302E-12   2.10077490939779E-22
      2.78784952580849E-08   2.78713778992711E-08  -6.49292614160470E-19  -3.24947250824251E-01  -3.24947250817108E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.14304466510951E-09   0.00000000000000E+00  -7.14304466510951E-09
      2.82909828135456E-18  -6.49526867669092E-02  -5.84219556478967E-02   0.00000000000000E+00   3.18213276004480E-11
     -3.18327570973285E-23  -2.07601545617621E-08  -2.07283332341617E-08  -2.17980566719409E-18
      2.79789889402399E-09
      0.00000000000000E+00  -2.57071582549123E-11   0.00000000000000E+00  -7.89476674796305E-12   2.08111613282373E-22
      2.57150659330731E-08   2.57071711663253E-08  -6.35716899758334E-19  -3.31568393835990E-01  -3.31568393829093E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.89665924749496E-09   0.00000000000000E+00  -6.89665924749496E-09
      2.73599338151337E-18  -4.27889811155144E-02  -3.68624601136668E-02   0.00000000000000E+00   2.44525457986997E-11
      4.69294924710743E-23  -1.88349644646291E-08  -1.88105119188304E-08  -2.10027648175504E-18
      2.81612389402399E-09
      0.00000000000000E+00  -2.30949102392558E-11   0.00000000000000E+00  -7.04615627616798E-12   2.25006099691102E-22
      2.31019311558030E-08   2.30948849995271E-08  -6.07793040116773E-19  -3.43802247724970E-01  -3.43802247718427E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.54337375376061E-09   0.00000000000000E+00  -6.54337375376061E-09
      2.61674039485109E-18  -2.68427074955913E-02  -2.16279005925315E-02   0.00000000000000E+00   1.67068279879370E-11
      1.62665684671525E-22  -1.65682180737546E-08  -1.65515112457665E-08  -2.00894735473431E-18
      2.83612389402399E-09
      0.00000000000000E+00  -2.12762007530724E-11   0.00000000000000E+00  -4.37514641582163E-12   2.50222856237320E-22
      2.12806147842595E-08   2.12762396378439E-08  -5.72147233114471E-19  -3.58885486116640E-01  -3.58885486110358E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28177288357072E-09   0.00000000000000E+00  -6.28177288357072E-09
      2.49110493717967E-18  -1.88251045913848E-02  -1.41008831755660E-02   0.00000000000000E+00   1.04441049519654E-11
      2.65201793686147E-22  -1.50049108592255E-08  -1.49944667542732E-08  -1.91895770406520E-18
      2.85612389402399E-09
      0.00000000000000E+00  -2.02152103488511E-11   0.00000000000000E+00  -2.57866800939684E-12   2.66338135192455E-22
      2.02178043360783E-08   2.02152256680691E-08  -5.36446155030249E-19  -3.73928913159397E-01  -3.73928913153269E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12744308928774E-09   0.00000000000000E+00  -6.12744308928774E-09
      2.36855607539392E-18  -1.48186103181386E-02  -1.03800238187169E-02   0.00000000000000E+00   7.05748273942350E-12
      3.32977214152138E-22  -1.40948400615211E-08  -1.40877825787814E-08  -1.83210992036367E-18
      2.87612389402399E-09
      0.00000000000000E+00  -1.94460106747380E-11   0.00000000000000E+00  -1.86571863528723E-12   2.66085827190887E-22
      1.94478162637687E-08   1.94459505451337E-08  -5.02426444333112E-19  -3.88357913996779E-01  -3.88357913990763E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01564357782159E-09   0.00000000000000E+00  -6.01564357782159E-09
      2.24824320383749E-18  -1.24303751207947E-02  -8.19893053076879E-03   0.00000000000000E+00   5.46680691155586E-12
      3.61990301597774E-22  -1.34357737742240E-08  -1.34303069673121E-08  -1.74581675950437E-18
      2.89612389402399E-09
      0.00000000000000E+00  -1.87864736168508E-11   0.00000000000000E+00  -1.59811962651899E-12   2.49779689032998E-22
      1.87880683899702E-08   1.87864702703439E-08  -4.70231888483858E-19  -4.02130088133585E-01  -4.02130088127667E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91853087065116E-09   0.00000000000000E+00  -5.91853087065116E-09
      2.12987258642446E-18  -1.08106437300554E-02  -6.75637873268321E-03   0.00000000000000E+00   4.63286118190515E-12
      3.58091697389414E-22  -1.28725722608751E-08  -1.28679393996928E-08  -1.65964069794060E-18
      2.91612389402399E-09
      0.00000000000000E+00  -1.82193323645943E-11   0.00000000000000E+00  -1.37294345392917E-12   2.21570423970764E-22
      1.82207105198864E-08   1.82193375764327E-08  -4.39503437476139E-19  -4.15358868048037E-01  -4.15358868042205E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83185616260895E-09   0.00000000000000E+00  -5.83185616260895E-09
      2.01323546317228E-18  -9.64109571345129E-03  -5.73820436392130E-03   0.00000000000000E+00   4.03086478404379E-12
      3.27135912489063E-22  -1.23915122786081E-08  -1.23874814138237E-08  -1.57373202569614E-18
      2.93612389402399E-09
      0.00000000000000E+00  -1.77551490627474E-11   0.00000000000000E+00  -1.12105246325498E-12   1.85993307148054E-22
      1.77562896201789E-08   1.77551685677158E-08  -4.09761591006134E-19  -4.28195342565401E-01  -4.28195342559635E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.76598516005525E-09   0.00000000000000E+00  -5.76598516005525E-09
      1.89791575997118E-18  -8.76626299245053E-03  -4.98885990679133E-03   0.00000000000000E+00   3.55066543606956E-12
      2.78952117232689E-22  -1.19927340730969E-08  -1.19891834076606E-08  -1.48815416896505E-18
      2.95612389402399E-09
      0.00000000000000E+00  -1.75307723697495E-11   0.00000000000000E+00  -5.31209612725809E-13   1.48129275755696E-22
      1.75313335990263E-08   1.75308023894138E-08  -3.79940835316554E-19  -4.41049547348009E-01  -4.41049547342172E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83721593543211E-09   0.00000000000000E+00  -5.83721593543211E-09
      1.78117144126254E-18  -8.12051742433404E-03  -4.43624519046708E-03   0.00000000000000E+00   3.14336141662977E-12
      2.23943349533487E-22  -1.16967298153985E-08  -1.16935864539817E-08  -1.40123060594598E-18
      2.97612389402399E-09
      0.00000000000000E+00  -1.77770999549400E-11   0.00000000000000E+00   6.29092851340567E-13   1.11779843696267E-22
      1.77764455966561E-08   1.77770746895075E-08  -3.48278740551145E-19  -4.54659394101009E-01  -4.54659394094793E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.21665117925384E-09   0.00000000000000E+00  -6.21665117925384E-09
      1.65683841767746E-18  -7.69487181617692E-03  -4.05255288619784E-03   0.00000000000000E+00   2.73119185038453E-12
      1.68088118500939E-22  -1.15631547021042E-08  -1.15604235102537E-08  -1.30855967712631E-18
      2.99612389402399E-09
      0.00000000000000E+00  -1.80764219534994E-11   0.00000000000000E+00   7.62338183976499E-13   7.89595906498501E-23
      1.80757077639058E-08   1.80764701020899E-08  -3.15453699189866E-19  -4.68764363513564E-01  -4.68764363507028E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53641661238938E-09   0.00000000000000E+00  -6.53641661238938E-09
      1.52611008542967E-18  -7.38442725302896E-03  -3.74852425623159E-03   0.00000000000000E+00   2.39741518798905E-12
      1.16773470399155E-22  -1.15424509048886E-08  -1.15400534897005E-08  -1.21065638623981E-18
      3.01612389402399E-09
      0.00000000000000E+00  -1.82501003515588E-11   0.00000000000000E+00   4.51876082509261E-13   5.18228546533063E-23
      1.82496585586239E-08   1.82501104347065E-08  -2.82613918372609E-19  -4.82927307006689E-01  -4.82927306999996E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69251143549641E-09   0.00000000000000E+00  -6.69251143549641E-09
      1.39225985671974E-18  -7.12969540012213E-03  -3.48826246607386E-03   0.00000000000000E+00   2.17826070711855E-12
      7.39737217364031E-23  -1.15597772599173E-08  -1.15575989992101E-08  -1.10964593834713E-18
      3.02612389402399E-09
      0.00000000000000E+00  -1.83644470493822E-11   0.00000000000000E+00   5.85268846631733E-13   3.97053036609279E-23
      1.83638606964441E-08   1.83644459652908E-08  -2.66357632376292E-19  -4.89988783545162E-01  -4.89988783538378E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78388666659542E-09   0.00000000000000E+00  -6.78388666659542E-09
      1.32442099005379E-18  -7.03069162190099E-03  -3.38202367274851E-03   0.00000000000000E+00   2.00008794283310E-12
      5.46819698363729E-23  -1.15825593866383E-08  -1.15805592986954E-08  -1.05806335767750E-18
      3.03287389402399E-09
      0.00000000000000E+00  -1.84789774366800E-11   0.00000000000000E+00   8.56362128339219E-13   3.25407997381686E-23
      1.84780844168345E-08   1.84789407789629E-08  -2.55433608368225E-19  -4.94754747863744E-01  -4.94754747856908E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83651599144384E-09   0.00000000000000E+00  -6.83651599144384E-09
      1.27827450711154E-18  -6.99321641902822E-03  -3.32505588390973E-03   0.00000000000000E+00   1.60686527217322E-12
      4.32708382178760E-23  -1.16440316527912E-08  -1.16424247875190E-08  -1.02284089874332E-18
      3.04198639402399E-09
      0.00000000000000E+00  -1.86368585399397E-11   0.00000000000000E+00   8.76066676701093E-13   2.48899036652668E-23
      1.86360195489634E-08   1.86368956156402E-08  -2.40808290978784E-19  -5.01158542609240E-01  -5.01158542602385E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.85548291474418E-09   0.00000000000000E+00  -6.85548291474418E-09
      1.21580391905094E-18  -6.97218347636768E-03  -3.26023133241100E-03   0.00000000000000E+00   1.24865258381047E-12
      3.11252717246529E-23  -1.17826613534798E-08  -1.17814127008959E-08  -9.74995628072154E-19
      3.05428826902399E-09
      0.00000000000000E+00  -1.86854444059225E-11   0.00000000000000E+00   2.16631300773641E-13   1.74689983636541E-23
      1.86851994328621E-08   1.86854160641629E-08  -2.21811468556555E-19  -5.09520798459218E-01  -5.09520798452498E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71922259549724E-09   0.00000000000000E+00  -6.71922259549724E-09
      1.13314488258395E-18  -6.93707554664230E-03  -3.16690374288935E-03   0.00000000000000E+00   1.14045148962283E-12
      1.94461782827061E-23  -1.19673339201553E-08  -1.19661934686657E-08  -9.11333414027400E-19
      3.07089580027399E-09
      0.00000000000000E+00  -1.80998423614873E-11   0.00000000000000E+00  -1.71842201394868E-12   1.11142259885088E-23
      1.81015908517135E-08   1.80998724296996E-08  -1.99569859119840E-19  -5.19371364172958E-01  -5.19371364166969E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98953177862488E-09   0.00000000000000E+00  -5.98953177862488E-09
      1.03367354639757E-18  -6.80828846235818E-03  -2.99269914163133E-03   0.00000000000000E+00   1.16617036461739E-12
      9.74887253449661E-24  -1.21115068214394E-08  -1.21103406510748E-08  -8.34103687277733E-19
      3.09089580027399E-09
      0.00000000000000E+00  -1.58048260681456E-11   0.00000000000000E+00  -5.64446288216024E-12   6.58424235779531E-24
      1.58104926416326E-08   1.58048481787505E-08  -1.83837164151813E-19  -5.26310158885209E-01  -5.26310158881564E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64511532125883E-09   0.00000000000000E+00  -3.64511532125883E-09
      9.60771239972397E-19  -6.50331788024329E-03  -2.67216527305135E-03   0.00000000000000E+00   8.08426496440774E-13
      3.39869005057185E-24  -1.21605412839881E-08  -1.21597328574917E-08  -7.76934075820585E-19
      3.11089580027399E-09
      0.00000000000000E+00  -1.09158388618518E-11   0.00000000000000E+00  -1.20470277628485E-11   3.44515137096154E-24
      1.09278460440629E-08   1.09157990163001E-08  -1.89746921872718E-19  -5.23400735094516E-01  -5.23400735095759E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24295833906840E-09   0.00000000000000E+00   1.24295833906840E-09
      9.85630406753765E-19  -5.99666869680327E-03  -2.16582233541543E-03   0.00000000000000E+00  -2.93227427581541E-13
     -2.88848259728664E-25  -1.21584641279409E-08  -1.21587573553685E-08  -7.95883484881046E-19
      3.13089580027399E-09
      0.00000000000000E+00  -3.52996062983408E-12   0.00000000000000E+00  -1.82136819538299E-11   2.70711607163671E-25
      3.54812510644220E-09   3.52991142448837E-09  -2.29466100120302E-19  -5.05430021948124E-01  -5.05430021956738E-01
      0.00000000000000E+00   0.00000000000000E+00   8.61414414264173E-09   0.00000000000000E+00   8.61414414264173E-09
      1.15791328960660E-18  -5.29802122701552E-03  -1.47180656155322E-03   0.00000000000000E+00  -2.22539572799567E-12
     -3.69416421216464E-24  -1.21418301714022E-08  -1.21440555671302E-08  -9.28447189486298E-19
      3.15089580027399E-09
      0.00000000000000E+00   4.32166226456296E-12   0.00000000000000E+00  -1.93939706501581E-11  -4.87119171830079E-24
     -4.30225571808760E-09  -4.32164968873776E-09  -3.12260234406135E-19  -4.69679566435959E-01  -4.69679566452395E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64354713012812E-08   0.00000000000000E+00   1.64354713012812E-08
      1.48662271563222E-18  -4.54098893630503E-03  -7.24300558735167E-04   0.00000000000000E+00  -5.08184952881909E-12
     -1.06721301588218E-23  -1.21087397630146E-08  -1.21138216125434E-08  -1.17436248122609E-18
      3.17089580027399E-09
      0.00000000000000E+00   9.81067113903359E-12   0.00000000000000E+00  -1.36457283138897E-11  -1.61244389596558E-23
     -9.79701076633293E-09  -9.81065649464684E-09  -4.42713531754266E-19  -4.16435201598006E-01  -4.16435201619878E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18716970145200E-08   0.00000000000000E+00   2.18716970145200E-08
      1.92405665592262E-18  -3.92364146452456E-03  -1.23584917533805E-04   0.00000000000000E+00  -9.56797362780313E-12
     -2.99397554294014E-23  -1.20514725462452E-08  -1.20610405198731E-08  -1.48134312416836E-18
      3.19089580027399E-09
      0.00000000000000E+00   1.10106226306499E-11   0.00000000000000E+00  -3.17196793144408E-12  -3.28438852285191E-23
     -1.10074106393458E-08  -1.10105826072772E-08  -6.14343098533610E-19  -3.48194042494592E-01  -3.48194042517549E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29565378645971E-08   0.00000000000000E+00   2.29565378645971E-08
      2.38318741321457E-18  -3.90465047114766E-03  -1.40857775999332E-04   0.00000000000000E+00  -1.74695370637063E-11
     -6.12095285053312E-23  -1.19284857202562E-08  -1.19459552573200E-08  -1.76884431468096E-18
      3.21089580027399E-09
      0.00000000000000E+00   9.02099008852328E-12   0.00000000000000E+00   4.57886330228506E-12  -4.07721945891510E-23
     -9.02563001020141E-09  -9.02105114689916E-09  -7.93003368307642E-19  -2.72750510154312E-01  -2.72750510174638E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03256985084491E-08   0.00000000000000E+00   2.03256985084491E-08
      2.78970138338355E-18  -8.12823239652031E-03  -4.56650067529248E-03   0.00000000000000E+00  -2.99022178771785E-11
     -7.64799980617317E-23  -1.12747451436728E-08  -1.13046473615500E-08  -1.99669801507591E-18
      3.23089580027399E-09
      0.00000000000000E+00   7.30092185010072E-12   0.00000000000000E+00   3.83373850318278E-12  -4.31184397973577E-23
     -7.30474407856139E-09  -7.30091034005825E-09  -9.43289089910977E-19  -2.01969339535858E-01  -2.01969339552891E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70336901519136E-08   0.00000000000000E+00   1.70336901519136E-08
      3.13037518642182E-18  -2.26388265957871E-02  -1.95723412963690E-02   0.00000000000000E+00  -4.72889410281921E-11
     -8.41425537627370E-23  -9.68549087082695E-09  -9.73277981185523E-09  -2.18708609651084E-18
      3.25089580027399E-09
      0.00000000000000E+00   6.03989360824137E-12   0.00000000000000E+00   2.62606578469098E-12  -4.49149751703834E-23
     -6.04252836992338E-09  -6.03990230413873E-09  -1.06436714248505E-18  -1.39381437652892E-01  -1.39381437667245E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43527761101204E-08   0.00000000000000E+00   1.43527761101204E-08
      3.41743070862423E-18  -4.52695294079886E-02  -4.26504087980838E-02   0.00000000000000E+00  -7.26512362287781E-11
     -9.26977648122113E-23  -8.24022256975275E-09  -8.31287380598162E-09  -2.35306356613918E-18
      3.25589580027399E-09
      0.00000000000000E+00   5.59692644068947E-12   0.00000000000000E+00   3.80154406747925E-12  -4.53453568983171E-23
     -5.60072560799885E-09  -5.59692406393142E-09  -1.09230501498208E-18  -1.24215109153622E-01  -1.24215109167039E-01
      0.00000000000000E+00   0.00000000000000E+00   1.34164004260809E-08   0.00000000000000E+00   1.34164004260809E-08
      3.48451271075463E-18  -5.16047555101136E-02  -4.91410763898034E-02   0.00000000000000E+00  -9.19591711001624E-11
     -9.49330303992031E-23  -7.72751719104913E-09  -7.81947636214939E-09  -2.39220769577255E-18
      3.26264580027399E-09
      0.00000000000000E+00   5.13191653620776E-12   0.00000000000000E+00   2.84533784032900E-12  -4.58932644064926E-23
     -5.13476284311894E-09  -5.13191750527866E-09  -1.12669326901725E-18  -1.05108530799898E-01  -1.05108530812412E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25138653713904E-08   0.00000000000000E+00   1.25138653713904E-08
      3.56898130201152E-18  -6.08738552719179E-02  -5.85480261720958E-02   0.00000000000000E+00  -1.02227145778874E-10
     -9.79351791912914E-23  -7.27972072033283E-09  -7.38194786611181E-09  -2.44228803299427E-18
      3.27175830027399E-09
      0.00000000000000E+00   4.53198671276820E-12   0.00000000000000E+00   2.69786897308294E-12  -4.65490680100486E-23
     -4.53471344717729E-09  -4.53201557820426E-09  -1.16746911344794E-18  -8.18246307023437E-02  -8.18246307137275E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13838591546310E-08   0.00000000000000E+00   1.13838591546310E-08
      3.67271671855809E-18  -7.44483617363751E-02  -7.22895514681863E-02   0.00000000000000E+00  -1.12982660891575E-10
     -1.01938573847484E-22  -6.73886091553520E-09  -6.85184357642687E-09  -2.50524760511016E-18
      3.27790923777399E-09
      0.00000000000000E+00   4.01480899755262E-12   0.00000000000000E+00   3.60496093341572E-12  -4.69339054401261E-23
     -4.01845174198327E-09  -4.01484678104990E-09  -1.19176895335880E-18  -6.76233498482660E-02  -6.76233498587010E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04350772138619E-08   0.00000000000000E+00   1.04350772138619E-08
      3.73690222630823E-18  -8.41952422287540E-02  -8.21724163888301E-02   0.00000000000000E+00  -1.22196316799266E-10
     -1.04625662511168E-22  -6.29803411601248E-09  -6.42023043281185E-09  -2.54513327294943E-18
      3.28621300339899E-09
      0.00000000000000E+00   3.26857050774146E-12   0.00000000000000E+00   3.96476332918398E-12  -4.73451981196654E-23
     -3.27248987770737E-09  -3.26852511437824E-09  -1.21833602631230E-18  -5.17713151127948E-02  -5.17713151219089E-02
      0.00000000000000E+00   0.00000000000000E+00   9.11421044640431E-09   0.00000000000000E+00   9.11421044640431E-09
      3.81258449371210E-18  -9.83718291193614E-02  -9.65300250194303E-02   0.00000000000000E+00  -1.26235996517537E-10
     -1.08116498196488E-22  -5.71944933550839E-09  -5.84568533202604E-09  -2.59424846739980E-18
      3.29742308699274E-09
      0.00000000000000E+00   2.26195218794697E-12   0.00000000000000E+00   4.08754428842287E-12  -4.77040816985045E-23
     -2.26603652146056E-09  -2.26194897717218E-09  -1.24289337729865E-18  -3.67323746978760E-02  -3.67323747052096E-02
      0.00000000000000E+00   0.00000000000000E+00   7.33357477166316E-09   0.00000000000000E+00   7.33357477166316E-09
      3.89479447994346E-18  -1.19174692826065E-01  -1.17576771766382E-01   0.00000000000000E+00  -1.26663433162529E-10
     -1.12489941023727E-22  -4.94496236132838E-09  -5.07162579449102E-09  -2.65190110264481E-18
      3.31255669984430E-09
      0.00000000000000E+00   1.26203853396863E-12   0.00000000000000E+00   3.07130700715459E-12  -4.79437993866286E-23
     -1.26510959746543E-09  -1.26203829045832E-09  -1.26091585501111E-18  -2.52663823854996E-02  -2.52663823909892E-02
      0.00000000000000E+00   0.00000000000000E+00   5.48962181163653E-09   0.00000000000000E+00   5.48962181163653E-09
      3.97787229114226E-18  -1.48833127608579E-01  -1.47501138731699E-01   0.00000000000000E+00  -1.25063810320066E-10
     -1.17817417137809E-22  -4.10251971085803E-09  -4.22758352117821E-09  -2.71695643613115E-18
      3.33255669984430E-09
      0.00000000000000E+00   6.06175265569677E-13   0.00000000000000E+00   1.53957041916596E-12  -4.80692398588948E-23
     -6.07741625121737E-10  -6.06202054702619E-10  -1.27164996106040E-18  -1.79748402010119E-02  -1.79748402051041E-02
      0.00000000000000E+00   0.00000000000000E+00   4.09220527434199E-09   0.00000000000000E+00   4.09220527434199E-09
      4.05971639662910E-18  -1.87358170743645E-01  -1.86259830734295E-01   0.00000000000000E+00  -1.24620308344141E-10
     -1.24149074741587E-22  -3.36138291129508E-09  -3.48600321963935E-09  -2.78806643556870E-18
      3.35255669984430E-09
      0.00000000000000E+00   3.23385319707702E-13   0.00000000000000E+00   6.67449943196670E-13  -4.81181639455516E-23
     -3.24041782055572E-10  -3.23374332112423E-10  -1.27676334213136E-18  -1.41939690654758E-02  -1.41939690686981E-02
      0.00000000000000E+00   0.00000000000000E+00   3.22235714875284E-09   0.00000000000000E+00   3.22235714875284E-09
      4.12416353960416E-18  -2.22461508850722E-01  -2.21548119075365E-01   0.00000000000000E+00  -1.23384240871455E-10
     -1.29827957712337E-22  -2.77559857576878E-09  -2.89898281664036E-09  -2.84740019747280E-18
      3.37255669984430E-09
      0.00000000000000E+00   2.11977653474972E-13   0.00000000000000E+00   2.63092193249808E-13  -4.81394101999143E-23
     -2.12225855885419E-10  -2.11962763692217E-10  -1.27967939883506E-18  -1.19091086296732E-02  -1.19091086322405E-02
      0.00000000000000E+00   0.00000000000000E+00   2.56737072637420E-09   0.00000000000000E+00   2.56737072637420E-09
      4.17551095413164E-18  -2.52130205611716E-01  -2.51388079336574E-01   0.00000000000000E+00  -1.14323883937131E-10
     -1.34679077902299E-22  -2.24108407874469E-09  -2.35540796268195E-09  -2.89583155529658E-18
      3.39255669984430E-09
      0.00000000000000E+00   1.64769458550303E-13   0.00000000000000E+00   1.12108940665023E-13  -4.81489575189181E-23
     -1.64856963535925E-10  -1.64744854595308E-10  -1.28167582869749E-18  -1.03617793646596E-02  -1.03617793666603E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00073833601909E-09   0.00000000000000E+00   2.00073833601909E-09
      4.21552572085202E-18  -2.75453879556752E-01  -2.74875406640012E-01   0.00000000000000E+00  -9.69967109050792E-11
     -1.38546635160356E-22  -1.73899677051850E-09  -1.83599348142372E-09  -2.93384989215453E-18
      3.41255669984430E-09
      0.00000000000000E+00   1.41165361087969E-13   0.00000000000000E+00   5.72202930651517E-14  -4.81524350691359E-23
     -1.41237735979689E-10  -1.41180515686672E-10  -1.28322013793868E-18  -9.25427675566024E-03  -9.25427675717648E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51624028574195E-09   0.00000000000000E+00   1.51624028574195E-09
      4.24585052656686E-18  -2.92645074533886E-01  -2.92211830974092E-01   0.00000000000000E+00  -7.52513961720906E-11
     -1.41417619871591E-22  -1.29980837388312E-09  -1.37505977005536E-09  -2.96263038862818E-18
      3.43255669984430E-09
      0.00000000000000E+00   1.28490787353330E-13   0.00000000000000E+00   3.21263187640927E-14  -4.81527516419529E-23
     -1.28506544714408E-10  -1.28474418395692E-10  -1.28452484072145E-18  -8.43367498004162E-03  -8.43367498115448E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11285642128310E-09   0.00000000000000E+00   1.11285642128310E-09
      4.26810765499252E-18  -3.04382723252025E-01  -3.04072574252729E-01   0.00000000000000E+00  -5.25459286996957E-11
     -1.43368061053916E-22  -9.31836074187609E-10  -9.84382002887448E-10  -2.98358281427107E-18
      3.45255669984430E-09
      0.00000000000000E+00   1.20683984690690E-13   0.00000000000000E+00   2.09295740056747E-14  -4.81511908188316E-23
     -1.20687058505956E-10  -1.20666128931998E-10  -1.28568419220033E-18  -7.81565388382906E-03  -7.81565388461665E-03
      0.00000000000000E+00   0.00000000000000E+00   7.87590322278668E-10   0.00000000000000E+00   7.87590322278668E-10
      4.28385946143810E-18  -3.11572854520778E-01  -3.11362730656796E-01   0.00000000000000E+00  -3.16498318814439E-11
     -1.44530656475921E-22  -6.35274361465030E-10  -6.66924193346618E-10  -2.99817526923776E-18
      3.47255669984430E-09
      0.00000000000000E+00   1.07733876744429E-13   0.00000000000000E+00   3.53994342723480E-14  -4.81452619866958E-23
     -1.07750710803344E-10  -1.07715311369120E-10  -1.28659368885621E-18  -7.40449573172141E-03  -7.40449573232479E-03
      0.00000000000000E+00   0.00000000000000E+00   6.03384610546533E-10   0.00000000000000E+00   6.03384610546533E-10
      4.29592715364903E-18  -3.16423979907888E-01  -3.16267815397858E-01   0.00000000000000E+00  -2.01127638863152E-11
     -1.45265993670852E-22  -4.75556535290956E-10  -4.95669299177416E-10  -3.00933346479282E-18
      3.49255669984430E-09
      0.00000000000000E+00   9.37734766888848E-14   0.00000000000000E+00   3.98413149409941E-14  -4.81349131964054E-23
     -9.38355010984362E-11  -9.37956597835434E-11  -1.28723419564202E-18  -7.14957370171402E-03  -7.14957370228648E-03
      0.00000000000000E+00   0.00000000000000E+00   5.72463770451456E-10   0.00000000000000E+00   5.72463770451456E-10
      4.30737642905806E-18  -3.21238786322488E-01  -3.21087978404904E-01   0.00000000000000E+00  -1.97028390153235E-11
     -1.45971256017502E-22  -4.58965271652465E-10  -4.78668110667934E-10  -3.02014223341604E-18
      3.50255669984430E-09
      0.00000000000000E+00   9.04670661494139E-14   0.00000000000000E+00   2.22168496827559E-14  -4.81295326162572E-23
     -9.05251139061600E-11  -9.05028970565254E-11  -1.28752386263515E-18  -7.03963842516373E-03  -7.03963842572237E-03
      0.00000000000000E+00   0.00000000000000E+00   5.58640553721810E-10   0.00000000000000E+00   5.58640553721810E-10
      4.31296283459528E-18  -3.23587758614587E-01  -3.23440268611446E-01   0.00000000000000E+00  -1.91880524987446E-11
     -1.46311246790474E-22  -4.48949604166317E-10  -4.68137656665208E-10  -3.02543897196013E-18
      3.51605669984430E-09
      0.00000000000000E+00   8.45890029681321E-14   0.00000000000000E+00   2.81816270268521E-14  -4.81210459614351E-23
     -8.46245764547345E-11  -8.45963948277558E-11  -1.28783976294132E-18  -6.91929362798669E-03  -6.91929362858425E-03
      0.00000000000000E+00   0.00000000000000E+00   5.97556992190817E-10   0.00000000000000E+00   5.97556992190817E-10
      4.32102985398985E-18  -3.27280113472180E-01  -3.27118500357841E-01   0.00000000000000E+00  -2.31459649531430E-11
     -1.46855436820589E-22  -4.89814632409776E-10  -5.12960597363066E-10  -3.03319009104854E-18
      3.53428169984430E-09
      0.00000000000000E+00   7.67822003054924E-14   0.00000000000000E+00   2.87918986018773E-14  -4.81075985727685E-23
     -7.67776700723771E-11  -7.67488781738233E-11  -1.28813269916639E-18  -6.79303303064808E-03  -6.79303303133405E-03
      0.00000000000000E+00   0.00000000000000E+00   6.85967609472225E-10   0.00000000000000E+00   6.85967609472225E-10
      4.33353161367248E-18  -3.33682220170906E-01  -3.33490277574105E-01   0.00000000000000E+00  -3.12610944681924E-11
     -1.47829373206239E-22  -5.77957636830142E-10  -6.09218731298482E-10  -3.04539891450609E-18
      3.53928169984430E-09
      0.00000000000000E+00   6.86080186940225E-14   0.00000000000000E+00   8.87161473590475E-14  -4.81028408146498E-23
     -6.86837573465532E-11  -6.85950411992423E-11  -1.28817306655272E-18  -6.77696617312256E-03  -6.77696617384868E-03
      0.00000000000000E+00   0.00000000000000E+00   7.26112736243709E-10   0.00000000000000E+00   7.26112736243709E-10
      4.33716217735370E-18  -3.35654537135596E-01  -3.35447376006712E-01   0.00000000000000E+00  -3.57724277122733E-11
     -1.48131186141171E-22  -6.21745267331714E-10  -6.57517695044135E-10  -3.04898911080098E-18
      3.54603169984430E-09
      0.00000000000000E+00   5.63926686454214E-14   0.00000000000000E+00   9.98929833851320E-14  -4.80949732365018E-23
     -5.65010887818872E-11  -5.64011957985501E-11  -1.28814688288157E-18  -6.78432579084320E-03  -6.78432579168758E-03
      0.00000000000000E+00   0.00000000000000E+00   8.44380435391376E-10   0.00000000000000E+00   8.44380435391376E-10
      4.34286174529259E-18  -3.39053459902465E-01  -3.38805192036632E-01   0.00000000000000E+00  -4.70889066067839E-11
     -1.48662187081399E-22  -7.40890332985865E-10  -7.87979239592798E-10  -3.05471486241102E-18
      3.55514419984430E-09
      0.00000000000000E+00   5.11575186245924E-14   0.00000000000000E+00   4.02630301793381E-14  -4.80843735900302E-23
     -5.12058697376577E-11  -5.11656067075264E-11  -1.28806722304391E-18  -6.78776702696582E-03  -6.78776702796909E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00327390850359E-09   0.00000000000000E+00   1.00327390850359E-09
      4.35200407878383E-18  -3.44803397000645E-01  -3.44503414463563E-01   0.00000000000000E+00  -6.11418180258756E-11
     -1.49585230303748E-22  -8.90966483769897E-10  -9.52108301795923E-10  -3.06393685573992E-18
      3.56744607484430E-09
      0.00000000000000E+00   5.26270344199128E-14   0.00000000000000E+00   5.26487081877889E-15  -4.80712129290864E-23
     -5.26399721700704E-11  -5.26347072992997E-11  -1.28798450883565E-18  -6.73915907748193E-03  -6.73915907862655E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14461965131395E-09   0.00000000000000E+00   1.14461965131395E-09
      4.36608504665684E-18  -3.53854272561469E-01  -3.53510217027154E-01   0.00000000000000E+00  -7.39961616273078E-11
     -1.51074698068468E-22  -1.01798878238724E-09  -1.09198494401470E-09  -3.07810053782119E-18
      3.58405360609430E-09
      0.00000000000000E+00   5.96990791848924E-14   0.00000000000000E+00  -1.16746560645835E-14  -4.80563777994037E-23
     -5.97129985904333E-11  -5.97246732465459E-11  -1.28800313145509E-18  -6.56884828540054E-03  -6.56884828661741E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21687199889225E-09   0.00000000000000E+00   1.21687199889225E-09
      4.38629428640570E-18  -3.66837692636822E-01  -3.66473105471665E-01   0.00000000000000E+00  -8.19647702349054E-11
     -1.53261187182704E-22  -1.07518255541072E-09  -1.15714732564577E-09  -3.09829115495060E-18
      3.60405360609430E-09
      0.00000000000000E+00   7.23736529195311E-14   0.00000000000000E+00  -2.44706516526791E-14  -4.80439074219622E-23
     -7.23311677169958E-11  -7.23556383686966E-11  -1.28829555979403E-18  -6.19961724111093E-03  -6.19961724233432E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22339117201449E-09   0.00000000000000E+00   1.22339117201449E-09
      4.41076210984598E-18  -3.82286247335423E-01  -3.81923585815075E-01   0.00000000000000E+00  -8.50645645932951E-11
     -1.55929994899162E-22  -1.06597096905229E-09  -1.15103553364574E-09  -3.12246655005195E-18
      3.62405360609430E-09
      0.00000000000000E+00   9.03752214122063E-14   0.00000000000000E+00  -4.13669301289376E-14  -4.80387138581469E-23
     -9.03564051849442E-11  -9.03977721151212E-11  -1.28896475968631E-18  -5.61578093478783E-03  -5.61578093599527E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20743464517419E-09   0.00000000000000E+00   1.20743464517419E-09
      4.43491080274947E-18  -3.97078277950744E-01  -3.96726328591655E-01   0.00000000000000E+00  -8.60273131885496E-11
     -1.58563516387268E-22  -1.03100955987046E-09  -1.11703687305917E-09  -3.14594604306315E-18
      3.64405360609430E-09
      0.00000000000000E+00   1.04427466204958E-13   0.00000000000000E+00  -3.44113566426876E-14  -4.80386968527939E-23
     -1.04423553805267E-10  -1.04457965161957E-10  -1.28992971893448E-18  -4.86936525197056E-03  -4.86936525315206E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18150472084888E-09   0.00000000000000E+00   1.18150472084888E-09
      4.45854089716644E-18  -4.11161821359111E-01  -4.10822472042073E-01   0.00000000000000E+00  -8.61197024037240E-11
     -1.61140281450896E-22  -9.90927053282988E-10  -1.07704675568687E-09  -3.16861117823196E-18
      3.66405360609430E-09
      0.00000000000000E+00   1.05345913577033E-13   0.00000000000000E+00  -2.29519478654540E-15  -4.80385745255825E-23
     -1.05308853757739E-10  -1.05311148952574E-10  -1.29092555332541E-18  -4.11941404624072E-03  -4.11941404737943E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13871245985998E-09   0.00000000000000E+00   1.13871245985998E-09
      4.48131514636364E-18  -4.24617906649653E-01  -4.24292309226590E-01   0.00000000000000E+00  -8.54165907881271E-11
     -1.63642492820529E-22  -9.47984720119080E-10  -1.03340131090737E-09  -3.19038959303823E-18
      3.68405360609430E-09
      0.00000000000000E+00   9.15692029959042E-14   0.00000000000000E+00   3.58051785627890E-14  -4.80331251419192E-23
     -9.15977956152648E-11  -9.15619904367500E-11  -1.29166023349463E-18  -3.53980326538299E-03  -3.53980326646091E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07791806232958E-09   0.00000000000000E+00   1.07791806232958E-09
      4.50287350761024E-18  -4.37544692564954E-01  -4.37233918345752E-01   0.00000000000000E+00  -8.38607183959358E-11
     -1.66051390854970E-22  -9.02495353496789E-10  -9.86356071892891E-10  -3.21121327411561E-18
      3.70405360609430E-09
      0.00000000000000E+00   2.35122527251268E-14   0.00000000000000E+00   1.81162545896385E-13  -4.80008508821750E-23
     -2.36449922727143E-11  -2.34638297268659E-11  -1.29104962655339E-18  -3.78215909895328E-03  -3.78215909988778E-03
      0.00000000000000E+00   0.00000000000000E+00   9.34501473209503E-10   0.00000000000000E+00   9.34501473209503E-10
      4.52156353707443E-18  -4.50082763532801E-01  -4.49795721388788E-01   0.00000000000000E+00  -7.83670922310288E-11
     -1.68261728027996E-22  -8.32670551251503E-10  -9.11037643482700E-10  -3.23051391052103E-18
      3.72405360609430E-09
      0.00000000000000E+00  -4.74469912414083E-13   0.00000000000000E+00   1.32223102767114E-12  -4.77678295633380E-23
      4.73128850267410E-10   4.74451081295034E-10  -1.28052706803746E-18  -9.98353396692614E-03  -9.98353396703222E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06081286525265E-10   0.00000000000000E+00   1.06081286525265E-10
      4.52368516280493E-18  -4.62868156864447E-01  -4.62685255413759E-01   0.00000000000000E+00  -4.03050044628129E-11
     -1.69372023953751E-22  -5.40227363357246E-10  -5.80532367820229E-10  -3.24315809476747E-18
      3.74405360609430E-09
      0.00000000000000E+00  -1.37987533180588E-12   0.00000000000000E+00   2.47096974647362E-12  -4.71981767099992E-23
      1.37743144985119E-09   1.37990241959762E-09  -1.25204680557071E-18  -2.67051215672931E-02  -2.67051215659307E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.36234497637199E-09   0.00000000000000E+00  -1.36234497637199E-09
      4.49643826327749E-18  -4.76357649509421E-01  -4.76352142225000E-01   0.00000000000000E+00   2.82218835323511E-11
     -1.68547561831262E-22  -4.57793267578261E-11  -1.75574432256435E-11  -3.24439145770678E-18
      3.75405360609430E-09
      0.00000000000000E+00  -1.86509107847325E-12   0.00000000000000E+00   2.68295433480850E-12  -4.68305881532948E-23
      1.86239889633887E-09   1.86508185067363E-09  -1.23303252731949E-18  -3.76920030121410E-02  -3.76920030100055E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.13555084358717E-09   0.00000000000000E+00  -2.13555084358717E-09
      4.47508275484162E-18  -4.83209773762420E-01  -4.83295021949565E-01   0.00000000000000E+00   6.25935189303809E-11
     -1.67647192619753E-22   2.07875473983436E-10   2.70468992913650E-10  -3.24205022752213E-18
      3.76755360609430E-09
      0.00000000000000E+00  -2.29161803806500E-12   0.00000000000000E+00   1.88495910564051E-12  -4.62596716043783E-23
      2.28977755384252E-09   2.29166251294811E-09  -1.20187167979261E-18  -5.53487617251157E-02  -5.53487617223249E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.79077225501743E-09   0.00000000000000E+00  -2.79077225501743E-09
      4.43740732939889E-18  -4.92516727089842E-01  -4.92674020006924E-01   0.00000000000000E+00   8.88576867579579E-11
     -1.65914997339020E-22   4.10252055311678E-10   4.99109742069470E-10  -3.23553564960627E-18
      3.78577860609430E-09
      0.00000000000000E+00  -2.81458197172466E-12   0.00000000000000E+00   1.75453437616821E-12  -4.53680330251457E-23
      2.81287300001132E-09   2.81462753438744E-09  -1.15143699611106E-18  -8.30631237315400E-02  -8.30631237280228E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.51715486423165E-09   0.00000000000000E+00  -3.51715486423165E-09
      4.37330718199826E-18  -5.04979624016524E-01  -5.05201018174944E-01   0.00000000000000E+00   1.13663275888005E-10
     -1.62898463650376E-22   5.88864053956444E-10   7.02527329844285E-10  -3.22187018588721E-18
      3.79077860609430E-09
      0.00000000000000E+00  -3.11665931240021E-12   0.00000000000000E+00   3.29815235740126E-12  -4.50950990299503E-23
      3.11332365425402E-09   3.11662180661138E-09  -1.13624964278827E-18  -9.12261241896826E-02  -9.12261241857582E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.92437380588323E-09   0.00000000000000E+00  -3.92437380588323E-09
      4.35368531296885E-18  -5.08388844421310E-01  -5.08643395670340E-01   0.00000000000000E+00   1.24546596956686E-10
     -1.61986063377082E-22   6.83205402315630E-10   8.07751999272154E-10  -3.21743567018058E-18
      3.79752860609430E-09
      0.00000000000000E+00  -3.45097415583561E-12   0.00000000000000E+00   2.79028764294988E-12  -4.47033052237552E-23
      3.44823848399219E-09   3.45102877163510E-09  -1.11390738165593E-18  -1.03067038662283E-01  -1.03067038657933E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.34979118796916E-09   0.00000000000000E+00  -4.34979118796916E-09
      4.32432422245005E-18  -5.12992994998813E-01  -5.13276228328540E-01   0.00000000000000E+00   1.37026946023210E-10
     -1.60623063677313E-22   7.61735470310981E-10   8.98762416334030E-10  -3.21041684079412E-18
      3.80664110609430E-09
      0.00000000000000E+00  -3.90395239974313E-12   0.00000000000000E+00   2.79596282646826E-12  -4.41063324982171E-23
      3.90117349291206E-09   3.90396945573848E-09  -1.08087991974073E-18  -1.20228642242538E-01  -1.20228642237695E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.84343699478175E-09   0.00000000000000E+00  -4.84343699478175E-09
      4.28018840283511E-18  -5.19126408452950E-01  -5.19422480003078E-01   0.00000000000000E+00   1.49445289807640E-10
     -1.58598904948387E-22   7.90022249235627E-10   9.39467539043108E-10  -3.19930848309438E-18
      3.81894298109430E-09
      0.00000000000000E+00  -4.54805954177952E-12   0.00000000000000E+00   2.90969226571299E-12  -4.29916535469359E-23
      4.54517140310324E-09   4.54808109536891E-09  -1.03283990310652E-18  -1.44493564896526E-01  -1.44493564891222E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30450859247425E-09   0.00000000000000E+00  -5.30450859247425E-09
      4.21493300119406E-18  -5.26962454991088E-01  -5.27200884683181E-01   0.00000000000000E+00   1.56881505613306E-10
     -1.55687243245303E-22   5.99545991492301E-10   7.56427497105451E-10  -3.18209309808754E-18
      3.83555051234430E-09
      0.00000000000000E+00  -5.79815825991116E-12   0.00000000000000E+00   3.99408938269391E-12  -3.93765595078307E-23
      5.79416853097971E-09   5.79816262036236E-09  -9.65856527139546E-19  -1.77046266398797E-01  -1.77046266393177E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62058512984164E-09   0.00000000000000E+00  -5.62058512984164E-09
      4.12158895800693E-18  -5.35674767826397E-01  -5.35618998953139E-01   0.00000000000000E+00   1.56552837521987E-10
     -1.51653774307756E-22  -3.34130328042469E-10  -1.77577490520633E-10  -3.15573243086738E-18
      3.85555051234430E-09
      0.00000000000000E+00  -8.90701076964874E-12   0.00000000000000E+00   7.87982178566702E-12  -2.48225106149681E-23
      8.89915119378707E-09   8.90703101557271E-09  -8.87682639255106E-19  -2.13354209294480E-01  -2.13354209288650E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.82947600718307E-09   0.00000000000000E+00  -5.82947600718307E-09
      4.00499943786327E-18  -5.40238103914192E-01  -5.39268840579991E-01   0.00000000000000E+00   1.55272159348987E-10
     -1.46558690558097E-22  -3.23282716773861E-09  -3.07755500838977E-09  -3.11731679860817E-18
      3.87555051234430E-09
      0.00000000000000E+00  -1.48640604249289E-11   0.00000000000000E+00   1.48385851150932E-11   1.17537076296804E-23
      1.48491796332100E-08   1.48640182183251E-08  -8.17630789068244E-19  -2.44638050594321E-01  -2.44638050588265E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.05658751574085E-09   0.00000000000000E+00  -6.05658751574085E-09
      3.88386768754845E-18  -5.33674671169956E-01  -5.30900424217029E-01   0.00000000000000E+00   1.60713077105167E-10
     -1.40736554543495E-22  -8.96814377968921E-09  -8.80743070258418E-09  -3.06623689848021E-18
      3.89555051234430E-09
      0.00000000000000E+00  -2.32257889897766E-11   0.00000000000000E+00   2.07385528374260E-11   6.48792905744456E-23
      2.32050431131141E-08   2.32257816659516E-08  -7.60403977026567E-19  -2.69696814672012E-01  -2.69696814665679E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.33233112105593E-09   0.00000000000000E+00  -6.33233112105593E-09
      3.75722106512734E-18  -5.11217656350448E-01  -5.05896078053074E-01   0.00000000000000E+00   1.71184904479230E-10
     -1.33589034707245E-22  -1.70646354493749E-08  -1.68934505448959E-08  -2.99681708810077E-18
      3.91555051234430E-09
      0.00000000000000E+00  -3.16044169862704E-11   0.00000000000000E+00   2.07957869407901E-11   1.18270452870916E-22
      3.15835883118954E-08   3.16043840988363E-08  -7.17781615418846E-19  -2.88501681709144E-01  -2.88501681702522E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62208205575211E-09   0.00000000000000E+00  -6.62208205575211E-09
      3.62477942401229E-18  -4.71009820553684E-01  -4.63139841874539E-01   0.00000000000000E+00   1.76305210583123E-10
     -1.24900248354855E-22  -2.51586072536671E-08  -2.49823020430841E-08  -2.90699780859344E-18
      3.93555051234430E-09
      0.00000000000000E+00  -3.72164059638619E-11   0.00000000000000E+00   1.39468325405969E-11   1.55204599688837E-22
      3.72024329985732E-08   3.72163798311139E-08  -6.89232506887839E-19  -3.01676874733889E-01  -3.01676874726992E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.89793649332656E-09   0.00000000000000E+00  -6.89793649332656E-09
      3.48682069414576E-18  -4.13890826333710E-01  -4.04339491248911E-01   0.00000000000000E+00   1.70481929407592E-10
     -1.15160931118874E-22  -3.04889252671949E-08  -3.03184433377875E-08  -2.79758818725792E-18
      3.95555051234430E-09
      0.00000000000000E+00  -3.83717209131954E-11   0.00000000000000E+00   2.90843186988552E-12   1.65864424666976E-22
      3.83687651145921E-08   3.83716735464621E-08  -6.73293277975645E-19  -3.09989626321226E-01  -3.09989626314071E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15526171676456E-09   0.00000000000000E+00  -7.15526171676456E-09
      3.34371545981047E-18  -3.42641462179685E-01  -3.32806948963221E-01   0.00000000000000E+00   1.54019474544832E-10
     -1.05280953075774E-22  -3.13704313042423E-08  -3.12164118296976E-08  -2.67042218183483E-18
      3.97555051234430E-09
      0.00000000000000E+00  -3.60477735276333E-11   0.00000000000000E+00  -5.69022961056426E-12   1.54395182954806E-22
      3.60534872896529E-08   3.60477970600425E-08  -6.65756813299463E-19  -3.15144822105738E-01  -3.15144822098410E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32771107714343E-09   0.00000000000000E+00  -7.32771107714343E-09
      3.19716123826760E-18  -2.65819891625348E-01  -2.56771629855816E-01   0.00000000000000E+00   1.22775532804039E-10
     -9.52698594504612E-23  -2.88428615157029E-08  -2.87200859828990E-08  -2.53140442496814E-18
      3.99555051234430E-09
      0.00000000000000E+00  -3.32612042007570E-11   0.00000000000000E+00  -6.64479857843809E-12   1.35980875230829E-22
      3.32680752867928E-08   3.32614304882145E-08  -6.59709496350794E-19  -3.19801732785517E-01  -3.19801732778186E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33082805617849E-09   0.00000000000000E+00  -7.33082805617849E-09
      3.05054467714403E-18  -1.95117125810600E-01  -1.86947611531158E-01   0.00000000000000E+00   8.29272547919153E-11
     -8.56896985542799E-23  -2.60135296868279E-08  -2.59306024320361E-08  -2.39083518079324E-18
      4.01555051234430E-09
      0.00000000000000E+00  -3.10850349973618E-11   0.00000000000000E+00  -5.37722184207159E-12   1.18390106903912E-22
      3.10904058074148E-08   3.10850285855728E-08  -6.52547581237092E-19  -3.24928776624550E-01  -3.24928776617294E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25636537788687E-09   0.00000000000000E+00  -7.25636537788687E-09
      2.90541736958629E-18  -1.33092361247094E-01  -1.25584906249837E-01   0.00000000000000E+00   5.45511939686820E-11
     -7.97098072647997E-23  -2.38832144016545E-08  -2.38286632076859E-08  -2.25286978834920E-18
      4.01558957484430E-09
      0.00000000000000E+00  -3.10725441131016E-11   0.00000000000000E+00  -9.96544518510160E-12   1.18355149753400E-22
      3.10825155822871E-08   3.10725501371021E-08  -6.52533895830404E-19  -3.24938450185926E-01  -3.24938450178669E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25710936896903E-09   0.00000000000000E+00  -7.25710936896903E-09
      2.90513388875157E-18  -1.32969767521053E-01  -1.25466478530227E-01   0.00000000000000E+00   5.87421717158487E-11
     -7.96977109247977E-23  -2.38741829398399E-08  -2.38154407681242E-08  -2.25259999292116E-18
      4.01564230921930E-09
      0.00000000000000E+00  -3.10501339972230E-11   0.00000000000000E+00  -1.56373760042615E-11   1.18306954415097E-22
      3.10658086855349E-08   3.10501713095307E-08  -6.52516233374642E-19  -3.24950822509955E-01  -3.24950822502695E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25958830882597E-09   0.00000000000000E+00  -7.25958830882597E-09
      2.90475105889934E-18  -1.32802899407495E-01  -1.25307442646696E-01   0.00000000000000E+00   6.37144487791449E-11
     -7.96812529571825E-23  -2.38542974494897E-08  -2.37905830007106E-08  -2.25223482552470E-18
      4.01571350062555E-09
      0.00000000000000E+00  -3.10181720286748E-11   0.00000000000000E+00  -1.95156358935603E-11   1.18240794038474E-22
      3.10376808230536E-08   3.10181651871601E-08  -6.52493931654748E-19  -3.24966598613136E-01  -3.24966598605872E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26434442394092E-09   0.00000000000000E+00  -7.26434442394092E-09
      2.90423390000432E-18  -1.32576616655671E-01  -1.25092742622667E-01   0.00000000000000E+00   6.66369446022344E-11
     -7.96596158090737E-23  -2.38204577078176E-08  -2.37538207632154E-08  -2.25173996834957E-18
      4.01580960902399E-09
      0.00000000000000E+00  -3.09774848100918E-11   0.00000000000000E+00  -2.04338129750160E-11   1.18150489730295E-22
      3.09979457826657E-08   3.09775119696908E-08  -6.52466271473978E-19  -3.24986894764472E-01  -3.24986894757201E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27137443402980E-09   0.00000000000000E+00  -7.27137443402980E-09
      2.90353505985302E-18  -1.32270769650142E-01  -1.24801918413545E-01   0.00000000000000E+00   6.65024515294161E-11
     -7.96318250873927E-23  -2.37726399871930E-08  -2.37061375356637E-08  -2.25106878837905E-18
      4.01593935536188E-09
      0.00000000000000E+00  -3.09296337020067E-11   0.00000000000000E+00  -1.88610980389115E-11   1.18027235848620E-22
      3.09484511463358E-08   3.09295900482970E-08  -6.52432316586839E-19  -3.25013361736273E-01  -3.25013361728993E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28013816638362E-09   0.00000000000000E+00  -7.28013816638362E-09
      2.90259048858660E-18  -1.31858398829875E-01  -1.24407405844715E-01   0.00000000000000E+00   6.39147177693149E-11
     -7.95961315166647E-23  -2.37133665996855E-08  -2.36494518819162E-08  -2.25015817199976E-18
      4.01611451291803E-09
      0.00000000000000E+00  -3.08756289965287E-11   0.00000000000000E+00  -1.60234048757412E-11   1.17857366630615E-22
      3.08916953665408E-08   3.08756719616651E-08  -6.52390572134375E-19  -3.25048326964256E-01  -3.25048326956966E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28969859169564E-09   0.00000000000000E+00  -7.28969859169564E-09
      2.90131364279619E-18  -1.31303314749042E-01  -1.23872319559607E-01   0.00000000000000E+00   6.01215836062684E-11
     -7.95494456315973E-23  -2.36460949535781E-08  -2.35859733699719E-08  -2.24892307066182E-18
      4.01635097561884E-09
      0.00000000000000E+00  -3.08162054515554E-11   0.00000000000000E+00  -1.30521126031747E-11   1.17619325335814E-22
      3.08292817716298E-08   3.08162296590267E-08  -6.52338389606467E-19  -3.25095046042238E-01  -3.25095046034939E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29888665027979E-09   0.00000000000000E+00  -7.29888665027979E-09
      2.89958772834599E-18  -1.30556972684865E-01  -1.23147598158345E-01   0.00000000000000E+00   5.62160098401050E-11
     -7.94870013908141E-23  -2.35735590185851E-08  -2.35173430087451E-08  -2.24724933873952E-18
      4.01667020026493E-09
      0.00000000000000E+00  -3.07501690855032E-11   0.00000000000000E+00  -1.06137628323342E-11   1.17281306849378E-22
      3.07607563227293E-08   3.07501425598971E-08  -6.52271074189980E-19  -3.25158135942371E-01  -3.25158135935064E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30646773057820E-09   0.00000000000000E+00  -7.30646773057820E-09
      2.89725532377055E-18  -1.29554511445325E-01  -1.22168344621555E-01   0.00000000000000E+00   5.28455032573871E-11
     -7.94020812315642E-23  -2.34965203325785E-08  -2.34436748293212E-08  -2.24498424958057E-18
      4.01710115353715E-09
      0.00000000000000E+00  -3.06740297983582E-11   0.00000000000000E+00  -8.92113440843077E-12   1.16801597507232E-22
      3.06829877491565E-08   3.06740666147482E-08  -6.52180691889606E-19  -3.25244224940081E-01  -3.25244224932770E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31131831375094E-09   0.00000000000000E+00  -7.31131831375094E-09
      2.89410448721901E-18  -1.28209763954255E-01  -1.20849091512511E-01   0.00000000000000E+00   5.02260347582787E-11
     -7.92854035024370E-23  -2.34129743357580E-08  -2.33627483009998E-08  -2.24192379532940E-18
      4.01768294045464E-09
      0.00000000000000E+00  -3.05822769058878E-11   0.00000000000000E+00  -7.88653260166852E-12   1.16131844863742E-22
      3.05901600223481E-08   3.05822734897465E-08  -6.52054538342161E-19  -3.25362862412607E-01  -3.25362862405295E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31255750211494E-09   0.00000000000000E+00  -7.31255750211494E-09
      2.88985013693085E-18  -1.26409029386640E-01  -1.19077665141943E-01   0.00000000000000E+00   4.82627892896625E-11
     -7.91238058808536E-23  -2.33179787769236E-08  -2.32697159876340E-08  -2.23779559858869E-18
      4.01846835279326E-09
      0.00000000000000E+00  -3.04670117606924E-11   0.00000000000000E+00  -7.28958916360348E-12   1.15220385843906E-22
      3.04743155797154E-08   3.04670259905519E-08  -6.51873016943910E-19  -3.25527806512877E-01  -3.25527806505567E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30954936696618E-09   0.00000000000000E+00  -7.30954936696618E-09
      2.88410912666830E-18  -1.24003462574583E-01  -1.16707457277909E-01   0.00000000000000E+00   4.66962119081806E-11
     -7.88976401100799E-23  -2.32041728354894E-08  -2.31574766235813E-08  -2.23223610972439E-18
      4.01899850612182E-09
      0.00000000000000E+00  -3.03892192682776E-11   0.00000000000000E+00  -7.25820551042665E-12   1.14607317308833E-22
      3.03964553460954E-08   3.03891971405851E-08  -6.51746000490144E-19  -3.25640830998303E-01  -3.25640830990996E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30678947402624E-09   0.00000000000000E+00  -7.30678947402624E-09
      2.88023540790750E-18  -1.22390352037179E-01  -1.15117995903545E-01   0.00000000000000E+00   4.60354513618432E-11
     -7.87400881612576E-23  -2.31284431179199E-08  -2.30824076665582E-08  -2.22848940741736E-18
      4.01971421311539E-09
      0.00000000000000E+00  -3.02883737468238E-11   0.00000000000000E+00  -6.97834719294883E-12   1.13791981002604E-22
      3.02953757228463E-08   3.02883973756535E-08  -6.51565202198995E-19  -3.25797090447079E-01  -3.25797090439777E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30149499256909E-09   0.00000000000000E+00  -7.30149499256909E-09
      2.87500967687784E-18  -1.20232833789926E-01  -1.12990565253978E-01   0.00000000000000E+00   4.50224533414389E-11
     -7.85185162268906E-23  -2.30319248364280E-08  -2.29869023830866E-08  -2.22344447467884E-18
      4.01995576422572E-09
      0.00000000000000E+00  -3.02530135229989E-11   0.00000000000000E+00  -7.20014957165162E-12   1.13518074368317E-22
      3.02601763747091E-08   3.02529762251376E-08  -6.51503466603218E-19  -3.25850024888578E-01  -3.25850024881278E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29992417791202E-09   0.00000000000000E+00  -7.29992417791202E-09
      2.87324637208735E-18  -1.19506565099117E-01  -1.12274960596564E-01   0.00000000000000E+00   4.49692621126744E-11
     -7.84422463813491E-23  -2.29980213093294E-08  -2.29530520472168E-08  -2.22174290548413E-18
      4.02028185822466E-09
      0.00000000000000E+00  -3.02062645517602E-11   0.00000000000000E+00  -7.09327886347388E-12   1.13151245044524E-22
      3.02133623392000E-08   3.02062690603367E-08  -6.51418564375921E-19  -3.25922105945626E-01  -3.25922105938328E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29758553262061E-09   0.00000000000000E+00  -7.29758553262061E-09
      2.87086667323839E-18  -1.18530211968383E-01  -1.11312585075098E-01   0.00000000000000E+00   4.45167048403614E-11
     -7.83367555717617E-23  -2.29532002325586E-08  -2.29086835277183E-08  -2.21944810886247E-18
      4.02072208512324E-09
      0.00000000000000E+00  -3.01450959567800E-11   0.00000000000000E+00  -6.89006823218148E-12   1.12661865934101E-22
      3.01519701103686E-08   3.01450800421366E-08  -6.51300662640184E-19  -3.26020733656431E-01  -3.26020733649137E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29393212626341E-09   0.00000000000000E+00  -7.29393212626341E-09
      2.86765568812004E-18  -1.17219679754678E-01  -1.10020178511934E-01   0.00000000000000E+00   4.38892175846215E-11
     -7.81899640934746E-23  -2.28950371334581E-08  -2.28511479158735E-08  -2.21635502547985E-18
      4.02131639143631E-09
      0.00000000000000E+00  -3.00647318117234E-11   0.00000000000000E+00  -6.69800152642838E-12   1.12012559538579E-22
      3.00713937074371E-08   3.00646957059108E-08  -6.51135167642501E-19  -3.26156333205733E-01  -3.26156333198444E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28842832019204E-09   0.00000000000000E+00  -7.28842832019204E-09
      2.86332412915696E-18  -1.15463941916138E-01  -1.08288030536516E-01   0.00000000000000E+00   4.31698919383397E-11
     -7.79837807823487E-23  -2.28194372776559E-08  -2.27762673857176E-08  -2.21218896151446E-18
      4.02211870495896E-09
      0.00000000000000E+00  -2.99589266744604E-11   0.00000000000000E+00  -6.52129437289802E-12   1.11157660096728E-22
      2.99654707002725E-08   2.99589494058997E-08  -6.50900234358343E-19  -3.26343754931170E-01  -3.26343754923890E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28048778542100E-09   0.00000000000000E+00  -7.28048778542100E-09
      2.85748289535523E-18  -1.13117676092008E-01  -1.05972576848786E-01   0.00000000000000E+00   4.23278379681501E-11
     -7.76897949700738E-23  -2.27207894584456E-08  -2.26784616204776E-08  -2.20658266099688E-18
      4.02266026658675E-09
      0.00000000000000E+00  -2.98861856425920E-11   0.00000000000000E+00  -6.63027990000141E-12   1.10589580487754E-22
      2.98927772352299E-08   2.98861469553300E-08  -6.50737443488425E-19  -3.26471726533832E-01  -3.26471726526556E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27553434131066E-09   0.00000000000000E+00  -7.27553434131066E-09
      2.85354274513431E-18  -1.11544168508695E-01  -1.04420444003711E-01   0.00000000000000E+00   4.19555112975392E-11
     -7.74817746007085E-23  -2.26525681253142E-08  -2.26106126140167E-08  -2.20280530164589E-18
      4.02339137478426E-09
      0.00000000000000E+00  -2.97908508053706E-11   0.00000000000000E+00  -6.45103206736892E-12   1.09839460067003E-22
      2.97972837942613E-08   2.97908327621941E-08  -6.50509047726472E-19  -3.26647795876978E-01  -3.26647795869710E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26843585464322E-09   0.00000000000000E+00  -7.26843585464322E-09
      2.84822873209787E-18  -1.09439516528298E-01  -1.02343583029998E-01   0.00000000000000E+00   4.11757003981326E-11
     -7.71840572940439E-23  -2.25635726079454E-08  -2.25223969075473E-08  -2.19771968437140E-18
      4.02388487281759E-09
      0.00000000000000E+00  -2.97254573524788E-11   0.00000000000000E+00  -6.53439324241840E-12   1.09340002356574E-22
      2.97319918732955E-08   2.97254574800532E-08  -6.50351562523193E-19  -3.26767804083747E-01  -3.26767804076483E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26393770034962E-09   0.00000000000000E+00  -7.26393770034962E-09
      2.84464399312857E-18  -1.08027296346524E-01  -1.00950541248665E-01   0.00000000000000E+00   4.08325057863044E-11
     -7.69733649756190E-23  -2.25023522854906E-08  -2.24615197797044E-08  -2.19429243060538E-18
      4.02455109516257E-09
      0.00000000000000E+00  -2.96396743679270E-11   0.00000000000000E+00  -6.37142250001524E-12   1.08678713862470E-22
      2.96460380935310E-08   2.96396666710311E-08  -6.50131989091566E-19  -3.26932492101864E-01  -3.26932492094606E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25748910718226E-09   0.00000000000000E+00  -7.25748910718226E-09
      2.83980889171688E-18  -1.06136943801277E-01  -9.90851842859699E-02   0.00000000000000E+00   4.01354153286138E-11
     -7.66721197855806E-23  -2.24223129791772E-08  -2.23821775638487E-08  -2.18967690262531E-18
      4.02545049532830E-09
      0.00000000000000E+00  -2.95267053411617E-11   0.00000000000000E+00  -6.21026911302070E-12   1.07810115923328E-22
      2.95329163354265E-08   2.95267060663136E-08  -6.49822161091092E-19  -3.27159870310721E-01  -3.27159870303472E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24835972008922E-09   0.00000000000000E+00  -7.24835972008922E-09
      2.83328971578335E-18  -1.03614030332697E-01  -9.65949813542235E-02   0.00000000000000E+00   3.93010058147791E-11
     -7.62339506635615E-23  -2.23176473520383E-08  -2.22783463462236E-08  -2.18346755469226E-18
      4.02666468555204E-09
      0.00000000000000E+00  -2.93773657984623E-11   0.00000000000000E+00  -6.07665565189719E-12   1.06681857057159E-22
      2.93834384986067E-08   2.93773618429549E-08  -6.49379366253823E-19  -3.27475919633292E-01  -3.27475919626057E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23576952587782E-09   0.00000000000000E+00  -7.23576952587782E-09
      2.82450411516383E-18  -1.00260265388370E-01  -9.32842990769342E-02   0.00000000000000E+00   3.83018430894109E-11
     -7.55790175842141E-23  -2.21798941601667E-08  -2.21415923170774E-08  -2.17512474891000E-18
      4.02830384235408E-09
      0.00000000000000E+00  -2.91791648555685E-11   0.00000000000000E+00  -5.96670125522713E-12   1.05237825956808E-22
      2.91851347648225E-08   2.91791680635674E-08  -6.48737150420661E-19  -3.27918886138598E-01  -3.27918886131379E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21861974958566E-09   0.00000000000000E+00  -7.21861974958566E-09
      2.81267166549993E-18  -9.58267733395489E-02  -8.89078435578025E-02   0.00000000000000E+00   3.70694473768248E-11
     -7.45611769150208E-23  -2.19976177613582E-08  -2.19605483139814E-08  -2.16393451507927E-18
      4.03051670403684E-09
      0.00000000000000E+00  -2.89138254097759E-11   0.00000000000000E+00  -5.90189994215475E-12   1.03427379372056E-22
      2.89197088477102E-08   2.89138069477681E-08  -6.47788031803301E-19  -3.28546702424452E-01  -3.28546702417257E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19511633742599E-09   0.00000000000000E+00  -7.19511633742599E-09
      2.79674986825384E-18  -9.00133011705239E-02  -8.31705695309723E-02   0.00000000000000E+00   3.55412403828355E-11
     -7.28939491080830E-23  -2.17542318507247E-08  -2.17186906103419E-08  -2.14896183645054E-18
      4.03350406730856E-09
      0.00000000000000E+00  -2.85507631635946E-11   0.00000000000000E+00  -5.93296584782111E-12   1.01231725424540E-22
      2.85567979064743E-08   2.85508649406266E-08  -6.46346955749848E-19  -3.29451476914438E-01  -3.29451476907276E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16187013474357E-09   0.00000000000000E+00  -7.16187013474357E-09
      2.77535476045645E-18  -8.24865908207863E-02  -7.57477400410892E-02   0.00000000000000E+00   3.36545324475612E-11
     -6.99768597544289E-23  -2.14226493383307E-08  -2.13889948058832E-08  -2.12900780470660E-18
      4.03753700772539E-09
      0.00000000000000E+00  -2.80336772931162E-11   0.00000000000000E+00  -6.10419174156958E-12   9.87408472242230E-23
      2.80400371928257E-08   2.80339330010842E-08  -6.44062894749294E-19  -3.30792263422254E-01  -3.30792263415142E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.11166710618456E-09   0.00000000000000E+00  -7.11166710618456E-09
      2.74667383075289E-18  -7.29539030747809E-02  -6.63621412024891E-02   0.00000000000000E+00   3.12927339067579E-11
     -6.44919674661871E-23  -2.09535586288062E-08  -2.09222658948995E-08  -2.10261093600359E-18
      4.04298147728811E-09
      0.00000000000000E+00  -2.72574974189754E-11   0.00000000000000E+00  -7.02326158097244E-12   9.63758200771515E-23
      2.72644791026748E-08   2.72574558410939E-08  -6.40194681247619E-19  -3.32874794645415E-01  -3.32874794638386E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02912739660531E-09   0.00000000000000E+00  -7.02912739660531E-09
      2.70840396058960E-18  -6.13763569218289E-02  -5.50031495218394E-02   0.00000000000000E+00   2.88652944344843E-11
     -5.35874483047326E-23  -2.02571937389234E-08  -2.02283284444890E-08  -2.06820927934199E-18
      4.05033151119778E-09
      0.00000000000000E+00  -2.60701286563565E-11   0.00000000000000E+00  -7.95337225313672E-12   9.54191925107772E-23
      2.60780585027732E-08   2.60701051305201E-08  -6.33130711388628E-19  -3.36318969674278E-01  -3.36318969667390E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.88786298534976E-09   0.00000000000000E+00  -6.88786298534976E-09
      2.65777793408213E-18  -4.84249458108042E-02  -4.23813102056926E-02   0.00000000000000E+00   2.55290409905411E-11
     -3.19406472367903E-23  -1.92077711861609E-08  -1.91822421451704E-08  -2.02464722269350E-18
      4.06025405697583E-09
      0.00000000000000E+00  -2.44313430103626E-11   0.00000000000000E+00  -8.12665038296445E-12   9.85370517116608E-23
      2.44394939269561E-08   2.44313672765733E-08  -6.19962718084090E-19  -3.42207056603715E-01  -3.42207056597044E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67095808330087E-09   0.00000000000000E+00  -6.67095808330087E-09
      2.59158504711710E-18  -3.58622422992060E-02  -3.02665632993103E-02   0.00000000000000E+00   2.09887568261545E-11
      6.73586656794971E-24  -1.77813979500984E-08  -1.77604091932722E-08  -1.97162232903301E-18
      4.07364949377621E-09
      0.00000000000000E+00  -2.26659953164967E-11   0.00000000000000E+00  -6.47582507028166E-12   1.08726206300226E-22
      2.26724450401004E-08   2.26659692150302E-08  -5.97326816572953E-19  -3.51789980338560E-01  -3.51789980332144E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41607708033831E-09   0.00000000000000E+00  -6.41607708033831E-09
      2.50563889208111E-18  -2.57381370307469E-02  -2.06183575884574E-02   0.00000000000000E+00   1.53287603087073E-11
      5.97467920314405E-23  -1.62652208950006E-08  -1.62498921346919E-08  -1.90831207550815E-18
      4.09173333345671E-09
      0.00000000000000E+00  -2.12181548791572E-11   0.00000000000000E+00  -3.91818685361577E-12   1.25387005849978E-22
      2.12220737453882E-08   2.12181555585347E-08  -5.63280121175471E-19  -3.65837045061316E-01  -3.65837045055125E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19159236280721E-09   0.00000000000000E+00  -6.19159236280721E-09
      2.39367112842508E-18  -1.87259580016606E-02  -1.39915975154304E-02   0.00000000000000E+00   1.01286532136257E-11
      1.19118315905929E-22  -1.50366918489412E-08  -1.50265631957275E-08  -1.83039100724961E-18
      4.11173333345671E-09
      0.00000000000000E+00  -2.02286196804834E-11   0.00000000000000E+00  -2.40709910453518E-12   1.38849293585795E-22
      2.02309948973570E-08   2.02285877982526E-08  -5.25539895213863E-19  -3.81295862799197E-01  -3.81295862793161E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.03612589297176E-09   0.00000000000000E+00  -6.03612589297176E-09
      2.27294861056564E-18  -1.46554507470620E-02  -1.01838802305989E-02   0.00000000000000E+00   7.09423993957270E-12
      1.65124168694612E-22  -1.41995561452206E-08  -1.41924619052809E-08  -1.74740871535178E-18
      4.13173333345671E-09
      0.00000000000000E+00  -1.94728293380026E-11   0.00000000000000E+00  -1.83172979218123E-12   1.42669168427213E-22
      1.94746796550983E-08   1.94728479253063E-08  -4.89416355329645E-19  -3.96131337274855E-01  -3.96131337268935E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91956159312067E-09   0.00000000000000E+00  -5.91956159312067E-09
      2.15455737870323E-18  -1.22172674891457E-02  -7.94707489758641E-03   0.00000000000000E+00   5.59713814286596E-12
      1.88593201312306E-22  -1.35588834703287E-08  -1.35532863321857E-08  -1.66514102337358E-18
      4.15173333345671E-09
      0.00000000000000E+00  -1.88106287827363E-11   0.00000000000000E+00  -1.60396237146147E-12   1.36244921734233E-22
      1.88122293878631E-08   1.88106254254917E-08  -4.55242663218519E-19  -4.10260287605506E-01  -4.10260287599689E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81761593065556E-09   0.00000000000000E+00  -5.81761593065556E-09
      2.03820506009012E-18  -1.05807413823623E-02  -6.48706977126097E-03   0.00000000000000E+00   4.75675507869446E-12
      1.90548322162789E-22  -1.29977662499150E-08  -1.29930094948361E-08  -1.58296239687160E-18
      4.17173333345671E-09
      0.00000000000000E+00  -1.82323743172778E-11   0.00000000000000E+00  -1.39994194702277E-12   1.21505615040249E-22
      1.82337450728001E-08   1.82323451308532E-08  -4.22832929285858E-19  -4.23756397085298E-01  -4.23756397079573E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72588747396531E-09   0.00000000000000E+00  -5.72588747396531E-09
      1.92368731061081E-18  -9.41501635091778E-03  -5.47463827170984E-03   0.00000000000000E+00   4.12597081354109E-12
      1.75142225440644E-22  -1.25105836277016E-08  -1.25064576568878E-08  -1.50085438132495E-18
      4.19173333345671E-09
      0.00000000000000E+00  -1.77419234205896E-11   0.00000000000000E+00  -1.18569322243677E-12   1.01535855273466E-22
      1.77431226467034E-08   1.77419369534811E-08  -3.91895000417239E-19  -4.36716929130624E-01  -4.36716929124981E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64286771031967E-09   0.00000000000000E+00  -5.64286771031967E-09
      1.81082995640442E-18  -8.55550729398372E-03  -4.74348151823529E-03   0.00000000000000E+00   3.59916274464661E-12
      1.48299175900573E-22  -1.21026684059061E-08  -1.20990692431613E-08  -1.41893495598718E-18
      4.21173333345671E-09
      0.00000000000000E+00  -1.73498382374506E-11   0.00000000000000E+00  -9.45166625333297E-13   7.96775968668603E-23
      1.73507891388307E-08   1.73498439722055E-08  -3.62071616429527E-19  -4.49269211604263E-01  -4.49269211598676E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58631685369342E-09   0.00000000000000E+00  -5.58631685369342E-09
      1.69910361933055E-18  -7.90523867486487E-03  -4.19892920258461E-03   0.00000000000000E+00   3.17205057187284E-12
      1.16298093406397E-22  -1.17666991690840E-08  -1.17635271185120E-08  -1.33703200290102E-18
      4.23173333345671E-09
      0.00000000000000E+00  -1.73055690741166E-11   0.00000000000000E+00  -8.91976249713732E-14   5.90186459682102E-23
      1.73056550717480E-08   1.73055658741231E-08  -3.31977033845518E-19  -4.61996005822899E-01  -4.61996005817140E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.75836955687288E-09   0.00000000000000E+00  -5.75836955687288E-09
      1.58393622819309E-18  -7.45278506636569E-03  -3.81463252526103E-03   0.00000000000000E+00   2.75651070084535E-12
      8.47122875251625E-23  -1.15499528279511E-08  -1.15471963172502E-08  -1.25195919434757E-18
      4.25173333345671E-09
      0.00000000000000E+00  -1.76844286150977E-11   0.00000000000000E+00   9.54552714724646E-13   4.13785345512277E-23
      1.76834460328696E-08   1.76844005855844E-08  -3.00397660105276E-19  -4.75441344357352E-01  -4.75441344351163E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.18868409917021E-09   0.00000000000000E+00  -6.18868409917021E-09
      1.46016254620969E-18  -7.18113525973192E-03  -3.55920049281861E-03   0.00000000000000E+00   2.32351143175376E-12
      5.70644456084757E-23  -1.14980399978460E-08  -1.14957164864142E-08  -1.15976488610441E-18
      4.26173333345671E-09
      0.00000000000000E+00  -1.78959470448866E-11   0.00000000000000E+00   1.06528821761211E-12   3.31470439986972E-23
      1.78948807520581E-08   1.78959460402757E-08  -2.84451221318916E-19  -4.82283463332690E-01  -4.82283463326273E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41716241879235E-09   0.00000000000000E+00  -6.41716241879235E-09
      1.39599092202176E-18  -7.06912792235356E-03  -3.45252726949973E-03   0.00000000000000E+00   2.21383185231445E-12
      4.40042731563644E-23  -1.14809974533358E-08  -1.14787836214834E-08  -1.11153970070285E-18
      4.27523333345671E-09
      0.00000000000000E+00  -1.80789017614040E-11   0.00000000000000E+00   6.91335752430937E-13   2.43402724020947E-23
      1.80781858092950E-08   1.80788771450474E-08  -2.62875700342974E-19  -4.91589222903104E-01  -4.91589222896543E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.56099703397830E-09   0.00000000000000E+00  -6.56099703397830E-09
      1.30741746206306E-18  -6.94667135116886E-03  -3.31775140644723E-03   0.00000000000000E+00   1.93011513441254E-12
      3.01544502299076E-23  -1.15198102262036E-08  -1.15178801110691E-08  -1.04454176172008E-18
      4.29345833345671E-09
      0.00000000000000E+00  -1.82324661620150E-11   0.00000000000000E+00   4.36753889969735E-13   1.60502163887162E-23
      1.82320425629742E-08   1.82324793168642E-08  -2.34244210319882E-19  -5.04059324755984E-01  -5.04059324749339E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64515925409714E-09   0.00000000000000E+00  -6.64515925409714E-09
      1.18630943465713E-18  -6.80611410659278E-03  -3.15531431549806E-03   0.00000000000000E+00   1.77440276949603E-12
      1.72307965691573E-23  -1.15890944655366E-08  -1.15873200627671E-08  -9.52065224337253E-19
      4.29845833345671E-09
      0.00000000000000E+00  -1.83262396387038E-11   0.00000000000000E+00   9.39643439705430E-13   1.39367745088542E-23
      1.83252626202604E-08   1.83262022637002E-08  -2.26492626544471E-19  -5.07470088626574E-01  -5.07470088619857E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71690966421187E-09   0.00000000000000E+00  -6.71690966421187E-09
      1.15272488633608E-18  -6.77971798184207E-03  -3.12199489300839E-03   0.00000000000000E+00   1.66941591741774E-12
      1.38874529627124E-23  -1.16109620154057E-08  -1.16092925994882E-08  -9.26232259791604E-19
      4.30520833345671E-09
      0.00000000000000E+00  -1.84730075287615E-11   0.00000000000000E+00   1.09137525909796E-12   1.16404168169703E-23
      1.84718941114612E-08   1.84729854867203E-08  -2.16065521318868E-19  -5.12078451564500E-01  -5.12078451557736E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76457771652283E-09   0.00000000000000E+00  -6.76457771652283E-09
      1.10706398674955E-18  -6.77703285755317E-03  -3.08808097777302E-03   0.00000000000000E+00   1.13069248137956E-12
      1.02994498083060E-23  -1.17095384626789E-08  -1.17084077701976E-08  -8.90998465430679E-19
      4.31432083345671E-09
      0.00000000000000E+00  -1.86235410530446E-11   0.00000000000000E+00   8.35410085535270E-13   9.34445927343687E-24
      1.86226994042287E-08   1.86235348143142E-08  -2.02221693984515E-19  -5.18232087579095E-01  -5.18232087572337E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75823100159999E-09   0.00000000000000E+00  -6.75823100159999E-09
      1.04547960674747E-18  -6.78232255120703E-03  -3.04393689093879E-03   0.00000000000000E+00   9.43725892192699E-13
      6.76024640200329E-24  -1.18662475386065E-08  -1.18653038127143E-08  -8.43257912762952E-19
      4.32662270845671E-09
      0.00000000000000E+00  -1.85661380922899E-11   0.00000000000000E+00  -2.08973830316056E-13   7.21869711078661E-24
      1.85663521177080E-08   1.85661431438777E-08  -1.84547874594514E-19  -5.26142852844715E-01  -5.26142852838180E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53508443083944E-09   0.00000000000000E+00  -6.53508443083944E-09
      9.65085814964834E-19  -6.75401689680731E-03  -2.96340618463811E-03   0.00000000000000E+00   1.00045382136218E-12
      3.61659788811155E-24  -1.20320591668596E-08  -1.20310587130382E-08  -7.80537940370319E-19
      4.34323023970671E-09
      0.00000000000000E+00  -1.77381577863641E-11   0.00000000000000E+00  -2.44027698176760E-12   5.34915465199999E-24
      1.77406389071667E-08   1.77381986301850E-08  -1.64669751002062E-19  -5.35096319056079E-01  -5.35096319050476E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60307717959944E-09   0.00000000000000E+00  -5.60307717959944E-09
      8.72032535608474E-19  -6.61796248248543E-03  -2.79456386378175E-03   0.00000000000000E+00   1.05436626338515E-12
      1.14061492792312E-24  -1.21361758168489E-08  -1.21351214505856E-08  -7.07362784606413E-19
      4.36323023970671E-09
      0.00000000000000E+00  -1.50027459781123E-11   0.00000000000000E+00  -6.73249812410733E-12   3.68831733231624E-24
      1.50094837772999E-08   1.50027512791758E-08  -1.52961008349308E-19  -5.40297721586492E-01  -5.40297721583650E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84253860702101E-09   0.00000000000000E+00  -2.84253860702101E-09
      8.15181763468053E-19  -6.29685403676578E-03  -2.46554889263461E-03   0.00000000000000E+00   6.09769307634429E-13
     -5.97439880307040E-25  -1.21608224414623E-08  -1.21602126721547E-08  -6.62220755118745E-19
      4.38323023970671E-09
      0.00000000000000E+00  -9.55552645907108E-12   0.00000000000000E+00  -1.34244069889676E-11   1.94296257727902E-24
      9.56890206229760E-09   9.55547765530864E-09  -1.64324670157230E-19  -5.34810150862174E-01  -5.34810150864772E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59800571182979E-09   0.00000000000000E+00   2.59800571182979E-09
      8.67141877704650E-19  -5.76433983378788E-03  -1.93515383659726E-03   0.00000000000000E+00  -5.70913056662143E-13
     -2.01547543894113E-24  -1.21529124540818E-08  -1.21534833671385E-08  -7.02817207547421E-19
      4.40323023970671E-09
      0.00000000000000E+00  -1.78279819393530E-12   0.00000000000000E+00  -1.91680008573190E-11  -5.39343481779583E-25
      1.80199633556540E-09   1.78282833470808E-09  -2.10402043561048E-19  -5.13719249191812E-01  -5.13719249202167E-01
      0.00000000000000E+00   0.00000000000000E+00   1.03551806513702E-08   0.00000000000000E+00   1.03551806513702E-08
      1.07424549073205E-18  -5.04423981383021E-03  -1.21992900015867E-03   0.00000000000000E+00  -2.52463530738434E-12
     -4.27466896774639E-24  -1.21354843507709E-08  -1.21380089860782E-08  -8.63843447171006E-19
      4.42323023970671E-09
      0.00000000000000E+00   6.05541536882945E-12   0.00000000000000E+00  -1.93671437827142E-11  -5.22225888806520E-24
     -6.03606398439090E-09  -6.05543112817362E-09  -2.99555633795237E-19  -4.74908530355513E-01  -4.74908530373676E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81627574185425E-08   0.00000000000000E+00   1.81627574185425E-08
      1.43750063910290E-18  -4.27873938414991E-03  -4.64096458826939E-04   0.00000000000000E+00  -5.35669558396889E-12
     -1.05076302104018E-23  -1.21019695947849E-08  -1.21073262903689E-08  -1.13794500530767E-18
      4.44323023970671E-09
      0.00000000000000E+00   1.11850357866070E-11   0.00000000000000E+00  -1.27671886380885E-11  -1.61984374092784E-23
     -1.11722226829867E-08  -1.11849898716248E-08  -4.35964563981627E-19  -4.19059254812473E-01  -4.19059254835715E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32425710179182E-08   0.00000000000000E+00   2.32425710179182E-08
      1.90235205946127E-18  -3.64029814940363E-03   1.58669311888899E-04   0.00000000000000E+00  -9.83125283619521E-12
     -2.93915665014662E-23  -1.20477498934571E-08  -1.20575811462934E-08  -1.46638749547964E-18
      4.46323023970671E-09
      0.00000000000000E+00   1.18423685708013E-11   0.00000000000000E+00  -1.84001034064337E-12  -3.30009360569129E-23
     -1.18405625101440E-08  -1.18424025204847E-08  -6.12958937565548E-19  -3.48732672991859E-01  -3.48732673015659E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38006149316063E-08   0.00000000000000E+00   2.38006149316063E-08
      2.37836435809339E-18  -3.49754694794925E-03   2.70108289701477E-04   0.00000000000000E+00  -1.78215739055052E-11
     -6.11109556128168E-23  -1.19403908372160E-08  -1.19582124111216E-08  -1.76540542052784E-18
      4.48323023970671E-09
      0.00000000000000E+00   9.34520201086585E-12   0.00000000000000E+00   5.82478998088760E-12  -4.08476297473470E-23
     -9.35099505173162E-09  -9.34517026175077E-09  -7.95082189047701E-19  -2.71848634042624E-01  -2.71848634063306E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06828654240395E-08   0.00000000000000E+00   2.06828654240395E-08
      2.79202166657418E-18  -7.46706842724165E-03  -3.89492399894026E-03   0.00000000000000E+00  -3.03598990664443E-11
     -7.65035303469783E-23  -1.13073352632222E-08  -1.13376951622887E-08  -1.99693947752648E-18
      4.50323023970671E-09
      0.00000000000000E+00   7.38330657937587E-12   0.00000000000000E+00   4.42527901718687E-12  -4.31709015457934E-23
     -7.38770270261231E-09  -7.38327742359517E-09  -9.46462379178993E-19  -2.00449517289799E-01  -2.00449517306932E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71328756886967E-08   0.00000000000000E+00   1.71328756886967E-08
      3.13467918034812E-18  -2.18648771793185E-02  -1.87930927979106E-02   0.00000000000000E+00  -4.76719069714776E-11
     -8.42158775223385E-23  -9.70192635812998E-09  -9.74959826510155E-09  -2.18821680116912E-18
      4.52323023970671E-09
      0.00000000000000E+00   6.04411846615292E-12   0.00000000000000E+00   2.81516422708535E-12  -4.49686809994980E-23
     -6.04694961272738E-09  -6.04413444850034E-09  -1.06751514926796E-18  -1.37745628853066E-01  -1.37745628867422E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43560862099399E-08   0.00000000000000E+00   1.43560862099399E-08
      3.42180090454691E-18  -4.45189829609735E-02  -4.19001528121302E-02   0.00000000000000E+00  -7.30153361118568E-11
     -9.27892993372497E-23  -8.23893642532752E-09  -8.31195176143947E-09  -2.35428575527895E-18
      4.53323023970671E-09
      0.00000000000000E+00   5.30632969216486E-12   0.00000000000000E+00   3.08599668572431E-12  -4.57966806671909E-23
     -5.30940732719539E-09  -5.30632133050972E-09  -1.12023751531076E-18  -1.08778232560881E-01  -1.08778232573739E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28583122819959E-08   0.00000000000000E+00   1.28583122819959E-08
      3.55038402736687E-18  -5.78165613416879E-02  -5.54371605919840E-02   0.00000000000000E+00  -9.62840254258517E-11
     -9.72164517290543E-23  -7.45570692606023E-09  -7.55199095148618E-09  -2.43014651205611E-18
      4.54673023970671E-09
      0.00000000000000E+00   4.42342623338890E-12   0.00000000000000E+00   2.68685113157655E-12  -4.67427337948174E-23
     -4.42612004525263E-09  -4.42343319412110E-09  -1.17912522755862E-18  -7.50773150385828E-02  -7.50773150497708E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11879751024220E-08   0.00000000000000E+00   1.11879751024220E-08
      3.70142169124957E-18  -7.81038236868987E-02  -7.59725225601870E-02   0.00000000000000E+00  -1.12578745311448E-10
     -1.03093606947487E-22  -6.65196316298949E-09  -6.76454190830104E-09  -2.52229646369095E-18
      4.55584273970671E-09
      0.00000000000000E+00   3.58479193794698E-12   0.00000000000000E+00   4.03413057411536E-12  -4.72420960849159E-23
     -3.58880081645602E-09  -3.58476668588195E-09  -1.21117007209120E-18  -5.61200809054586E-02  -5.61200809151297E-02
      0.00000000000000E+00   0.00000000000000E+00   9.67110315596266E-09   0.00000000000000E+00   9.67110315596266E-09
      3.78954961875828E-18  -9.31612312409097E-02  -9.12436065527761E-02   0.00000000000000E+00  -1.24296067421785E-10
     -1.06986419627145E-22  -5.96204040265870E-09  -6.08633647008059E-09  -2.57837954666708E-18
      4.56814461470671E-09
      0.00000000000000E+00   2.44848884921546E-12   0.00000000000000E+00   4.18941663628085E-12  -4.76742378951015E-23
     -2.45271731217889E-09  -2.44852789554265E-09  -1.24041491934164E-18  -3.83084647921512E-02  -3.83084647998168E-02
      0.00000000000000E+00   0.00000000000000E+00   7.66561761454495E-09   0.00000000000000E+00   7.66561761454495E-09
      3.88385108845021E-18  -1.15635723716916E-01  -1.13991972349880E-01   0.00000000000000E+00  -1.26095343608751E-10
     -1.11848725897861E-22  -5.09099437539332E-09  -5.21708971900219E-09  -2.64343616910857E-18
      4.58475214595671E-09
      0.00000000000000E+00   1.30722614467473E-12   0.00000000000000E+00   3.19451983345637E-12  -4.79478824890914E-23
     -1.31042428356188E-09  -1.30722976372848E-09  -1.26094201019752E-18  -2.52850864093339E-02  -2.52850864149072E-02
      0.00000000000000E+00   0.00000000000000E+00   5.57333783334928E-09   0.00000000000000E+00   5.57333783334928E-09
      3.97641047068436E-18  -1.48070917253204E-01  -1.46726791278563E-01   0.00000000000000E+00  -1.24537846821938E-10
     -1.17711403468233E-22  -4.14157022279873E-09  -4.26610806962078E-09  -2.71546846048684E-18
      4.60475214595671E-09
      0.00000000000000E+00   6.11869639276543E-13   0.00000000000000E+00   1.63623689332087E-12  -4.80727094757851E-23
     -6.13467200490335E-10  -6.11830963597062E-10  -1.27178722191355E-18  -1.79258435798942E-02  -1.79258435840011E-02
      0.00000000000000E+00   0.00000000000000E+00   4.10698684345423E-09   0.00000000000000E+00   4.10698684345423E-09
      4.05855020755345E-18  -1.86620903773071E-01  -1.85519680152238E-01   0.00000000000000E+00  -1.24480061444047E-10
     -1.24049231519355E-22  -3.37067581841298E-09  -3.49515587985715E-09  -2.78676298563990E-18
      4.62475214595671E-09
      0.00000000000000E+00   3.22191338124004E-13   0.00000000000000E+00   6.84643372254404E-13  -4.81206198699773E-23
     -3.22871393400987E-10  -3.22186750028781E-10  -1.27687552834057E-18  -1.41571882325290E-02  -1.41571882357562E-02
      0.00000000000000E+00   0.00000000000000E+00   3.22729247073920E-09   0.00000000000000E+00   3.22729247073920E-09
      4.12309605696823E-18  -2.21803162642767E-01  -2.20887843762348E-01   0.00000000000000E+00  -1.23307282171038E-10
     -1.29733547249072E-22  -2.78179843853929E-09  -2.90510572071046E-09  -2.84622052862766E-18
      4.64475214595671E-09
      0.00000000000000E+00   2.10599982416859E-13   0.00000000000000E+00   2.63831062780666E-13  -4.81412461043369E-23
     -2.10843881661434E-10  -2.10580050598702E-10  -1.27976277358687E-18  -1.18860563220635E-02  -1.18860563246368E-02
      0.00000000000000E+00   0.00000000000000E+00   2.57330960726956E-09   0.00000000000000E+00   2.57330960726956E-09
      4.17456224911363E-18  -2.51578834568930E-01  -2.50834401474262E-01   0.00000000000000E+00  -1.14444945802365E-10
     -1.34596237073188E-22  -2.24828461086833E-09  -2.36272955667083E-09  -2.89479947552675E-18
      4.66475214595672E-09
      0.00000000000000E+00   1.63759166441020E-13   0.00000000000000E+00   1.11216854595390E-13  -4.81504116301638E-23
     -1.63905102398060E-10  -1.63793885543512E-10  -1.28173917840252E-18  -1.03469495948963E-02  -1.03469495969042E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00790308955312E-09   0.00000000000000E+00   2.00790308955312E-09
      4.21472031090469E-18  -2.75022953309793E-01  -2.74441923336273E-01   0.00000000000000E+00  -9.73056896347676E-11
     -1.38480072569304E-22  -1.74680351437479E-09  -1.84410920400969E-09  -2.93298113250217E-18
      4.68475214595672E-09
      0.00000000000000E+00   1.40522447927516E-13   0.00000000000000E+00   5.66420025304252E-14  -4.81536216986061E-23
     -1.40567927773728E-10  -1.40511285771245E-10  -1.28326923268776E-18  -9.24421258220109E-03  -9.24421258372496E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52387431500129E-09   0.00000000000000E+00   1.52387431500129E-09
      4.24519779720471E-18  -2.92339304795750E-01  -2.91903445058715E-01   0.00000000000000E+00  -7.56965760199623E-11
     -1.41370060724155E-22  -1.30766645321001E-09  -1.38336302923012E-09  -2.96192856451695E-18
      4.70475214595672E-09
      0.00000000000000E+00   1.27939718930085E-13   0.00000000000000E+00   3.18753231845236E-14  -4.81537254838368E-23
     -1.27975646033540E-10  -1.27943770710404E-10  -1.28456257796804E-18  -8.42665913405551E-03  -8.42665913517622E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12070526475104E-09   0.00000000000000E+00   1.12070526475104E-09
      4.26761190249973E-18  -3.04205048033970E-01  -3.03892258815033E-01   0.00000000000000E+00  -5.30871670767834E-11
     -1.43341187156102E-22  -9.39674326963627E-10  -9.92761494040554E-10  -2.98304932453170E-18
      4.72475214595672E-09
      0.00000000000000E+00   1.20408450479068E-13   0.00000000000000E+00   2.02005453481981E-14  -4.81520824770514E-23
     -1.20466368108839E-10  -1.20446167563539E-10  -1.28571686816752E-18  -7.80893399764101E-03  -7.80893399843435E-03
      0.00000000000000E+00   0.00000000000000E+00   7.93344830134745E-10   0.00000000000000E+00   7.93344830134745E-10
      4.28347879910243E-18  -3.11484907084794E-01  -3.11272900771834E-01   0.00000000000000E+00  -3.20619996300005E-11
     -1.44518879946141E-22  -6.40836662941019E-10  -6.72898662571163E-10  -2.99776193093491E-18
      4.74475214595672E-09
      0.00000000000000E+00   1.08101255693259E-13   0.00000000000000E+00   3.38536304072128E-14  -4.81463074653733E-23
     -1.08128716008326E-10  -1.08094862377967E-10  -1.28663326296732E-18  -7.39405312244816E-03  -7.39405312305032E-03
      0.00000000000000E+00   0.00000000000000E+00   6.02154301727711E-10   0.00000000000000E+00   6.02154301727711E-10
      4.29552188513698E-18  -3.16304597223012E-01  -3.16148939962678E-01   0.00000000000000E+00  -1.99640005322473E-11
     -1.45249484314854E-22  -4.74095438817326E-10  -4.94059439349718E-10  -3.00888862216966E-18
      4.76475214595672E-09
      0.00000000000000E+00   9.38653214260923E-14   0.00000000000000E+00   4.06958399189948E-14  -4.81359295887835E-23
     -9.38648178165436E-11  -9.38241219766727E-11  -1.28727359817609E-18  -7.14073091176932E-03  -7.14073091233762E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68298304173400E-10   0.00000000000000E+00   5.68298304173400E-10
      4.30688785122045E-18  -3.21055074423468E-01  -3.20905587948123E-01   0.00000000000000E+00  -1.93676351553087E-11
     -1.45943530421029E-22  -4.55106547041305E-10  -4.74474182196760E-10  -3.01961425304436E-18
      4.78475214595672E-09
      0.00000000000000E+00   8.70688108727354E-14   0.00000000000000E+00   2.29965212100662E-14  -4.81242408211813E-23
     -8.70845287036414E-11  -8.70615321824795E-11  -1.28778855383382E-18  -6.94012469162219E-03  -6.94012469221236E-03
      0.00000000000000E+00   0.00000000000000E+00   5.90162119401175E-10   0.00000000000000E+00   5.90162119401175E-10
      4.31869109360848E-18  -3.26332854410966E-01  -3.26174348123450E-01   0.00000000000000E+00  -2.21376374021399E-11
     -1.46720261273821E-22  -4.80962949816439E-10  -5.03100587218726E-10  -3.03090253977466E-18
      4.78975214595672E-09
      0.00000000000000E+00   8.86301714052633E-14   0.00000000000000E+00  -8.94383917983947E-15  -4.81216988663056E-23
     -8.85900545154596E-11  -8.85989983546876E-11  -1.28792557456650E-18  -6.88667499588931E-03  -6.88667499645711E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67797606189906E-10   0.00000000000000E+00   5.67797606189906E-10
      4.32153008163943E-18  -3.27548914531432E-01  -3.27397939427962E-01   0.00000000000000E+00  -2.02287049297835E-11
     -1.46897406650625E-22  -4.58969902905619E-10  -4.79198607835550E-10  -3.03360450707293E-18
      4.79650214595672E-09
      0.00000000000000E+00   8.04559897937934E-14   0.00000000000000E+00   6.57804638290050E-14  -4.81167093244214E-23
     -8.05641979785050E-11  -8.04984175147241E-11  -1.28805704321926E-18  -6.84049438556881E-03  -6.84049438616712E-03
      0.00000000000000E+00   0.00000000000000E+00   5.98316256871199E-10   0.00000000000000E+00   5.98316256871199E-10
      4.32556871637330E-18  -3.29442699616221E-01  -3.29279555962212E-01   0.00000000000000E+00  -2.39073554057901E-11
     -1.47175400417129E-22  -4.93910483950852E-10  -5.17817839356789E-10  -3.03751167315405E-18
      4.80561464595672E-09
      0.00000000000000E+00   7.35676345032289E-14   0.00000000000000E+00   4.59886323284952E-14  -4.81092549802123E-23
     -7.35800311513258E-11  -7.35340425190455E-11  -1.28817343863734E-18  -6.79742480873368E-03  -6.79742480940556E-03
      0.00000000000000E+00   0.00000000000000E+00   6.71874871669674E-10   0.00000000000000E+00   6.71874871669674E-10
      4.33169117614139E-18  -3.32598535768596E-01  -3.32410020461254E-01   0.00000000000000E+00  -3.06462162081021E-11
     -1.47651342806099E-22  -5.67694612942413E-10  -5.98340829150662E-10  -3.04351773750406E-18
      4.81176558345672E-09
      0.00000000000000E+00   6.58526765777967E-14   0.00000000000000E+00   7.05834679784309E-14  -4.81032561811512E-23
     -6.59471584913568E-11  -6.58765750234265E-11  -1.28820610279887E-18  -6.78490587089460E-03  -6.78490587163884E-03
      0.00000000000000E+00   0.00000000000000E+00   7.44245601972301E-10   0.00000000000000E+00   7.44245601972301E-10
      4.33626898432378E-18  -3.35137405252953E-01  -3.34923674105322E-01   0.00000000000000E+00  -3.75210293753257E-11
     -1.48040918581166E-22  -6.40847997573261E-10  -6.78369026948735E-10  -3.04806288152491E-18
      4.82006934908172E-09
      0.00000000000000E+00   5.66682028570440E-14   0.00000000000000E+00   6.54284862203068E-14  -4.80940059497347E-23
     -5.67508673411550E-11  -5.66854388549828E-11  -1.28817640748834E-18  -6.78596145394177E-03  -6.78596145482071E-03
      0.00000000000000E+00   0.00000000000000E+00   8.78938237779428E-10   0.00000000000000E+00   8.78938237779428E-10
      4.34356748144915E-18  -3.39526141265817E-01  -3.39267074364249E-01   0.00000000000000E+00  -4.97490018769278E-11
     -1.48731640068020E-22  -7.72503797047440E-10  -8.22252798924517E-10  -3.05539107396081E-18
      4.83127943267547E-09
      0.00000000000000E+00   5.19841212594601E-14   0.00000000000000E+00   3.21214048045529E-14  -4.80813160772443E-23
     -5.20303213407556E-11  -5.19981999359991E-11  -1.28808905300460E-18  -6.77315637727129E-03  -6.77315637831765E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04636328060648E-09   0.00000000000000E+00   1.04636328060648E-09
      4.35529730129417E-18  -3.46945415876575E-01  -3.46632118948456E-01   0.00000000000000E+00  -6.47268597649813E-11
     -1.49931426684197E-22  -9.29638220905273E-10  -9.94365080670404E-10  -3.06720824828957E-18
      4.84641304552703E-09
      0.00000000000000E+00   5.45557739012709E-14   0.00000000000000E+00   2.19367579870483E-15  -4.80658832254140E-23
     -5.45784356375097E-11  -5.45762419617590E-11  -1.28802048737177E-18  -6.68247460013544E-03  -6.68247460131148E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17604136505852E-09   0.00000000000000E+00   1.17604136505852E-09
      4.37309505601040E-18  -3.58399164745362E-01  -3.58045820557438E-01   0.00000000000000E+00  -7.71366290019436E-11
     -1.51830796942618E-22  -1.04432849409461E-09  -1.12146512309670E-09  -3.08507456863863E-18
      4.86641304552703E-09
      0.00000000000000E+00   6.39239370964386E-14   0.00000000000000E+00  -1.46644708376980E-14  -4.80498927706726E-23
     -6.39140588732426E-11  -6.39287233441283E-11  -1.28813486273091E-18  -6.41900854496054E-03  -6.41900854618222E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22168211755100E-09   0.00000000000000E+00   1.22168211755100E-09
      4.39752869836142E-18  -3.74012818928024E-01  -3.73648040883753E-01   0.00000000000000E+00  -8.34728169359659E-11
     -1.54486101498772E-22  -1.07428057727076E-09  -1.15775339420688E-09  -3.10939383563050E-18
      4.88641304552703E-09
      0.00000000000000E+00   8.00886108449633E-14   0.00000000000000E+00  -3.46796604923441E-14  -4.80406608563023E-23
     -8.00409166035710E-11  -8.00755962641114E-11  -1.28858893284537E-18  -5.95704843944831E-03  -5.95704844066437E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21605968082978E-09   0.00000000000000E+00   1.21605968082978E-09
      4.42184989197801E-18  -3.89175089047719E-01  -3.88817169865060E-01   0.00000000000000E+00  -8.55864009688678E-11
     -1.57140632558075E-22  -1.05039768359659E-09  -1.13598408456562E-09  -3.13326095913264E-18
      4.90641304552703E-09
      0.00000000000000E+00   9.79064898632235E-14   0.00000000000000E+00  -4.22505485541842E-14  -4.80383261869315E-23
     -9.78228484715061E-11  -9.78650990201083E-11  -1.28941404928200E-18  -5.28590135886391E-03  -5.28590136006086E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19695640964183E-09   0.00000000000000E+00   1.19695640964183E-09
      4.44578902017085E-18  -4.03637909070163E-01  -4.03291613963872E-01   0.00000000000000E+00  -8.61564580034526E-11
     -1.59750021493184E-22  -1.01293485261805E-09  -1.09909131062167E-09  -3.15637497088885E-18
      4.92641304552703E-09
      0.00000000000000E+00   1.06723584635146E-13   0.00000000000000E+00  -2.20986344491163E-14  -4.80389798186289E-23
     -1.06676696897779E-10  -1.06698795532276E-10  -1.29042996339879E-18  -4.51542878789418E-03  -4.51542878905853E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16435087457898E-09   0.00000000000000E+00   1.16435087457898E-09
      4.46907603766243E-18  -4.17423907368366E-01  -4.17090668939239E-01   0.00000000000000E+00  -8.59183647134361E-11
     -1.62295422702322E-22  -9.71733714333229E-10  -1.05765207904683E-09  -3.17864607426364E-18
      4.94641304552703E-09
      0.00000000000000E+00   1.01029210928279E-13   0.00000000000000E+00   1.42995073498996E-14  -4.80371513145611E-23
     -1.01061709184832E-10  -1.01047409677531E-10  -1.29134656287832E-18  -3.81903808427578E-03  -3.81903808538945E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11367431265671E-09   0.00000000000000E+00   1.11367431265671E-09
      4.49134952391556E-18  -4.30628421314111E-01  -4.30309369545054E-01   0.00000000000000E+00  -8.48548081147426E-11
     -1.64758465162157E-22  -9.27772094864257E-10  -1.01262690297916E-09  -3.20000296103724E-18
      4.96641304552703E-09
      0.00000000000000E+00   7.72414239915300E-14   0.00000000000000E+00   6.30234958804517E-14  -4.80262560243448E-23
     -7.72780155945396E-11  -7.72149920987072E-11  -1.29180078109312E-18  -3.41328194737793E-03  -3.41328194841684E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03891035017603E-09   0.00000000000000E+00   1.03891035017603E-09
      4.51212773091908E-18  -4.43348588126694E-01  -4.43045584175228E-01   0.00000000000000E+00  -8.26101941577766E-11
     -1.67111322104750E-22  -8.79085163919351E-10  -9.61695358077294E-10  -3.22032694982596E-18
      4.98641304552703E-09
      0.00000000000000E+00  -1.06356205686316E-13   0.00000000000000E+00   4.87531614823028E-13  -4.79414608044700E-23
      1.05884267726658E-10   1.06371799341433E-10  -1.28860666509025E-18  -5.21591250845051E-03  -5.21591250916247E-03
      0.00000000000000E+00   0.00000000000000E+00   7.11961398765877E-10   0.00000000000000E+00   7.11961398765877E-10
      4.52636695889440E-18  -4.55865003022336E-01  -4.55607171547527E-01   0.00000000000000E+00  -6.84358196986349E-11
     -1.69025343959355E-22  -7.49897378408492E-10  -8.18333198107296E-10  -3.23776029380415E-18
      5.00641304552703E-09
      0.00000000000000E+00  -8.82168700878294E-13   0.00000000000000E+00   2.07269784354737E-12  -4.75496641701456E-23
      8.80096505824669E-10   8.82169203668169E-10  -1.26997738832041E-18  -1.62292465266221E-02  -1.62292465260640E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.58073657585592E-10   0.00000000000000E+00  -5.58073657585592E-10
      4.51520548574269E-18  -4.68990501511906E-01  -4.68888402939519E-01   0.00000000000000E+00  -9.12344439576795E-12
     -1.69254967981847E-22  -3.14972101686656E-10  -3.24095546082593E-10  -3.24522809742228E-18
      5.02641304552703E-09
      0.00000000000000E+00  -1.71988454894815E-12   0.00000000000000E+00   2.34214674219013E-12  -4.68717522204292E-23
      1.71760386269796E-09   1.71994600944011E-09  -1.23483366171405E-18  -3.66593339613007E-02  -3.66593339593953E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.90538923567685E-09   0.00000000000000E+00  -1.90538923567685E-09
      4.47709770102915E-18  -4.82635882846750E-01  -4.82694339365237E-01   0.00000000000000E+00   5.26162724216550E-11
     -1.67737363167336E-22   1.32826953815271E-10   1.85443226236759E-10  -3.24226403931510E-18
      5.03141304552703E-09
      0.00000000000000E+00  -2.01773703171216E-12   0.00000000000000E+00   3.22773989305777E-12  -4.66722178200910E-23
      2.01448556293376E-09   2.01771330282677E-09  -1.22458536499158E-18  -4.25302700819927E-02  -4.25302700796210E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.37169741498579E-09   0.00000000000000E+00  -2.37169741498579E-09
      4.46523921395422E-18  -4.86060571279423E-01  -4.86172134626281E-01   0.00000000000000E+00   7.23652062725753E-11
     -1.67217234101853E-22   2.81618905886845E-10   3.53984112159253E-10  -3.24065384896264E-18
      5.03816304552703E-09
      0.00000000000000E+00  -2.26121743004931E-12   0.00000000000000E+00   2.10708245941509E-12  -4.63876423511770E-23
      2.25910723683805E-09   2.26121431929742E-09  -1.20917300485055E-18  -5.12653554684607E-02  -5.12653554657124E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.74833029859672E-09   0.00000000000000E+00  -2.74833029859672E-09
      4.44668798443869E-18  -4.90712415714921E-01  -4.90865928784143E-01   0.00000000000000E+00   8.71346040306573E-11
     -1.66368479028889E-22   3.99981375268633E-10   4.87115979299124E-10  -3.23751497958815E-18
      5.04727554552703E-09
      0.00000000000000E+00  -2.53702717588351E-12   0.00000000000000E+00   1.82752187179944E-12  -4.59703187690354E-23
      2.53519495162752E-09   2.53702247349927E-09  -1.18603975235677E-18  -6.41837671690939E-02  -6.41837671659398E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.15406504908304E-09   0.00000000000000E+00  -3.15406504908304E-09
      4.41794656667893E-18  -4.96994350742806E-01  -4.97188804515073E-01   0.00000000000000E+00   1.01882588062920E-10
     -1.65023238540136E-22   5.15159987521011E-10   6.17042575583767E-10  -3.23190681432215E-18
      5.05957742052703E-09
      0.00000000000000E+00  -2.91680516423663E-12   0.00000000000000E+00   1.86432939704905E-12  -4.53481502659612E-23
      2.91495737140762E-09   2.91682170080462E-09  -1.15075787543231E-18  -8.34603634186764E-02  -8.34603634150052E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.67120155458767E-09   0.00000000000000E+00  -3.67120155458767E-09
      4.37278390405458E-18  -5.05431116190673E-01  -5.05668848393245E-01   0.00000000000000E+00   1.18614866948652E-10
     -1.62895182663404E-22   6.35764986834346E-10   7.54379853782836E-10  -3.22202602862227E-18
      5.06372930333953E-09
      0.00000000000000E+00  -3.14494749146013E-12   0.00000000000000E+00   3.03465976841737E-12  -4.51203766212021E-23
      3.14192183654987E-09   3.14495649631824E-09  -1.13801307589636E-18  -9.03113737601187E-02  -9.03113737561435E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.97523201812303E-09   0.00000000000000E+00  -3.97523201812303E-09
      4.35627920656284E-18  -5.08271839577199E-01  -5.08533487405916E-01   0.00000000000000E+00   1.26592824470071E-10
     -1.62124983576116E-22   7.03682697335408E-10   8.30275521805317E-10  -3.21826613066648E-18
      5.06933434513641E-09
      0.00000000000000E+00  -3.41350150305494E-12   0.00000000000000E+00   2.71064918892652E-12  -4.47971375736589E-23
      3.41077064573220E-09   3.41348129492108E-09  -1.11957330340492E-18  -1.00108795526133E-01  -1.00108795521815E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31825933982572E-09   0.00000000000000E+00  -4.31825933982572E-09
      4.33207518247336E-18  -5.12107262326012E-01  -5.12392389512912E-01   0.00000000000000E+00   1.36607196883223E-10
     -1.60997900919664E-22   7.68170848021595E-10   9.04778044904657E-10  -3.21250187906845E-18
      5.07690115156219E-09
      0.00000000000000E+00  -3.78133967557108E-12   0.00000000000000E+00   2.74459066244639E-12  -4.43191505470949E-23
      3.77855628529305E-09   3.78130087595545E-09  -1.09264673405998E-18  -1.14185026960510E-01  -1.14185026955772E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.73828838384509E-09   0.00000000000000E+00  -4.73828838384509E-09
      4.29622147148328E-18  -5.17242771946508E-01  -5.17544358714961E-01   0.00000000000000E+00   1.47521119310172E-10
     -1.59343563542965E-22   8.09466388579900E-10   9.56987507889913E-10  -3.20357473742330E-18
      5.08711634023699E-09
      0.00000000000000E+00  -4.28896553811708E-12   0.00000000000000E+00   2.78855087173232E-12  -4.35293378138026E-23
      4.28616871899295E-09   4.28895726986464E-09  -1.05350278253725E-18  -1.34176756121719E-01  -1.34176756116543E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.17576624682780E-09   0.00000000000000E+00  -5.17576624682780E-09
      4.24335004273525E-18  -5.23949585684940E-01  -5.24229080700320E-01   0.00000000000000E+00   1.55919485553118E-10
     -1.56956071159592E-22   7.30889491410204E-10   8.86808976963165E-10  -3.18984726019800E-18
      5.10090684494798E-09
      0.00000000000000E+00  -5.12071147826845E-12   0.00000000000000E+00   3.27961231078590E-12  -4.16129254772335E-23
      5.11739309430807E-09   5.12067270661881E-09  -9.98111396833898E-19  -1.61566692558327E-01  -1.61566692552806E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52132311761617E-09   0.00000000000000E+00  -5.52132311761617E-09
      4.16720821027089E-18  -5.32080566484926E-01  -5.32206934553254E-01   0.00000000000000E+00   1.57800880296811E-10
     -1.53628149195003E-22   2.42849530700701E-10   4.00650410997359E-10  -3.16909681343699E-18
      5.11952402630781E-09
      0.00000000000000E+00  -7.15810328374301E-12   0.00000000000000E+00   5.64348436815197E-12  -3.37150371934851E-23
      7.15247948512622E-09   7.15812296949434E-09  -9.23553869401806E-19  -1.96914897875230E-01  -1.96914897869487E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74372001795048E-09   0.00000000000000E+00  -5.74372001795048E-09
      4.06027633301661E-18  -5.39418908326772E-01  -5.38973543001083E-01   0.00000000000000E+00   1.55376429592105E-10
     -1.49024447579216E-22  -1.56977938113592E-09  -1.41440295154396E-09  -3.13672246361480E-18
      5.13952402630781E-09
      0.00000000000000E+00  -1.17074486518434E-11   0.00000000000000E+00   1.13945495740506E-11  -8.39993254318601E-24
      1.16960096093915E-08   1.17074041589655E-08  -8.48988122033371E-19  -2.30764119804037E-01  -2.30764119798092E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94561547993804E-09   0.00000000000000E+00  -5.94561547993804E-09
      3.94136402341785E-18  -5.38735289743689E-01  -5.36920469060291E-01   0.00000000000000E+00   1.57215210765606E-10
     -1.43619085326723E-22  -5.91900388979297E-09  -5.76178867902751E-09  -3.09237590138448E-18
      5.15952402630781E-09
      0.00000000000000E+00  -1.91481581919740E-11   0.00000000000000E+00   1.84762831036810E-11   3.90179625912552E-23
      1.91296078456673E-08   1.91480841287710E-08  -7.85355907170706E-19  -2.58798742859247E-01  -2.58798742853048E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19928331232096E-09   0.00000000000000E+00  -6.19928331232096E-09
      3.81737835717143E-18  -5.24128883798546E-01  -5.20050005369491E-01   0.00000000000000E+00   1.66434900619749E-10
     -1.37150681367172E-22  -1.31152357170696E-08  -1.29488008164500E-08  -3.03202245000073E-18
      5.17952402630781E-09
      0.00000000000000E+00  -2.78873686267446E-11   0.00000000000000E+00   2.16677277170288E-11   9.44914462570770E-23
      2.78656719105729E-08   2.78873396382900E-08  -7.35879568019769E-19  -2.80466419576831E-01  -2.80466419570343E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48768610326796E-09   0.00000000000000E+00  -6.48768610326796E-09
      3.68762463510607E-18  -4.92228084064528E-01  -4.85486847565711E-01   0.00000000000000E+00   1.75289833173803E-10
     -1.29164027435505E-22  -2.15749433681958E-08  -2.13996535350221E-08  -2.95174506708630E-18
      5.19952402630781E-09
      0.00000000000000E+00  -3.50984663238564E-11   0.00000000000000E+00   1.78973997680813E-11   1.40915275685725E-22
      3.50805759596297E-08   3.50984733593980E-08  -7.00890598650401E-19  -2.96182336340859E-01  -2.96182336334088E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77104021662931E-09   0.00000000000000E+00  -6.77104021662931E-09
      3.55220383077348E-18  -4.42793810393337E-01  -4.33869854257594E-01   0.00000000000000E+00   1.74688760319756E-10
     -1.19811167507814E-22  -2.85021219030883E-08  -2.83274331427687E-08  -2.85131323212308E-18
      5.21952402630781E-09
      0.00000000000000E+00  -3.84278380476292E-11   0.00000000000000E+00   8.29432383458120E-12   1.64375202006310E-22
      3.84195425184121E-08   3.84278368422468E-08  -6.79310217597062E-19  -3.06652889683068E-01  -3.06652889676029E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03842976354498E-09   0.00000000000000E+00  -7.03842976354498E-09
      3.41143523550258E-18  -3.77589021313529E-01  -3.67700134088747E-01   0.00000000000000E+00   1.63215463191444E-10
     -1.09885884022646E-22  -3.15526225418932E-08  -3.13894070787018E-08  -2.73212501790552E-18
      5.23952402630781E-09
      0.00000000000000E+00  -3.73755728934426E-11   0.00000000000000E+00  -2.56471009488395E-12   1.61572656486107E-22
      3.73781776853365E-08   3.73756129752417E-08  -6.68701773888984E-19  -3.12948723905632E-01  -3.12948723898366E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26664471938947E-09   0.00000000000000E+00  -7.26664471938947E-09
      3.26610234111479E-18  -3.01730337083384E-01  -2.92244593904823E-01   0.00000000000000E+00   1.39660641039563E-10
     -1.00064470211264E-22  -3.02486288968917E-08  -3.01089682558523E-08  -2.59740056722581E-18
      5.25952402630781E-09
      0.00000000000000E+00  -3.45124050557351E-11   0.00000000000000E+00  -7.06791425789067E-12   1.44739750633036E-22
      3.45194237896889E-08   3.45123558754311E-08  -6.62624073617362E-19  -3.17586027496335E-01  -3.17586027488988E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34709848137944E-09   0.00000000000000E+00  -7.34709848137944E-09
      3.11916037148720E-18  -2.27226999338582E-01  -2.18668489546029E-01   0.00000000000000E+00   1.01262490827592E-10
     -8.98327057253137E-23  -2.72665198848791E-08  -2.71652573940516E-08  -2.45653629786984E-18
      5.27952402630781E-09
      0.00000000000000E+00  -3.20401284195829E-11   0.00000000000000E+00  -6.11028275070410E-12   1.26304632227215E-22
      3.20462036811695E-08   3.20400933984189E-08  -6.56072923016140E-19  -3.22461642906437E-01  -3.22461642899142E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29494056682986E-09   0.00000000000000E+00  -7.29494056682986E-09
      2.97326156015061E-18  -1.61180973757581E-01  -1.53384810306990E-01   0.00000000000000E+00   6.62547977739085E-11
     -8.21799934162645E-23  -2.48114076293630E-08  -2.47451528315891E-08  -2.31718863713447E-18
      5.28952402630781E-09
      0.00000000000000E+00  -3.07471382091754E-11   0.00000000000000E+00  -6.38584085357332E-12   1.16622452020996E-22
      3.07535475784416E-08   3.07471617375881E-08  -6.52905929696821E-19  -3.24868927925442E-01  -3.24868927918165E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27690976006229E-09   0.00000000000000E+00  -7.27690976006229E-09
      2.90049246254998E-18  -1.30447184496215E-01  -1.23052645641214E-01   0.00000000000000E+00   5.07780550064188E-11
     -7.95384693413834E-23  -2.35210300325321E-08  -2.34702519775258E-08  -2.24758653285317E-18
      5.30302402630781E-09
      0.00000000000000E+00  -2.94177774828336E-11   0.00000000000000E+00  -4.86419327991116E-12   1.06062814441131E-22
      2.94226374769869E-08   2.94177732837071E-08  -6.47126151884652E-19  -3.28698009665891E-01  -3.28698009658703E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.18823619780581E-09   0.00000000000000E+00  -7.18823619780581E-09
      2.80345127387961E-18  -9.36207650291792E-02  -8.66170842445162E-02   0.00000000000000E+00   3.88820087065955E-11
     -7.35317182345551E-23  -2.22684190946078E-08  -2.22295370859013E-08  -2.15632512199496E-18
      5.32124902630781E-09
      0.00000000000000E+00  -2.72863366664585E-11   0.00000000000000E+00  -5.76062070248287E-12   9.84777931726348E-23
      2.72921064581319E-08   2.72863458374295E-08  -6.33934269791580E-19  -3.35764134803656E-01  -3.35764134796667E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.98880882444750E-09   0.00000000000000E+00  -6.98880882444750E-09
      2.67608023305405E-18  -5.50202222488443E-02  -4.86252040017185E-02   0.00000000000000E+00   2.85267398611100E-11
     -4.25479333155121E-23  -2.03260637528431E-08  -2.02975370129820E-08  -2.04214596326247E-18
      5.32624902630781E-09
      0.00000000000000E+00  -2.60986005248908E-11   0.00000000000000E+00  -1.16593561562759E-11   9.70795134492322E-23
      2.61102629915389E-08   2.60986036353828E-08  -6.29322965571278E-19  -3.38012296991809E-01  -3.38012296984912E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.89638195161488E-09   0.00000000000000E+00  -6.89638195161488E-09
      2.64159832329598E-18  -4.61175743614813E-02  -4.00676423828306E-02   0.00000000000000E+00   2.84908023992892E-11
     -2.53106781121220E-23  -1.92307124861671E-08  -1.92022216837679E-08  -2.01227535772470E-18
      5.33299902630781E-09
      0.00000000000000E+00  -2.46958558535202E-11   0.00000000000000E+00  -1.02486067028215E-11   9.80314281950113E-23
      2.47060974127724E-08   2.46958488060696E-08  -6.20858203316479E-19  -3.41827729718223E-01  -3.41827729711507E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71692841592266E-09   0.00000000000000E+00  -6.71692841592266E-09
      2.59625905648850E-18  -3.70065192234911E-02  -3.13419965558995E-02   0.00000000000000E+00   2.31199849028568E-11
      2.38147745019725E-24  -1.80020403750499E-08  -1.79789203901471E-08  -1.97540085317202E-18
      5.34211152630781E-09
      0.00000000000000E+00  -2.32008072212561E-11   0.00000000000000E+00  -8.07873164649989E-12   1.03517754908025E-22
      2.32088587095879E-08   2.32007799779415E-08  -6.06368061600223E-19  -3.48029955778900E-01  -3.48029955772397E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50331220432300E-09   0.00000000000000E+00  -6.50331220432300E-09
      2.53699762402660E-18  -2.87523780064700E-02  -2.34915868656414E-02   0.00000000000000E+00   1.77348019810616E-11
      4.01261478094455E-23  -1.67152025755996E-08  -1.66974677736185E-08  -1.93062956242638E-18
      5.35441340130781E-09
      0.00000000000000E+00  -2.18682319291121E-11   0.00000000000000E+00  -5.31852822198679E-12   1.14710852477332E-22
      2.18735318737138E-08   2.18682133454919E-08  -5.83872502055533E-19  -3.57383189571378E-01  -3.57383189565077E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.30086657343630E-09   0.00000000000000E+00  -6.30086657343630E-09
      2.45948515104851E-18  -2.21279342898841E-02  -1.72231965248133E-02   0.00000000000000E+00   1.25661923755002E-11
      8.55408380578175E-23  -1.55799129644310E-08  -1.55673467720554E-08  -1.87561264899298E-18
      5.37102093255781E-09
      0.00000000000000E+00  -2.08177118249324E-11   0.00000000000000E+00  -3.08788532368757E-12   1.29714120328428E-22
      2.08208112047102E-08   2.08177233193867E-08  -5.52095171532586E-19  -3.70423857829913E-01  -3.70423857823780E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.13267357298570E-09   0.00000000000000E+00  -6.13267357298570E-09
      2.35763658303910E-18  -1.71863800028219E-02  -1.25596162157751E-02   0.00000000000000E+00   8.65008739693497E-12
      1.34779213729085E-22  -1.46936998337981E-08  -1.46850497464010E-08  -1.80554141150652E-18
      5.39102093255781E-09
      0.00000000000000E+00  -1.99804552005486E-11   0.00000000000000E+00  -2.03111796978673E-12   1.40835738551572E-22
      1.99824692654434E-08   1.99804381474737E-08  -5.14670177700835E-19  -3.85751828483892E-01  -3.85751828477894E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.99746296086269E-09   0.00000000000000E+00  -5.99746296086269E-09
      2.23768732382185E-18  -1.38079189304788E-02  -9.40234898049189E-03   0.00000000000000E+00   6.40716321437798E-12
      1.74112360969228E-22  -1.39893823498256E-08  -1.39829751866111E-08  -1.72301714612102E-18
      5.41102093255782E-09
      0.00000000000000E+00  -1.92685666424531E-11   0.00000000000000E+00  -1.72389981432100E-12   1.41659191882501E-22
      1.92703258747317E-08   1.92686019749175E-08  -4.79108705609848E-19  -4.00381458363622E-01  -4.00381458357734E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.88786564051613E-09   0.00000000000000E+00  -5.88786564051613E-09
      2.11993001101153E-18  -1.16696945505754E-02  -7.45386554038651E-03   0.00000000000000E+00   5.29028096227409E-12
      1.91049195349340E-22  -1.33860266153637E-08  -1.33807363344012E-08  -1.64082130540168E-18
      5.43102093255782E-09
      0.00000000000000E+00  -1.86312560109700E-11   0.00000000000000E+00  -1.54353875169010E-12   1.32570208793577E-22
      1.86327710255000E-08   1.86312274867485E-08  -4.45481814683331E-19  -4.14314453756166E-01  -4.14314453750376E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78935819564722E-09   0.00000000000000E+00  -5.78935819564722E-09
      2.00414284709858E-18  -1.01965962672145E-02  -6.15054302141761E-03   0.00000000000000E+00   4.55765643350729E-12
      1.87435033435969E-22  -1.28464269475350E-08  -1.28418692911014E-08  -1.55866103241525E-18
      5.45102093255782E-09
      0.00000000000000E+00  -1.80796365193016E-11   0.00000000000000E+00  -1.33486247857627E-12   1.15978980768680E-22
      1.80809901757590E-08   1.80796553132805E-08  -4.13536799266948E-19  -4.27642762749494E-01  -4.27642762743793E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70038297321111E-09   0.00000000000000E+00  -5.70038297321111E-09
      1.89013518763436E-18  -9.13501259779399E-03  -5.23470567346674E-03   0.00000000000000E+00   3.96022311617350E-12
      1.68061814829382E-22  -1.23832325631858E-08  -1.23792723400695E-08  -1.47659838836741E-18
      5.47102093255782E-09
      0.00000000000000E+00  -1.76135244779734E-11   0.00000000000000E+00  -1.12637534899024E-12   9.51258599428646E-23
      1.76146751108787E-08   1.76135487355298E-08  -3.82980411889365E-19  -4.40462751720733E-01  -4.40462751715113E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62034596802378E-09   0.00000000000000E+00  -5.62034596802378E-09
      1.77772826827389E-18  -8.34459161985360E-03  -4.56592026582477E-03   0.00000000000000E+00   3.46494089523377E-12
      1.39093769261279E-22  -1.19966677084013E-08  -1.19932027675059E-08  -1.39474785638452E-18
      5.49102093255782E-09
      0.00000000000000E+00  -1.72779238082171E-11   0.00000000000000E+00  -8.06480994143812E-13   7.33318553150545E-23
      1.72787209861546E-08   1.72779145051605E-08  -3.53318022518728E-19  -4.52963584764415E-01  -4.52963584758821E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59454281728740E-09   0.00000000000000E+00  -5.59454281728740E-09
      1.66583741192814E-18  -7.74902172427707E-03  -4.06796605348011E-03   0.00000000000000E+00   3.05405863594277E-12
      1.06708537888219E-22  -1.16864257465092E-08  -1.16833716878731E-08  -1.31251938940941E-18
      5.51102093255782E-09
      0.00000000000000E+00  -1.73973219665869E-11   0.00000000000000E+00   3.14046261973194E-13   5.34639170525481E-23
      1.73969783126559E-08   1.73972923589179E-08  -3.22775211720217E-19  -4.65902971075282E-01  -4.65902971069402E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87990171207207E-09   0.00000000000000E+00  -5.87990171207207E-09
      1.54823937768670E-18  -7.35905989654273E-03  -3.73029761075530E-03   0.00000000000000E+00   2.62444045618916E-12
      7.60468186967581E-23  -1.15200150873021E-08  -1.15173906468458E-08  -1.22546416596648E-18
      5.53102093255782E-09
      0.00000000000000E+00  -1.77876620997189E-11   0.00000000000000E+00   9.83749764256436E-13   3.68482080546482E-23
      1.77866585916539E-08   1.77876423414182E-08  -2.90973316660928E-19  -4.79475412178369E-01  -4.79475412172080E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28959497706563E-09   0.00000000000000E+00  -6.28959497706563E-09
      1.42244747814538E-18  -7.11588775298587E-03  -3.49321806035972E-03   0.00000000000000E+00   2.22419157748488E-12
      4.99272044735807E-23  -1.15002715559301E-08  -1.14980473643526E-08  -1.13147416148446E-18
      5.54102093255782E-09
      0.00000000000000E+00  -1.79742906057246E-11   0.00000000000000E+00   9.42659095180016E-13   2.92211249180182E-23
      1.79733063197602E-08   1.79742489788554E-08  -2.75023294500719E-19  -4.86339125266225E-01  -4.86339125259739E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48639164165314E-09   0.00000000000000E+00  -6.48639164165314E-09
      1.35758356172885E-18  -7.00984050564670E-03  -3.39038049200843E-03   0.00000000000000E+00   2.14932649113674E-12
      3.78292628365907E-23  -1.14900066636934E-08  -1.14878573372022E-08  -1.08256026722813E-18
      5.55452093255782E-09
      0.00000000000000E+00  -1.81319880195099E-11   0.00000000000000E+00   5.98620648838759E-13   2.12512515363041E-23
      1.81313571657286E-08   1.81319557863775E-08  -2.53555115223038E-19  -4.95631636153391E-01  -4.95631636146788E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60190050116008E-09   0.00000000000000E+00  -6.60190050116008E-09
      1.26845790496319E-18  -6.89396479474230E-03  -3.26120833806033E-03   0.00000000000000E+00   1.87919976339933E-12
      2.53184234886289E-23  -1.15319344849809E-08  -1.15300552852175E-08  -1.01490278974016E-18
      5.57274593255782E-09
      0.00000000000000E+00  -1.82968493227974E-11   0.00000000000000E+00   4.66657800249992E-13   1.39789213449734E-23
      1.82964002222240E-08   1.82968668800243E-08  -2.25153354622604E-19  -5.08055473594297E-01  -5.08055473587629E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66842433884200E-09   0.00000000000000E+00  -6.66842433884200E-09
      1.14692587138780E-18  -6.77639473169509E-03  -3.11263804287479E-03   0.00000000000000E+00   1.65418347957661E-12
      1.40123198064853E-23  -1.16300967246618E-08  -1.16284425411822E-08  -9.21772516765192E-19
      5.57774593255782E-09
      0.00000000000000E+00  -1.84111041758836E-11   0.00000000000000E+00   1.14024770817314E-12   1.21520248064028E-23
      1.84099767796691E-08   1.84111170273772E-08  -2.17466089481710E-19  -5.11454232765534E-01  -5.11454232758798E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73631136509289E-09   0.00000000000000E+00  -6.73631136509289E-09
      1.11324431456233E-18  -6.76430010734065E-03  -3.08593535964097E-03   0.00000000000000E+00   1.38979425690558E-12
      1.11228838836177E-23  -1.16761954565413E-08  -1.16748056622843E-08  -8.95778225080622E-19
      5.58449593255782E-09
      0.00000000000000E+00  -1.85655870238667E-11   0.00000000000000E+00   1.14817106354964E-12   1.01928964805642E-23
      1.85644280794867E-08   1.85655762505503E-08  -2.07154176967147E-19  -5.16033455146692E-01  -5.16033455139925E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76783688389723E-09   0.00000000000000E+00  -6.76783688389723E-09
      1.06756141559603E-18  -6.77476650803565E-03  -3.05766851850092E-03   0.00000000000000E+00   9.13125579489474E-13
      8.06963311456088E-24  -1.17986524922326E-08  -1.17977393666531E-08  -8.60407238628879E-19
      5.59360843255782E-09
      0.00000000000000E+00  -1.86525639900022E-11   0.00000000000000E+00   4.92724974623762E-13   8.24907647641425E-24
      1.86520788407138E-08   1.86525715656884E-08  -1.93600319242704E-19  -5.22084004706464E-01  -5.22084004699766E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69757061369018E-09   0.00000000000000E+00  -6.69757061369018E-09
      1.00652980337877E-18  -6.77730369652821E-03  -3.01065682134341E-03   0.00000000000000E+00   8.84923661913294E-13
      5.11212493576491E-24  -1.19558858756603E-08  -1.19550009519984E-08  -8.12929484136070E-19
      5.60591030755782E-09
      0.00000000000000E+00  -1.84066037837604E-11   0.00000000000000E+00  -9.64963397894010E-13   6.44251997213705E-24
      1.84075653966205E-08   1.84066004332226E-08  -1.76720331932229E-19  -5.29665022117849E-01  -5.29665022111531E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31799291241641E-09   0.00000000000000E+00  -6.31799291241641E-09
      9.28806644319342E-19  -6.72320363815037E-03  -2.91446070283688E-03   0.00000000000000E+00   1.04094640554288E-12
      2.52807187108778E-24  -1.20896484672116E-08  -1.20886075208060E-08  -7.52086312387112E-19
      5.62251783880782E-09
      0.00000000000000E+00  -1.71830481946818E-11   0.00000000000000E+00  -3.61636572365343E-12   4.79960897320998E-24
      1.71866682176615E-08   1.71830518519378E-08  -1.59080415148179E-19  -5.37615590436163E-01  -5.37615590431134E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.02876258893231E-09   0.00000000000000E+00  -5.02876258893231E-09
      8.45291312474817E-19  -6.54442696560176E-03  -2.71498884940026E-03   0.00000000000000E+00   1.00977113075984E-12
      4.92914577011129E-25  -1.21552990341364E-08  -1.21542892630057E-08  -6.86210897326639E-19
      5.64251783880782E-09
      0.00000000000000E+00  -1.37095720782303E-11   0.00000000000000E+00  -8.55419902062948E-12   3.19518243710265E-24
      1.37181188568791E-08   1.37095646578585E-08  -1.52885624317087E-19  -5.40261822041577E-01  -5.40261822040028E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54858708581584E-09   0.00000000000000E+00  -1.54858708581584E-09
      8.14319570758501E-19  -6.16308655742323E-03  -2.33154008858542E-03   0.00000000000000E+00   3.53100885248811E-13
     -1.02866247908191E-24  -1.21613306729279E-08  -1.21609775720426E-08  -6.61433946441413E-19
      5.66251783880782E-09
      0.00000000000000E+00  -7.44465886383050E-12   0.00000000000000E+00  -1.54425417541713E-11   1.32297784551203E-24
      7.46007960698798E-09   7.44463706523381E-09  -1.73308501572618E-19  -5.30618181130463E-01  -5.30618181135168E-01
      0.00000000000000E+00   0.00000000000000E+00   4.70556143733331E-09   0.00000000000000E+00   4.70556143733331E-09
      9.08430799505167E-19  -5.56676887102049E-03  -1.73861758461383E-03   0.00000000000000E+00  -1.06046145191672E-12
     -2.51712294668733E-24  -1.21491380411152E-08  -1.21501985025671E-08  -7.35122297932549E-19
      5.68251783880782E-09
      0.00000000000000E+00   6.41627334131782E-13   0.00000000000000E+00  -1.99472905442365E-11  -1.56193699074130E-24
     -6.21687581656830E-10  -6.41634872201068E-10  -2.31306617301188E-19  -5.04404776182761E-01  -5.04404776195534E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27726726934857E-08   0.00000000000000E+00   1.27726726934857E-08
      1.16388425337488E-18  -4.81493475121831E-03  -9.92820460836030E-04   0.00000000000000E+00  -3.24468380707562E-12
     -5.42648492809523E-24  -1.21277931374776E-08  -1.21310378212847E-08  -9.32577636073693E-19
      5.70251783880782E-09
      0.00000000000000E+00   7.95669327376246E-12   0.00000000000000E+00  -1.80964937543709E-11  -7.51032860894108E-24
     -7.93852193100198E-09  -7.95661842475636E-09  -3.34053700486015E-19  -4.60450735009016E-01  -4.60450735029068E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00513879320864E-08   0.00000000000000E+00   2.00513879320864E-08
      1.56491201201661E-18  -4.06938472250293E-03  -2.58698767745147E-04   0.00000000000000E+00  -6.42842537040304E-12
     -1.41366845198211E-23  -1.20883410819596E-08  -1.20947695073300E-08  -1.23085831153059E-18
      5.72251783880782E-09
      0.00000000000000E+00   1.18830557893842E-11   0.00000000000000E+00  -9.82696860952000E-12  -2.10505450370331E-23
     -1.18731738391684E-08  -1.18830008077779E-08  -4.83974930751783E-19  -3.99985707062037E-01  -3.99985707085959E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39218140834802E-08   0.00000000000000E+00   2.39218140834802E-08
      2.04334829368621E-18  -3.50276347083000E-03   2.90289796041863E-04   0.00000000000000E+00  -1.16908342359667E-11
     -3.83773685340391E-23  -1.20271224414663E-08  -1.20388132757023E-08  -1.55937336293443E-18
      5.74251783880782E-09
      0.00000000000000E+00   1.12665020685101E-11   0.00000000000000E+00   1.26738374251394E-12  -3.64868336672385E-23
     -1.12677499864348E-08  -1.12664826026923E-08  -6.67528429816538E-19  -3.26512645382149E-01  -3.26512645405295E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31464276880008E-08   0.00000000000000E+00   2.31464276880008E-08
      2.50627684744623E-18  -3.84967324762671E-03  -1.06679185864007E-04   0.00000000000000E+00  -2.10439914938264E-11
     -6.77864785473223E-23  -1.18589010938146E-08  -1.18799450853085E-08  -1.83874841762969E-18
      5.76251783880782E-09
      0.00000000000000E+00   8.66692862658826E-12   0.00000000000000E+00   6.05041767692107E-12  -4.16897974291515E-23
     -8.67293651783920E-09  -8.66688610016232E-09  -8.42659652823630E-19  -2.50219690709508E-01  -2.50219690729104E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95960350838585E-08   0.00000000000000E+00   1.95960350838585E-08
      2.89819754912340E-18  -1.05662339201517E-02  -7.12281035049985E-03   0.00000000000000E+00  -3.47463317698782E-11
     -7.86945858682031E-23  -1.08944026519263E-08  -1.09291489836962E-08  -2.05553789629977E-18
      5.78251783880782E-09
      0.00000000000000E+00   6.95852466979106E-12   0.00000000000000E+00   3.77876763054472E-12  -4.37123678065331E-23
     -6.96231652472491E-09  -6.95853775709441E-09  -9.84390800783397E-19  -1.81358814286893E-01  -1.81358814303144E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62512361445248E-08   0.00000000000000E+00   1.62512361445248E-08
      3.22322227201390E-18  -2.77533068370209E-02  -2.48254766224111E-02   0.00000000000000E+00  -5.42117493551253E-11
     -8.66558830631635E-23  -9.23848663807511E-09  -9.29269838743032E-09  -2.23883147123050E-18
      5.79251783880782E-09
      0.00000000000000E+00   6.13357524019305E-12   0.00000000000000E+00   3.55872471583997E-12  -4.46270717261478E-23
     -6.13708769829049E-09  -6.13352897357469E-09  -1.04616584531272E-18  -1.49221983745207E-01  -1.49221983759760E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45534480211284E-08   0.00000000000000E+00   1.45534480211284E-08
      3.36875675222518E-18  -3.89198649150975E-02  -3.62670113494981E-02   0.00000000000000E+00  -7.44611247394746E-11
     -9.10247341503557E-23  -8.34545792281418E-09  -8.41991904755374E-09  -2.32259090691246E-18
      5.80601783880782E-09
      0.00000000000000E+00   5.31817766326463E-12   0.00000000000000E+00   2.44852976582725E-12  -4.57519325159107E-23
     -5.32064407575041E-09  -5.31819554598463E-09  -1.11751737991833E-18  -1.10307023412289E-01  -1.10307023425202E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29136646801579E-08   0.00000000000000E+00   1.29136646801579E-08
      3.54309122540731E-18  -5.67646852847103E-02  -5.43715886193202E-02   0.00000000000000E+00  -9.25455382706153E-11
     -9.69411998193969E-23  -7.50292359590248E-09  -7.59546913417320E-09  -2.42557384548898E-18
      5.82424283880782E-09
      0.00000000000000E+00   4.20400915620012E-12   0.00000000000000E+00   2.49400760835248E-12  -4.69657966823676E-23
     -4.20651822234403E-09  -4.20402421473573E-09  -1.19295023308788E-18  -6.69322795699844E-02  -6.69322795807749E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07904525242991E-08   0.00000000000000E+00   1.07904525242991E-08
      3.73974722266266E-18  -8.47327471650312E-02  -8.26575670187376E-02   0.00000000000000E+00  -1.13155830915649E-10
     -1.04763081784862E-22  -6.47327247864760E-09  -6.58642830956335E-09  -2.54679698957478E-18
      5.82924283880782E-09
      0.00000000000000E+00   3.61216166963482E-12   0.00000000000000E+00   5.29851905662539E-12  -4.72345753627639E-23
     -3.61749988508007E-09  -3.61220136602349E-09  -1.21067100156167E-18  -5.64170874360480E-02  -5.64170874457517E-02
      0.00000000000000E+00   0.00000000000000E+00   9.70367565454283E-09   0.00000000000000E+00   9.70367565454283E-09
      3.78826560093537E-18  -9.29708437129127E-02  -9.10515976844663E-02   0.00000000000000E+00  -1.27188888552547E-10
     -1.06928336834470E-22  -5.96428539996677E-09  -6.09147428851943E-09  -2.57759459937370E-18
      5.83599283880782E-09
      0.00000000000000E+00   2.87336260353747E-12   0.00000000000000E+00   4.97463817705156E-12  -4.75157227453313E-23
     -2.87834381312572E-09  -2.87336917494871E-09  -1.22959053298499E-18  -4.49920800988415E-02  -4.49920801072570E-02
      0.00000000000000E+00   0.00000000000000E+00   8.41548322518084E-09   0.00000000000000E+00   8.41548322518084E-09
      3.84507011270535E-18  -1.04918137463898E-01  -1.03171977971953E-01   0.00000000000000E+00  -1.28402458566576E-10
     -1.09712001924088E-22  -5.41371159166568E-09  -5.54211405023237E-09  -2.61547957972036E-18
      5.84510533880782E-09
      0.00000000000000E+00   2.00864440272861E-12   0.00000000000000E+00   4.37664085408208E-12  -4.77642292849511E-23
     -2.01299987755610E-09  -2.00862323670207E-09  -1.24724197445079E-18  -3.40884389150975E-02  -3.40884389219882E-02
      0.00000000000000E+00   0.00000000000000E+00   6.89071200257679E-09   0.00000000000000E+00   6.89071200257679E-09
      3.90786172582882E-18  -1.22192230937799E-01  -1.20654025819906E-01   0.00000000000000E+00  -1.26887265417298E-10
     -1.13200794278308E-22  -4.75520150045710E-09  -4.88208876587452E-09  -2.66061975137803E-18
      5.85740721380782E-09
      0.00000000000000E+00   1.20059440477679E-12   0.00000000000000E+00   3.06358443493143E-12  -4.79455654945110E-23
     -1.20361288511811E-09  -1.20054930068323E-09  -1.26113372759225E-18  -2.52082835611012E-02  -2.52082835664978E-02
      0.00000000000000E+00   0.00000000000000E+00   5.39653069399148E-09   0.00000000000000E+00   5.39653069399148E-09
      3.97424917185997E-18  -1.46513516969590E-01  -1.45191483685588E-01   0.00000000000000E+00  -1.25010643820267E-10
     -1.17513362187752E-22  -4.07097074948794E-09  -4.19598139330833E-09  -2.71311544426773E-18
      5.87401474505782E-09
      0.00000000000000E+00   6.37586165694651E-13   0.00000000000000E+00   1.58949804772329E-12  -4.80572788270672E-23
     -6.39134771868487E-10  -6.37545273820812E-10  -1.27055994269984E-18  -1.88256833697911E-02  -1.88256833740007E-02
      0.00000000000000E+00   0.00000000000000E+00   4.20966272555539E-09   0.00000000000000E+00   4.20966272555539E-09
      4.04416127712659E-18  -1.79003952609887E-01  -1.77878479748620E-01   0.00000000000000E+00  -1.24668907217575E-10
     -1.22843143368861E-22  -3.44744854451680E-09  -3.57211745173450E-09  -2.77360133442675E-18
      5.89401474505782E-09
      0.00000000000000E+00   3.46897572432829E-13   0.00000000000000E+00   6.82771759943586E-13  -4.81138053199144E-23
     -3.47585968713384E-10  -3.46903196953488E-10  -1.27613551882965E-18  -1.47306423388771E-02  -1.47306423422318E-02
      0.00000000000000E+00   0.00000000000000E+00   3.35474072884820E-09   0.00000000000000E+00   3.35474072884820E-09
      4.11125609170356E-18  -2.15102428618712E-01  -2.14154742352157E-01   0.00000000000000E+00  -1.23810154331306E-10
     -1.28653610586041E-22  -2.88402737756314E-09  -3.00783753189458E-09  -2.83512057287390E-18
      5.91401474505782E-09
      0.00000000000000E+00   2.23641935100328E-13   0.00000000000000E+00   2.90283330410635E-13  -4.81382427463301E-23
     -2.23938532999840E-10  -2.23648249669478E-10  -1.27927830404972E-18  -1.22685333255566E-02  -1.22685333282495E-02
      0.00000000000000E+00   0.00000000000000E+00   2.69283120357078E-09   0.00000000000000E+00   2.69283120357078E-09
      4.16511271577497E-18  -2.46084814854913E-01  -2.45306841464014E-01   0.00000000000000E+00  -1.16913516893940E-10
     -1.33695369987251E-22  -2.35226943700733E-09  -2.46918295390141E-09  -2.88583441172526E-18
      5.93401474505782E-09
      0.00000000000000E+00   1.70371987519962E-13   0.00000000000000E+00   1.26233064957271E-13  -4.81491984740719E-23
     -1.70478164604084E-10  -1.70351931539175E-10  -1.28138127482959E-18  -1.06168574366316E-02  -1.06168574387465E-02
      0.00000000000000E+00   0.00000000000000E+00   2.11487330514768E-09   0.00000000000000E+00   2.11487330514768E-09
      4.20741018187793E-18  -2.70813653407857E-01  -2.70200986143103E-01   0.00000000000000E+00  -1.01244011178273E-10
     -1.37781504554396E-22  -1.84327736243017E-09  -1.94452137360858E-09  -2.92602890704834E-18
      5.95401474505782E-09
      0.00000000000000E+00   1.44104392678609E-13   0.00000000000000E+00   6.34417468983416E-14  -4.81533699025269E-23
     -1.44166242791019E-10  -1.44102801044169E-10  -1.28297961104379E-18  -9.44124796014839E-03  -9.44124796176273E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61433926684492E-09   0.00000000000000E+00   1.61433926684492E-09
      4.23969696721483E-18  -2.89312568382899E-01  -2.88849336759364E-01   0.00000000000000E+00  -8.02023769603962E-11
     -1.40866875856180E-22  -1.39003408884009E-09  -1.47023646580063E-09  -2.95671735617103E-18
      5.97401474505782E-09
      0.00000000000000E+00   1.29868458411443E-13   0.00000000000000E+00   3.57342878461672E-14  -4.81539322627537E-23
     -1.29909810381909E-10  -1.29874076094111E-10  -1.28430888714740E-18  -8.57519029608082E-03  -8.57519029727696E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19613254057759E-09   0.00000000000000E+00   1.19613254057759E-09
      4.26361961802638E-18  -3.02219730759217E-01  -3.01883784076622E-01   0.00000000000000E+00  -5.76271569257712E-11
     -1.43015751131338E-22  -1.00863130755770E-09  -1.06625846448361E-09  -2.97931073087897E-18
      5.99401474505782E-09
      0.00000000000000E+00   1.21969811011596E-13   0.00000000000000E+00   2.10398617410853E-14  -4.81526884253725E-23
     -1.21987872206095E-10  -1.21966832344402E-10  -1.28549156512356E-18  -7.91994564851233E-03  -7.91994564936399E-03
      0.00000000000000E+00   0.00000000000000E+00   8.51664792413994E-10   0.00000000000000E+00   8.51664792413994E-10
      4.28065291387466E-18  -3.10315021411034E-01  -3.10085118649439E-01   0.00000000000000E+00  -3.59185231243293E-11
     -1.44336154483899E-22  -6.93779436945030E-10  -7.29697960069503E-10  -2.99516134875109E-18
      6.01401474505782E-09
      0.00000000000000E+00   1.11407666232730E-13   0.00000000000000E+00   2.90639834813363E-14  -4.81480696393581E-23
     -1.11393105621246E-10  -1.11364041637813E-10  -1.28647145203742E-18  -7.46126412679883E-03  -7.46126412742441E-03
      0.00000000000000E+00   0.00000000000000E+00   6.25575590057578E-10   0.00000000000000E+00   6.25575590057578E-10
      4.29316442567581E-18  -3.15383623321030E-01  -3.15221616509883E-01   0.00000000000000E+00  -2.12609871850825E-11
     -1.45115793871287E-22  -4.92950561234543E-10  -5.14211548419770E-10  -3.00669297363839E-18
      6.03401474505782E-09
      0.00000000000000E+00   9.60695951190730E-14   0.00000000000000E+00   4.30078083813609E-14  -4.81382825093581E-23
     -9.60691672392832E-11  -9.60261594309500E-11  -1.28715383159253E-18  -7.18636800820675E-03  -7.18636800877403E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67277522652785E-10   0.00000000000000E+00   5.67277522652785E-10
      4.30450997612886E-18  -3.20051722491450E-01  -3.19903251509277E-01   0.00000000000000E+00  -1.89740903936709E-11
     -1.45799031199423E-22  -4.52277272828004E-10  -4.71251363221820E-10  -3.01735614453634E-18
      6.05401474505782E-09
      0.00000000000000E+00   8.81709477192257E-14   0.00000000000000E+00   2.55699872164731E-14  -4.81267934492607E-23
     -8.82018344509491E-11  -8.81762644637808E-11  -1.28768897247993E-18  -6.97868070502710E-03  -6.97868070561109E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83991632596325E-10   0.00000000000000E+00   5.83991632596325E-10
      4.31618980878079E-18  -3.25205015046659E-01  -3.25048804227854E-01   0.00000000000000E+00  -2.14700244318118E-11
     -1.46555371325080E-22  -4.74345343700534E-10  -4.95815368132492E-10  -3.02850083630086E-18
      6.05403427630782E-09
      0.00000000000000E+00   8.83546371936407E-14   0.00000000000000E+00  -9.59357508065866E-14  -4.81267883954401E-23
     -8.82425372700551E-11  -8.83384730209098E-11  -1.28768949825595E-18  -6.97847347019052E-03  -6.97847347077451E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83983341507674E-10   0.00000000000000E+00   5.83983341507674E-10
      4.31620121470543E-18  -3.25209979636987E-01  -3.25053822549891E-01   0.00000000000000E+00  -2.13437205511188E-11
     -1.46556103872644E-22  -4.74301148019498E-10  -4.95644868570763E-10  -3.02851171644949E-18
      6.05406064349532E-09
      0.00000000000000E+00   8.89057056168859E-14   0.00000000000000E+00  -4.52187247755828E-13  -4.81268052240497E-23
     -8.84887612524059E-11  -8.89409485002099E-11  -1.28769022395606E-18  -6.97817431291878E-03  -6.97817431350267E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83885933451613E-10   0.00000000000000E+00   5.83885933451613E-10
      4.31621661013532E-18  -3.25216498188298E-01  -3.25060561684812E-01   0.00000000000000E+00  -2.09121974339973E-11
     -1.46557075172233E-22  -4.74032787465633E-10  -4.94944984899776E-10  -3.02852638617926E-18
      6.05409623919845E-09
      0.00000000000000E+00   9.02833766749988E-14   0.00000000000000E+00  -1.03986889888721E-12  -4.81268780923098E-23
     -8.92464770261957E-11  -9.02863459251310E-11  -1.28769125157191E-18  -6.97771992038697E-03  -6.97771992097051E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83546492884415E-10   0.00000000000000E+00   5.83546492884415E-10
      4.31623738188304E-18  -3.25224961377961E-01  -3.25069555908803E-01   0.00000000000000E+00  -2.00836430177464E-11
     -1.46558344906671E-22  -4.73176503946685E-10  -4.93260146964578E-10  -3.02854613031113E-18
      6.05414429339767E-09
      0.00000000000000E+00   9.25794951051870E-14   0.00000000000000E+00  -1.68352781614963E-12  -4.81270443289371E-23
     -9.08969896467788E-11  -9.25805174629765E-11  -1.28769274915183E-18  -6.97700891360750E-03  -6.97700891419021E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82711224740072E-10   0.00000000000000E+00   5.82711224740072E-10
      4.31626538360432E-18  -3.25235890894804E-01  -3.25081471757806E-01   0.00000000000000E+00  -1.89444403578948E-11
     -1.46559988930532E-22  -4.71186266910961E-10  -4.90130707269003E-10  -3.02857263445249E-18
      6.05420916656661E-09
      0.00000000000000E+00   9.57940609074504E-14   0.00000000000000E+00  -2.11220858354709E-12  -4.81273163748389E-23
     -9.36874403725513E-11  -9.57996489561465E-11  -1.28769497981526E-18  -6.97589862943255E-03  -6.97589863001360E-03
      0.00000000000000E+00   0.00000000000000E+00   5.81046806108236E-10   0.00000000000000E+00   5.81046806108236E-10
      4.31630307795194E-18  -3.25250028102460E-01  -3.25097148049675E-01   0.00000000000000E+00  -1.77513992343936E-11
     -1.46562118208699E-22  -4.67495757926332E-10  -4.85247157160872E-10  -3.02860809813668E-18
      6.05429674534469E-09
      0.00000000000000E+00   9.96515398701665E-14   0.00000000000000E+00  -2.13155578215549E-12  -4.81276553525540E-23
     -9.74847110550305E-11  -9.96162668372341E-11  -1.28769832563366E-18  -6.97420868280364E-03  -6.97420868338183E-03
      0.00000000000000E+00   0.00000000000000E+00   5.78196361626026E-10   0.00000000000000E+00   5.78196361626026E-10
      4.31635371568277E-18  -3.25268440281844E-01  -3.25117661193897E-01   0.00000000000000E+00  -1.67900174910731E-11
     -1.46564899880511E-22  -4.61790077281709E-10  -4.78580094772929E-10  -3.02865539004911E-18
      6.05441497669509E-09
      0.00000000000000E+00   1.03417174095675E-13   0.00000000000000E+00  -1.74294319371245E-12  -4.81279707218035E-23
     -1.01673736487143E-10  -1.03416679680904E-10  -1.28770329211454E-18  -6.97172954883055E-03  -6.97172954940440E-03
      0.00000000000000E+00   0.00000000000000E+00   5.73853259705207E-10   0.00000000000000E+00   5.73853259705207E-10
      4.31642156312860E-18  -3.25292637523929E-01  -3.25144424418643E-01   0.00000000000000E+00  -1.62120059157431E-11
     -1.46568569623139E-22  -4.54224574094614E-10  -4.70436580010504E-10  -3.02871827101406E-18
      6.05457458901813E-09
      0.00000000000000E+00   1.06448050423524E-13   0.00000000000000E+00  -1.11546759483668E-12  -4.81281529221143E-23
     -1.05292955905378E-10  -1.06408423500263E-10  -1.28771047491729E-18  -6.96824071502806E-03  -6.96824071559591E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67852952401122E-10   0.00000000000000E+00   5.67852952401122E-10
      4.31651219945748E-18  -3.25324724476221E-01  -3.25179344508629E-01   0.00000000000000E+00  -1.59915076068171E-11
     -1.46573438489328E-22  -4.45453021294916E-10  -4.61444528901879E-10  -3.02880172454020E-18
      6.05479006565424E-09
      0.00000000000000E+00   1.07825721481636E-13   0.00000000000000E+00  -4.66443173819060E-13  -4.81281204820318E-23
     -1.07340114824238E-10  -1.07806557998106E-10  -1.28772047393557E-18  -6.96355006266817E-03  -6.96355006322847E-03
      0.00000000000000E+00   0.00000000000000E+00   5.60295128541523E-10   0.00000000000000E+00   5.60295128541523E-10
      4.31663292996701E-18  -3.25367642132415E-01  -3.25225083794595E-01   0.00000000000000E+00  -1.60078966806649E-11
     -1.46579912793809E-22  -4.36480673860011E-10  -4.52488570540823E-10  -3.02891245603144E-18
      6.05508095911299E-09
      0.00000000000000E+00   1.06999118846769E-13   0.00000000000000E+00   4.02078036086074E-14  -4.81278534802063E-23
     -1.07115557837688E-10  -1.07075350034128E-10  -1.28773376168311E-18  -6.95755804370993E-03  -6.95755804426160E-03
      0.00000000000000E+00   0.00000000000000E+00   5.51672512024851E-10   0.00000000000000E+00   5.51672512024851E-10
      4.31679340789212E-18  -3.25425557450986E-01  -3.25285485277633E-01   0.00000000000000E+00  -1.61491871265187E-11
     -1.46588543127601E-22  -4.28447974869095E-10  -4.44597161995761E-10  -3.02905964620901E-18
      6.05547366528230E-09
      0.00000000000000E+00   1.04151931993335E-13   0.00000000000000E+00   3.32962820412100E-13  -4.81273927639417E-23
     -1.04485872079878E-10  -1.04152909259514E-10  -1.28775055576478E-18  -6.95032435599573E-03  -6.95032435653866E-03
      0.00000000000000E+00   0.00000000000000E+00   5.42932283142747E-10   0.00000000000000E+00   5.42932283142747E-10
      4.31700662074923E-18  -3.25504443897930E-01  -3.25366204550856E-01   0.00000000000000E+00  -1.63602642288810E-11
     -1.46600107989829E-22  -4.22419109654270E-10  -4.38779373883297E-10  -3.02925606498445E-18
      6.05600381861087E-09
      0.00000000000000E+00   9.95596951329590E-14   0.00000000000000E+00   4.24276546267386E-13  -4.81268026983797E-23
     -9.99642540991600E-11  -9.95399775529408E-11  -1.28777078831806E-18  -6.94208789870771E-03  -6.94208789924312E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35405457818785E-10   0.00000000000000E+00   5.35405457818785E-10
      4.31729046773483E-18  -3.25612901349553E-01  -3.25475579917389E-01   0.00000000000000E+00  -1.66425828630515E-11
     -1.46615739582466E-22  -4.19222897403093E-10  -4.35865480266291E-10  -3.02951967941677E-18
      6.05671952560443E-09
      0.00000000000000E+00   9.41408556377149E-14   0.00000000000000E+00   3.78147357136787E-13  -4.81261205349011E-23
     -9.45451890246944E-11  -9.41670416676058E-11  -1.28779426820897E-18  -6.93318554344748E-03  -6.93318554397809E-03
      0.00000000000000E+00   0.00000000000000E+00   5.30609070752008E-10   0.00000000000000E+00   5.30609070752008E-10
      4.31767022835761E-18  -3.25763316067149E-01  -3.25625812830451E-01   0.00000000000000E+00  -1.70370399246380E-11
     -1.46637114033556E-22  -4.19404989159632E-10  -4.36442029084417E-10  -3.02987596014865E-18
      6.05768573004575E-09
      0.00000000000000E+00   8.90893950913009E-14   0.00000000000000E+00   2.71338129989372E-13  -4.81253270734888E-23
     -8.93418504982908E-11  -8.90705123683496E-11  -1.28782106306292E-18  -6.92384781115814E-03  -6.92384781168812E-03
      0.00000000000000E+00   0.00000000000000E+00   5.29976782961283E-10   0.00000000000000E+00   5.29976782961283E-10
      4.31818229427911E-18  -3.25973567912118E-01  -3.25834657971776E-01   0.00000000000000E+00  -1.76046441154651E-11
     -1.46666744700408E-22  -4.23301626476597E-10  -4.40906270592208E-10  -3.03036123121619E-18
      6.05899010604152E-09
      0.00000000000000E+00   8.50482266541698E-14   0.00000000000000E+00   1.63638398307341E-13  -4.81243514433955E-23
     -8.51867166041847E-11  -8.50230782059255E-11  -1.28785199652899E-18  -6.91391886312191E-03  -6.91391886365650E-03
      0.00000000000000E+00   0.00000000000000E+00   5.34582962554128E-10   0.00000000000000E+00   5.34582962554128E-10
      4.31887959146321E-18  -3.26269652995971E-01  -3.26128016381808E-01   0.00000000000000E+00  -1.84091535354243E-11
     -1.46708432821285E-22  -4.31150730812357E-10  -4.49559884347928E-10  -3.03102759493422E-18
      6.06075101363581E-09
      0.00000000000000E+00   8.22928845379440E-14   0.00000000000000E+00   8.57011877412822E-14  -4.81230896691197E-23
     -8.23781274812866E-11  -8.22924262935934E-11  -1.28788902263711E-18  -6.90262276164626E-03  -6.90262276219122E-03
      0.00000000000000E+00   0.00000000000000E+00   5.44964645431638E-10   0.00000000000000E+00   5.44964645431638E-10
      4.31983922384597E-18  -3.26689829893012E-01  -3.26544061753239E-01   0.00000000000000E+00  -1.95077929285254E-11
     -1.46767955321926E-22  -4.43164426210045E-10  -4.62672219138718E-10  -3.03195020120886E-18
      6.06312823888811E-09
      0.00000000000000E+00   8.06396792682085E-14   0.00000000000000E+00   4.28759823323446E-14  -4.81214086414191E-23
     -8.06638605467746E-11  -8.06209845644904E-11  -1.28793517363750E-18  -6.88853147262887E-03  -6.88853147319010E-03
      0.00000000000000E+00   0.00000000000000E+00   5.61229686091644E-10   0.00000000000000E+00   5.61229686091644E-10
      4.32117339322809E-18  -3.27291417116558E-01  -3.27139997448591E-01   0.00000000000000E+00  -2.09603894218566E-11
     -1.46854149155117E-22  -4.59648312105135E-10  -4.80608701527138E-10  -3.03323821959059E-18
      6.06633749297871E-09
      0.00000000000000E+00   7.93538529473031E-14   0.00000000000000E+00   2.70249267402246E-14  -4.81191208547034E-23
     -7.93911516746466E-11  -7.93641267479545E-11  -1.28799370553818E-18  -6.86989938631677E-03  -6.86989938690050E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83727366417909E-10   0.00000000000000E+00   5.83727366417909E-10
      4.32304672266656E-18  -3.28163091006417E-01  -3.28004186633065E-01   0.00000000000000E+00  -2.28776329532954E-11
     -1.46980845594325E-22  -4.81485606715954E-10  -5.04363239669396E-10  -3.03505301712838E-18
      6.07066998600102E-09
      0.00000000000000E+00   7.76088029403601E-14   0.00000000000000E+00   2.79300496403071E-14  -4.81159144785363E-23
     -7.76118547210896E-11  -7.75839246714974E-11  -1.28806550830072E-18  -6.84570218647066E-03  -6.84570218708555E-03
      0.00000000000000E+00   0.00000000000000E+00   6.14886127167427E-10   0.00000000000000E+00   6.14886127167427E-10
      4.32571071252203E-18  -3.29452144420527E-01  -3.29282861461203E-01   0.00000000000000E+00  -2.55687868264842E-11
     -1.47171227077710E-22  -5.11733415669582E-10  -5.37302202496214E-10  -3.03764520422130E-18
      6.07651885158114E-09
      0.00000000000000E+00   7.39350134520590E-14   0.00000000000000E+00   3.88824410681625E-14  -4.81111879715861E-23
     -7.39702425103565E-11  -7.39313600693365E-11  -1.28814204828875E-18  -6.81819329050352E-03  -6.81819329116732E-03
      0.00000000000000E+00   0.00000000000000E+00   6.63798514848199E-10   0.00000000000000E+00   6.63798514848199E-10
      4.32959318080766E-18  -3.31439359981273E-01  -3.31253514557877E-01   0.00000000000000E+00  -2.99323132364391E-11
     -1.47470137738040E-22  -5.59934841542595E-10  -5.89867154779182E-10  -3.04145113251891E-18
      6.08441482011430E-09
      0.00000000000000E+00   6.68629686870795E-14   0.00000000000000E+00   5.33779946900069E-14  -4.81037920439239E-23
     -6.69024840196453E-11  -6.68491060250034E-11  -1.28819143818999E-18  -6.79630610521254E-03  -6.79630610596593E-03
      0.00000000000000E+00   0.00000000000000E+00   7.53392442679345E-10   0.00000000000000E+00   7.53392442679345E-10
      4.33554194382818E-18  -3.34739716289483E-01  -3.34523409574814E-01   0.00000000000000E+00  -3.80417952662535E-11
     -1.47978195391638E-22  -6.48501541387734E-10  -6.86543336654135E-10  -3.04735050563818E-18
      6.08974459887418E-09
      0.00000000000000E+00   5.95153897104773E-14   0.00000000000000E+00   7.82728574073243E-14  -4.80979897249013E-23
     -5.95661226305906E-11  -5.94878497732314E-11  -1.28818653748747E-18  -6.79432549999443E-03  -6.79432550082733E-03
      0.00000000000000E+00   0.00000000000000E+00   8.32892809496819E-10   0.00000000000000E+00   8.32892809496819E-10
      4.33998107823350E-18  -3.37348931466694E-01  -3.37105255773436E-01   0.00000000000000E+00  -4.55777994502501E-11
     -1.48385623007847E-22  -7.27827160273052E-10  -7.73404959723450E-10  -3.05179454074603E-18
      6.09693980020003E-09
      0.00000000000000E+00   5.30862581059505E-14   0.00000000000000E+00   5.51158730263871E-14  -4.80896750715389E-23
     -5.31800687374235E-11  -5.31249528644452E-11  -1.28813617622671E-18  -6.79734382230536E-03  -6.79734382326153E-03
      0.00000000000000E+00   0.00000000000000E+00   9.56164584134351E-10   0.00000000000000E+00   9.56164584134351E-10
      4.34686087491698E-18  -3.41610501778874E-01  -3.41325980039268E-01   0.00000000000000E+00  -5.66856923566974E-11
     -1.49064496787143E-22  -8.46353938913296E-10  -9.03039631270142E-10  -3.05872469869027E-18
      6.10665332198992E-09
      0.00000000000000E+00   5.17085870478376E-14   0.00000000000000E+00   1.88565460889604E-14  -4.80788343079195E-23
     -5.17013204694889E-11  -5.16824639234480E-11  -1.28805826471571E-18  -6.77791934320216E-03  -6.77791934429379E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09162744069351E-09   0.00000000000000E+00   1.09162744069351E-09
      4.35746442184860E-18  -3.48377149198955E-01  -3.48049490627543E-01   0.00000000000000E+00  -6.88058285919266E-11
     -1.50166255785945E-22  -9.71139148177893E-10  -1.03994497676997E-09  -3.06940615713289E-18
      6.11976657640626E-09
      0.00000000000000E+00   5.54742212733462E-14   0.00000000000000E+00  -3.69144794728972E-15  -4.80657655233104E-23
     -5.54305021043488E-11  -5.54341935523441E-11  -1.28801010417737E-18  -6.68865586926498E-03  -6.68865587045612E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19113411129238E-09   0.00000000000000E+00   1.19113411129238E-09
      4.37308406649397E-18  -3.58436423132713E-01  -3.58078593656642E-01   0.00000000000000E+00  -7.84878688397104E-11
     -1.51838969625352E-22  -1.05721204890002E-09  -1.13569991773988E-09  -3.08507396231659E-18
      6.13746946986834E-09
      0.00000000000000E+00   6.39239370964386E-14   0.00000000000000E+00  -1.51630832980310E-14  -4.80515590746964E-23
     -6.38885690471818E-11  -6.39037321305279E-11  -1.28810913572756E-18  -6.45533979124706E-03  -6.45533979247397E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22691168598636E-09   0.00000000000000E+00   1.22691168598636E-09
      4.39480395335835E-18  -3.72323968581634E-01  -3.71957534791364E-01   0.00000000000000E+00  -8.37130001005481E-11
     -1.54199458231538E-22  -1.07929495375514E-09  -1.16300795385585E-09  -3.10669481763079E-18
      6.15746946986834E-09
      0.00000000000000E+00   7.84354055752278E-14   0.00000000000000E+00  -3.03574493065639E-14  -4.80415830912846E-23
     -7.83945209653570E-11  -7.84248784147117E-11  -1.28852834934260E-18  -6.01266821087976E-03  -6.01266821209875E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21898903808928E-09   0.00000000000000E+00   1.21898903808928E-09
      4.41918373412014E-18  -3.87566261661904E-01  -3.87206899404319E-01   0.00000000000000E+00  -8.55542740358606E-11
     -1.56860106045162E-22  -1.05500988563862E-09  -1.14056415967463E-09  -3.13065538477754E-18
      6.17746946986834E-09
      0.00000000000000E+00   9.63451293306956E-14   0.00000000000000E+00  -4.22205277739097E-14  -4.80386650556771E-23
     -9.62867000771678E-11  -9.63289206049897E-11  -1.28932104692645E-18  -5.35932042186553E-03  -5.35932042306513E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19959101307968E-09   0.00000000000000E+00   1.19959101307968E-09
      4.44317555438173E-18  -4.02102839222189E-01  -4.01755229996613E-01   0.00000000000000E+00  -8.61263811045425E-11
     -1.59475098422317E-22  -1.01713571136996E-09  -1.10326209247467E-09  -3.15385450745529E-18
      6.19746946986834E-09
      0.00000000000000E+00   1.06448050423524E-13   0.00000000000000E+00  -2.52488804332072E-14  -4.80392772614818E-23
     -1.06445710908382E-10  -1.06470959788863E-10  -1.29033079355927E-18  -4.59090569806424E-03  -4.59090569923282E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16857338606284E-09   0.00000000000000E+00   1.16857338606284E-09
      4.46654702210299E-18  -4.15953669468584E-01  -4.15619028822451E-01   0.00000000000000E+00  -8.59629644948954E-11
     -1.62027707975539E-22  -9.76139461778869E-10  -1.06210242627393E-09  -3.17621622854372E-18
      6.21746946986834E-09
      0.00000000000000E+00   1.02315037249185E-13   0.00000000000000E+00   1.04113384048441E-14  -4.80379453990683E-23
     -1.02327353756929E-10  -1.02316942418572E-10  -1.29127117993995E-18  -3.87872970991092E-03  -3.87872971103069E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11976914061849E-09   0.00000000000000E+00   1.11976914061849E-09
      4.48894240491536E-18  -4.29213445240255E-01  -4.28892873101309E-01   0.00000000000000E+00  -8.49899535786168E-11
     -1.64499955818459E-22  -9.32462244621090E-10  -1.01745219819987E-09  -3.19767122497540E-18
      6.23746946986834E-09
      0.00000000000000E+00   8.18336608519063E-14   0.00000000000000E+00   5.39479773677681E-14  -4.80288403210712E-23
     -8.19056832483428E-11  -8.18517352710231E-11  -1.29181636061909E-18  -3.41690806082894E-03  -3.41690806187890E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04996743684976E-09   0.00000000000000E+00   1.04996743684976E-09
      4.50994175365235E-18  -4.41978130791696E-01  -4.41673103868034E-01   0.00000000000000E+00  -8.29888418716325E-11
     -1.66868289726919E-22  -8.85126859706928E-10  -9.68115701578727E-10  -3.21812539303326E-18
      6.25746946986834E-09
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   3.85443848910318E-13  -4.79615225908638E-23
      6.28526072257761E-11   6.32380510746385E-11  -1.28948081963611E-18  -4.70168503459966E-03  -4.70168503538407E-03
      0.00000000000000E+00   0.00000000000000E+00   7.84408471969364E-10   0.00000000000000E+00   7.84408471969364E-10
      4.52562992309174E-18  -4.54480948385358E-01  -4.54213880419633E-01   0.00000000000000E+00  -7.17244096763388E-11
     -1.68878436227137E-22  -7.75922113367579E-10  -8.47646523044087E-10  -3.23614910345564E-18
      6.27746946986834E-09
      0.00000000000000E+00  -7.81415024161638E-13   0.00000000000000E+00   1.91485551159285E-12  -4.76081575333420E-23
      7.79480179980025E-10   7.81395035491571E-10  -1.27285313642540E-18  -1.45338858257185E-02  -1.45338858253241E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94366504361390E-10   0.00000000000000E+00  -3.94366504361390E-10
      4.51774259300451E-18  -4.67522993894532E-01  -4.67401065258775E-01   0.00000000000000E+00  -1.68091684892668E-11
     -1.69324692941114E-22  -3.70219362640745E-10  -3.87028531130181E-10  -3.24488945657912E-18
      6.29746946986834E-09
      0.00000000000000E+00  -1.64310234864265E-12   0.00000000000000E+00   2.39213945263070E-12  -4.69538456327255E-23
      1.64067508893086E-09   1.64306722838344E-09  -1.23920779003645E-18  -3.41448606355466E-02  -3.41448606337631E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.78352334153505E-09   0.00000000000000E+00  -1.78352334153505E-09
      4.48207212617381E-18  -4.81140009932687E-01  -4.81184291020466E-01   0.00000000000000E+00   4.72542539899477E-11
     -1.67960054025817E-22   9.32018591618179E-11   1.40456113151598E-10  -3.24286433613736E-18
      6.30746946986834E-09
      0.00000000000000E+00  -2.08763087672708E-12   0.00000000000000E+00   2.49970104857651E-12  -4.65537633951713E-23
      2.08508734135990E-09   2.08758704240843E-09  -1.21805062259714E-18  -4.62425618451823E-02  -4.62425618427015E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.48081307042160E-09   0.00000000000000E+00  -2.48081307042160E-09
      4.45726399546960E-18  -4.88010202741484E-01  -4.88134131334672E-01   0.00000000000000E+00   7.67809739917794E-11
     -1.66854404155920E-22   3.16445054021681E-10   3.93226028013294E-10  -3.23921337287245E-18
      6.32096946986834E-09
      0.00000000000000E+00  -2.49330908097273E-12   0.00000000000000E+00   1.81588841046548E-12  -4.59457723053822E-23
      2.49152107769635E-09   2.49333696610677E-09  -1.18439151621550E-18  -6.50839976116949E-02  -6.50839976086107E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.08426383833748E-09   0.00000000000000E+00  -3.08426383833748E-09
      4.41562643365204E-18  -4.97296140624146E-01  -4.97482365875429E-01   0.00000000000000E+00   9.94174191257861E-11
     -1.64910706965157E-22   4.91509453105039E-10   5.90926872230660E-10  -3.23123491743653E-18
      6.33919446986834E-09
      0.00000000000000E+00  -3.07137985695690E-12   0.00000000000000E+00   1.90632660646110E-12  -4.49968861780754E-23
      3.06946204775567E-09   3.07136837436209E-09  -1.13012372830899E-18  -9.44880465370129E-02  -9.44880465331670E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84588307075385E-09   0.00000000000000E+00  -3.84588307075385E-09
      4.34553521468755E-18  -5.09700564023820E-01  -5.09944645046881E-01   0.00000000000000E+00   1.23699264198591E-10
     -1.61614117861699E-22   6.50815432193319E-10   7.74514696391748E-10  -3.21541148637856E-18
      6.34419446986834E-09
      0.00000000000000E+00  -3.41102169515034E-12   0.00000000000000E+00   3.66865983290417E-12  -4.47036952340597E-23
      3.40735785755603E-09   3.41102651738889E-09  -1.11377624123855E-18  -1.03138841624875E-01  -1.03138841620591E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28331915247915E-09   0.00000000000000E+00  -4.28331915247915E-09
      4.32411861892515E-18  -5.13092744090839E-01  -5.13367636886685E-01   0.00000000000000E+00   1.34163360881273E-10
     -1.60625543096953E-22   7.38129274208838E-10   8.72292635089950E-10  -3.21034237768661E-18
      6.35094446986834E-09
      0.00000000000000E+00  -3.78345210452686E-12   0.00000000000000E+00   3.06764839183305E-12  -4.42743871530992E-23
      3.78041847300298E-09   3.78348612139477E-09  -1.08982652596900E-18  -1.15625164385560E-01  -1.15625164380841E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.71971131168133E-09   0.00000000000000E+00  -4.71971131168133E-09
      4.29226056757131E-18  -5.17652739469107E-01  -5.17947785142952E-01   0.00000000000000E+00   1.45949251883598E-10
     -1.59163940124275E-22   7.90275938403068E-10   9.36225190286508E-10  -3.20243404160231E-18
      6.36005696986834E-09
      0.00000000000000E+00  -4.26389192485943E-12   0.00000000000000E+00   2.93700766002484E-12  -4.35717256750436E-23
      4.26096832780096E-09   4.26390533546094E-09  -1.05502673696487E-18  -1.33395504652635E-01  -1.33395504647482E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.15286444992080E-09   0.00000000000000E+00  -5.15286444992080E-09
      4.24530509027140E-18  -5.23641831236906E-01  -5.23922002429807E-01   0.00000000000000E+00   1.54948774881210E-10
     -1.57047097105245E-22   7.34010339578688E-10   8.88959114459741E-10  -3.19027835330653E-18
      6.37235884486834E-09
      0.00000000000000E+00  -4.99369020671044E-12   0.00000000000000E+00   3.23526387927163E-12  -4.19928365499036E-23
      4.99044552044049E-09   4.99368078431972E-09  -1.00570213284469E-18  -1.57865279183007E-01  -1.57865279177510E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49701373661655E-09   0.00000000000000E+00  -5.49701373661655E-09
      4.17768151441026E-18  -5.31044448986161E-01  -5.31203160557727E-01   0.00000000000000E+00   1.57738486808961E-10
     -1.54086005013067E-22   3.45594465487964E-10   5.03332952296771E-10  -3.17197938156557E-18
      6.38896637611834E-09
      0.00000000000000E+00  -6.60887175524200E-12   0.00000000000000E+00   5.05404293736922E-12  -3.62324054434271E-23
      6.60378145696621E-09   6.60883549990354E-09  -9.38698808840108E-19  -1.89863223824709E-01  -1.89863223818990E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71883414737894E-09   0.00000000000000E+00  -5.71883414737894E-09
      4.08270579759410E-18  -5.38476639008012E-01  -5.38196459692563E-01   0.00000000000000E+00   1.55430172913998E-10
     -1.50012969679557E-22  -1.04543152543849E-09  -8.90001352524646E-10  -3.14400698875399E-18
      6.40896637611834E-09
      0.00000000000000E+00  -1.05988826737486E-11   0.00000000000000E+00   1.00288701144269E-11  -1.51823702729402E-23
      1.05888724905209E-08   1.05989013606353E-08  -8.62612054011876E-19  -2.24674677931746E-01  -2.24674677925841E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90484836894041E-09   0.00000000000000E+00  -5.90484836894041E-09
      3.96460883021529E-18  -5.39863172432710E-01  -5.38384700486964E-01   0.00000000000000E+00   1.56380193780346E-10
     -1.44735236627210E-22  -4.85043318547511E-09  -4.69405299169491E-09  -3.10199677620342E-18
      6.42896637611834E-09
      0.00000000000000E+00  -1.75417018934772E-11   0.00000000000000E+00   1.72547051622307E-11   2.87856520307982E-23
      1.75244213435169E-08   1.75416760486792E-08  -7.96530103039310E-19  -2.53909543564587E-01  -2.53909543558440E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.14672315840347E-09   0.00000000000000E+00  -6.14672315840347E-09
      3.84167436704722E-18  -5.28287974106345E-01  -5.24698600506284E-01   0.00000000000000E+00   1.64420362999708E-10
     -1.38516600494410E-22  -1.15593732532752E-08  -1.13949528902756E-08  -3.04514426400792E-18
      6.44896637611834E-09
      0.00000000000000E+00  -2.62403169544020E-11   0.00000000000000E+00   2.15676160521329E-11   8.39688109585264E-23
      2.62187698267770E-08   2.62403374428292E-08  -7.44233073968302E-19  -2.76789301425333E-01  -2.76789301418902E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.43177713837354E-09   0.00000000000000E+00  -6.43177713837354E-09
      3.71303882427975E-18  -4.99812100314075E-01  -4.93572138009873E-01   0.00000000000000E+00   1.74216224060950E-10
     -1.30832426050046E-22  -1.99827765285165E-08  -1.98085603044557E-08  -2.96880575031145E-18
      6.46896637611834E-09
      0.00000000000000E+00  -3.39620713903876E-11   0.00000000000000E+00   1.91583028340379E-11   1.33428504780024E-22
      3.39428678870274E-08   3.39620261898615E-08  -7.06522718132747E-19  -2.93595406157657E-01  -2.93595406150939E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71790544642465E-09   0.00000000000000E+00  -6.71790544642465E-09
      3.57868071535126E-18  -4.53652944771925E-01  -4.45070324408099E-01   0.00000000000000E+00   1.75765392648841E-10
     -1.21693613536947E-22  -2.74198861360856E-08  -2.72441207434368E-08  -2.87215799721851E-18
      6.48896637611834E-09
      0.00000000000000E+00  -3.81585492781367E-11   0.00000000000000E+00   1.04413401616017E-11   1.61983315301668E-22
      3.81480925241875E-08   3.81585338643493E-08  -6.82477667149248E-19  -3.05017034759186E-01  -3.05017034752198E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.98825618647303E-09   0.00000000000000E+00  -6.98825618647303E-09
      3.43891559162180E-18  -3.91254007185641E-01  -3.81434210305589E-01   0.00000000000000E+00   1.66262328230753E-10
     -1.11800435801722E-22  -3.13365400061071E-08  -3.11702776778764E-08  -2.75643792447256E-18
      6.50896637611834E-09
      0.00000000000000E+00  -3.78351639584290E-11   0.00000000000000E+00  -7.57035006066924E-13   1.63726642088421E-22
      3.78359171141889E-08   3.78351600791830E-08  -6.70129561019374E-19  -3.11967407994994E-01  -3.11967407987763E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23041990667978E-09   0.00000000000000E+00  -7.23041990667978E-09
      3.29430719348820E-18  -3.16678473999083E-01  -3.07036582744971E-01   0.00000000000000E+00   1.45499503986928E-10
     -1.01978285678796E-22  -3.07502396764900E-08  -3.06047401725032E-08  -2.62417763246883E-18
      6.52896637611834E-09
      0.00000000000000E+00  -3.50649429947756E-11   0.00000000000000E+00  -6.83402866071466E-12   1.48298201152893E-22
      3.50717441243739E-08   3.50649100957133E-08  -6.63753426612729E-19  -3.16704383763233E-01  -3.16704383755887E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34590106570531E-09   0.00000000000000E+00  -7.34590106570531E-09
      3.14738917217410E-18  -2.40975864133612E-01  -2.32242923787161E-01   0.00000000000000E+00   1.09181715203815E-10
     -9.17640532338284E-23  -2.78281907452117E-08  -2.77190090300080E-08  -2.48363574556137E-18
      6.54896637611834E-09
      0.00000000000000E+00  -3.24639918817957E-11   0.00000000000000E+00  -6.42815534040563E-12   1.29704899056723E-22
      3.24703775530340E-08   3.24639493976937E-08  -6.57424108054770E-19  -3.21486360588648E-01  -3.21486360581338E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30936754936411E-09   0.00000000000000E+00  -7.30936754936411E-09
      3.00120182118682E-18  -1.73238023650159E-01  -1.65312885520737E-01   0.00000000000000E+00   7.19343286700445E-11
     -8.33127168065182E-23  -2.52265161769995E-08  -2.51545818483295E-08  -2.34377771313205E-18
      6.55896637611834E-09
      0.00000000000000E+00  -3.11179154132821E-11   0.00000000000000E+00  -6.64989705890974E-12   1.19770710254626E-22
      3.11245184225395E-08   3.11178685254807E-08  -6.54413174122401E-19  -3.23831054075099E-01  -3.23831054067804E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29465881148307E-09   0.00000000000000E+00  -7.29465881148307E-09
      2.92825523307198E-18  -1.41658436871197E-01  -1.34152709925611E-01   0.00000000000000E+00   5.47603615201224E-11
     -8.05391958418714E-23  -2.38779700755177E-08  -2.38232097139976E-08  -2.27384205894958E-18
      6.57246637611834E-09
      0.00000000000000E+00  -2.97948919738077E-11   0.00000000000000E+00  -4.84266450238096E-12   1.08728670961919E-22
      2.97997580076965E-08   2.97949153431943E-08  -6.48978069186712E-19  -3.27532717380630E-01  -3.27532717373419E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21126676021060E-09   0.00000000000000E+00  -7.21126676021060E-09
      2.83090313180914E-18  -1.03539173808923E-01  -9.64239369777834E-02   0.00000000000000E+00   4.17534034652392E-11
     -7.59382993458719E-23  -2.26254019864489E-08  -2.25836485829838E-08  -2.18192506262243E-18
      6.59069137611834E-09
      0.00000000000000E+00  -2.78534779187150E-11   0.00000000000000E+00  -5.24923768858993E-12   9.92488774508974E-23
      2.78587369218731E-08   2.78534876841846E-08  -6.37465140159666E-19  -3.34019601760401E-01  -3.34019601753356E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.04514814744893E-09   0.00000000000000E+00  -7.04514814744893E-09
      2.70250530682188E-18  -6.19490432685762E-02  -5.53930966193587E-02   0.00000000000000E+00   3.05773001295649E-11
     -5.25989851151250E-23  -2.08389168368652E-08  -2.08083395367357E-08  -2.06504016666222E-18
      6.59569137611834E-09
      0.00000000000000E+00  -2.67491367985317E-11   0.00000000000000E+00  -1.08426674957477E-11   9.70703182618046E-23
      2.67599541782797E-08   2.67491115107841E-08  -6.33554467983709E-19  -3.36030684019663E-01  -3.36030684012690E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97315048477328E-09   0.00000000000000E+00  -6.97315048477328E-09
      2.66763955439802E-18  -5.20558970377588E-02  -4.58252060120541E-02   0.00000000000000E+00   2.99826362070170E-11
     -3.82635630241745E-23  -1.98059436622179E-08  -1.97759610260109E-08  -2.03408508641431E-18
      6.60244137611834E-09
      0.00000000000000E+00  -2.53740373930606E-11   0.00000000000000E+00  -1.00459366774020E-11   9.67740544340927E-23
      2.53840998234468E-08   2.53740538867695E-08  -6.26134549266970E-19  -3.39492708229506E-01  -3.39492708222700E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80568461158824E-09   0.00000000000000E+00  -6.80568461158824E-09
      2.62170118326980E-18  -4.15627143600236E-02  -3.57124817682873E-02   0.00000000000000E+00   2.48314668760716E-11
     -1.32723432740410E-23  -1.85932007420572E-08  -1.85683692751812E-08  -1.99556663400283E-18
      6.61155387611834E-09
      0.00000000000000E+00  -2.37775003261822E-11   0.00000000000000E+00  -8.62829918058858E-12   1.00823719531887E-22
      2.37861254224729E-08   2.37774971232924E-08  -6.12771619059900E-19  -3.45315879313041E-01  -3.45315879306456E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58452039674574E-09   0.00000000000000E+00  -6.58452039674574E-09
      2.56169974115445E-18  -3.17753662318179E-02  -2.63584609823143E-02   0.00000000000000E+00   1.95754013025735E-11
      2.46249631558430E-23  -1.72125521278495E-08  -1.71929767265469E-08  -1.94892812209455E-18
      6.62385575111834E-09
      0.00000000000000E+00  -2.22555411859163E-11   0.00000000000000E+00  -6.07941401764908E-12   1.11129071521719E-22
      2.22616283661787E-08   2.22555489521612E-08  -5.91045634628532E-19  -3.54418676482625E-01  -3.54418676476267E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35826477403810E-09   0.00000000000000E+00  -6.35826477403810E-09
      2.48348116268733E-18  -2.38769964738715E-02  -1.88683092207652E-02   0.00000000000000E+00   1.40303580474846E-11
      7.19424980053387E-23  -1.59113145361708E-08  -1.58972841781232E-08  -1.89243552805880E-18
      6.64046328236834E-09
      0.00000000000000E+00  -2.10464052205792E-11   0.00000000000000E+00  -3.56034509028898E-12   1.26519945254844E-22
      2.10499461877920E-08   2.10463858427019E-08  -5.59453027671196E-19  -3.67414328013608E-01  -3.67414328007441E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16764748666314E-09   0.00000000000000E+00  -6.16764748666314E-09
      2.38105176431359E-18  -1.81284189384703E-02  -1.34406320414142E-02   0.00000000000000E+00   9.47813647031686E-12
      1.24382785400978E-22  -1.48882164925091E-08  -1.48787383560387E-08  -1.82159873664239E-18
      6.66046328236834E-09
      0.00000000000000E+00  -2.01369586327502E-11   0.00000000000000E+00  -2.20909977764475E-12   1.39320772410610E-22
      2.01391922162404E-08   2.01369831164629E-08  -5.21768218324027E-19  -3.82846115319652E-01  -3.82846115313630E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.02145038169279E-09   0.00000000000000E+00  -6.02145038169279E-09
      2.26062275667973E-18  -1.43455172802928E-02  -9.89818394922035E-03   0.00000000000000E+00   6.78710597512927E-12
      1.68018975641129E-22  -1.41223198407454E-08  -1.41155327347701E-08  -1.73885453835571E-18
      6.68046328236834E-09
      0.00000000000000E+00  -1.94021088903528E-11   0.00000000000000E+00  -1.78020603681623E-12   1.42176367965845E-22
      1.94039151024374E-08   1.94021348964008E-08  -4.85824144244024E-19  -3.97614733923472E-01  -3.97614733917564E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90816255077808E-09   0.00000000000000E+00  -5.90816255077808E-09
      2.14245950566417E-18  -1.20214899477944E-02  -7.76998479858917E-03   0.00000000000000E+00   5.47869250407624E-12
      1.89267883367145E-22  -1.34994510381270E-08  -1.34939723456227E-08  -1.65663536142015E-18
      6.70046328236834E-09
      0.00000000000000E+00  -1.87490009640701E-11   0.00000000000000E+00  -1.58174971176384E-12   1.34868036744057E-22
      1.87506088734513E-08   1.87490271237397E-08  -4.51835290470855E-19  -4.11676761085947E-01  -4.11676761080140E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.80756044672137E-09   0.00000000000000E+00  -5.80756044672137E-09
      2.02630829672975E-18  -1.04443451850397E-02  -6.36691268829941E-03   0.00000000000000E+00   4.68726702720728E-12
      1.89333640586093E-22  -1.29461539440457E-08  -1.29414666770183E-08  -1.57447300625889E-18
      6.72046328236834E-09
      0.00000000000000E+00  -1.81798391275951E-11   0.00000000000000E+00  -1.37771305846686E-12   1.19505344002984E-22
      1.81812489337269E-08   1.81798712206685E-08  -4.19585587505536E-19  -4.25114674914917E-01  -4.25114674909200E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71681996408011E-09   0.00000000000000E+00  -5.71681996408011E-09
      1.91197189744814E-18  -9.31592289409205E-03  -5.38922047711296E-03   0.00000000000000E+00   4.06907274742053E-12
      1.72571187882979E-22  -1.24671203293360E-08  -1.24630512565884E-08  -1.49238630994261E-18
      6.74046328236834E-09
      0.00000000000000E+00  -1.76976542572555E-11   0.00000000000000E+00  -1.16560529417797E-12   9.92349181854737E-23
      1.76988622118940E-08   1.76976966066000E-08  -3.88781034806860E-19  -4.38025741859358E-01  -4.38025741853723E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63469536579198E-09   0.00000000000000E+00  -5.63469536579198E-09
      1.79927799013230E-18  -8.48108742737616E-03  -4.68042527227716E-03   0.00000000000000E+00   3.55262609020725E-12
      1.44993305035994E-22  -1.20665538668984E-08  -1.20630012408080E-08  -1.41049695532544E-18
      6.76046328236834E-09
      0.00000000000000E+00  -1.73214582136535E-11   0.00000000000000E+00  -9.06364991287187E-13   7.73965535913029E-23
      1.73223236857007E-08   1.73214173207095E-08  -3.59031103306651E-19  -4.50552424724054E-01  -4.50552424718468E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58592751156996E-09   0.00000000000000E+00  -5.58592751156996E-09
      1.68755943990090E-18  -7.84950289096482E-03  -4.15202686074001E-03   0.00000000000000E+00   3.13200118596893E-12
      1.12852560165106E-22  -1.17386218103257E-08  -1.17354898091396E-08  -1.32852833659425E-18
      6.78046328236834E-09
      0.00000000000000E+00  -1.73309182215859E-11   0.00000000000000E+00   4.32894521615944E-14   5.70162707037474E-23
      1.73308779730316E-08   1.73309212624838E-08  -3.28804718061264E-19  -4.63342296177991E-01  -4.63342296172196E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79550601464970E-09   0.00000000000000E+00  -5.79550601464970E-09
      1.57164931960791E-18  -7.41835766151074E-03  -3.78391676524923E-03   0.00000000000000E+00   2.71209194698651E-12
      8.15913272337677E-23  -1.15381273397812E-08  -1.15354152478341E-08  -1.24284460154665E-18
      6.80046328236834E-09
      0.00000000000000E+00  -1.77190540810249E-11   0.00000000000000E+00   9.77787301568646E-13   3.97427070407337E-23
      1.77181033645874E-08   1.77190811518891E-08  -2.97145460631408E-19  -4.76832345966012E-01  -4.76832345959789E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22325899941212E-09   0.00000000000000E+00  -6.22325899941212E-09
      1.44718413961967E-18  -7.15774846596102E-03  -3.53578021842124E-03   0.00000000000000E+00   2.28734339346625E-12
      5.44864725705216E-23  -1.14981094958703E-08  -1.14958221524768E-08  -1.15003867898826E-18
      6.81046328236834E-09
      0.00000000000000E+00  -1.79225820186768E-11   0.00000000000000E+00   1.02577067799240E-12   3.17259412612042E-23
      1.79215515109952E-08   1.79225772816732E-08  -2.81196476377370E-19  -4.83682201203163E-01  -4.83682201196721E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44103345935617E-09   0.00000000000000E+00  -6.44103345935617E-09
      1.38277380502611E-18  -7.04804390286846E-03  -3.43057341706351E-03   0.00000000000000E+00   2.18999419867021E-12
      4.17673838199807E-23  -1.14837338165158E-08  -1.14815438223171E-08  -1.10157732864874E-18
      6.82396328236834E-09
      0.00000000000000E+00  -1.80964441062106E-11   0.00000000000000E+00   6.58070174904594E-13   2.32169656193507E-23
      1.80957943026995E-08   1.80964523728744E-08  -2.59657250564803E-19  -4.92983377555163E-01  -4.92983377548588E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57501484701952E-09   0.00000000000000E+00  -6.57501484701952E-09
      1.29401110459134E-18  -6.92775859350319E-03  -3.29771764695087E-03   0.00000000000000E+00   1.91346574040254E-12
      2.83938885935108E-23  -1.15233509915954E-08  -1.15214375258550E-08  -1.03435385402654E-18
      6.84218828236834E-09
      0.00000000000000E+00  -1.82519372463030E-11   0.00000000000000E+00   4.41488743195492E-13   1.52918859283491E-23
      1.82514503102461E-08   1.82518917989893E-08  -2.31105734857724E-19  -5.05436819572629E-01  -5.05436819565976E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65289922607970E-09   0.00000000000000E+00  -6.65289922607970E-09
      1.17276201619604E-18  -6.79424657265096E-03  -3.13976897004706E-03   0.00000000000000E+00   1.73780981191291E-12
      1.60514488408899E-23  -1.16007303827215E-08  -1.15989925729096E-08  -9.41656281338317E-19
      6.84718828236834E-09
      0.00000000000000E+00  -1.83526909230196E-11   0.00000000000000E+00   1.00892207023701E-12   1.32817790459593E-23
      1.83517005607344E-08   1.83527094828046E-08  -2.23375805497757E-19  -5.08843616270866E-01  -5.08843616264142E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72393569536601E-09   0.00000000000000E+00  -6.72393569536601E-09
      1.13914233771921E-18  -6.77258018109678E-03  -3.10871899434762E-03   0.00000000000000E+00   1.57889050003990E-12
      1.28720806190956E-23  -1.16303526779389E-08  -1.16287737874388E-08  -9.15766532221455E-19
      6.85393828236834E-09
      0.00000000000000E+00  -1.85050613420469E-11   0.00000000000000E+00   1.13212772411023E-12   1.11083224079251E-23
      1.85039223045847E-08   1.85050544323089E-08  -2.12984205100804E-19  -5.13443898104658E-01  -5.13443898097890E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76821755411315E-09   0.00000000000000E+00  -6.76821755411315E-09
      1.09345686922895E-18  -6.77506950545636E-03  -3.07716031932800E-03   0.00000000000000E+00   1.05085250668667E-12
      9.47810533253496E-24  -1.17378877307024E-08  -1.17368368781957E-08  -8.80472664128143E-19
      6.86305078236834E-09
      0.00000000000000E+00  -1.86400731057420E-11   0.00000000000000E+00   7.51601555445913E-13   8.94241287484697E-24
      1.86392893518811E-08   1.86400409534366E-08  -1.99226655777705E-19  -5.19568484390342E-01  -5.19568484383598E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74401580965666E-09   0.00000000000000E+00  -6.74401580965666E-09
      1.03200202516345E-18  -6.78092036110694E-03  -3.03285521142403E-03   0.00000000000000E+00   9.13148969852981E-13
      6.15133082150695E-24  -1.18969382927497E-08  -1.18960251437798E-08  -8.32775369385744E-19
      6.87535265736834E-09
      0.00000000000000E+00  -1.85255427184442E-11   0.00000000000000E+00  -4.37804799343722E-13   6.93618454844799E-24
      1.85259885581620E-08   1.85255507533627E-08  -1.81792949704519E-19  -5.27381501028630E-01  -5.27381501022156E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47340251432877E-09   0.00000000000000E+00  -6.47340251432877E-09
      9.52367036607492E-19  -6.74498003525210E-03  -2.94772452718798E-03   0.00000000000000E+00   1.01133084993162E-12
      3.21410634271629E-24  -1.20531595698839E-08  -1.20521482390340E-08  -7.70574086902972E-19
      6.89196018861834E-09
      0.00000000000000E+00  -1.75739393962370E-11   0.00000000000000E+00  -2.80779179759887E-12   5.15448507371231E-24
      1.75767889050759E-08   1.75739811132783E-08  -1.62599547218683E-19  -5.36030687538114E-01  -5.36030687532682E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43127595214560E-09   0.00000000000000E+00  -5.43127595214560E-09
      8.62166951504861E-19  -6.59508365074819E-03  -2.76929553021014E-03   0.00000000000000E+00   1.04513674493435E-12
      9.03640986738530E-25  -1.21437502978777E-08  -1.21427051611328E-08  -6.99567404286178E-19
      6.91196018861834E-09
      0.00000000000000E+00  -1.46036805949456E-11   0.00000000000000E+00  -7.31228158035228E-12   3.52278853909082E-24
      1.46109621074261E-08   1.46036498258457E-08  -1.52603244752082E-19  -5.40440034134005E-01  -5.40440034131561E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44286467754268E-09   0.00000000000000E+00  -2.44286467754268E-09
      8.13309657954007E-19  -6.25451185666051E-03  -2.42302623106824E-03   0.00000000000000E+00   5.32832377584577E-13
     -7.47598926099555E-25  -1.21613179806806E-08  -1.21607851483030E-08  -6.60706413201925E-19
      6.93196018861834E-09
      0.00000000000000E+00  -8.88055948533297E-12   0.00000000000000E+00  -1.41049877522793E-11   1.74396099393453E-24
      8.89472163894019E-09   8.88061665118792E-09  -1.66844436267741E-19  -5.33627524183181E-01  -5.33627524186453E-01
      0.00000000000000E+00   0.00000000000000E+00   3.27185040265111E-09   0.00000000000000E+00   3.27185040265111E-09
      8.78746666007029E-19  -5.70058911150435E-03  -1.87172323598487E-03   0.00000000000000E+00  -7.24885936039172E-13
     -2.17413010096777E-24  -1.21517421679030E-08  -1.21524670538390E-08  -7.11902229739287E-19
      6.95196018861835E-09
      0.00000000000000E+00  -9.79707811792688E-13   0.00000000000000E+00  -1.94859198024644E-11  -8.55348554555110E-25
      9.99210821244726E-10   9.79724901442261E-10  -2.16777519103503E-19  -5.10862548558753E-01  -5.10862548569909E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11561298173419E-08   0.00000000000000E+00   1.11561298173419E-08
      1.10186926235387E-18  -4.96847676107618E-03  -1.14484471281750E-03   0.00000000000000E+00  -2.75350591826592E-12
     -4.61438265067625E-24  -1.21331012128659E-08  -1.21358547187842E-08  -8.85091743250364E-19
      6.97196018861835E-09
      0.00000000000000E+00   6.71329922144696E-12   0.00000000000000E+00  -1.90152441285924E-11  -5.90756073788213E-24
     -6.69429701571263E-09  -6.71331225984123E-09  -3.10370248917819E-19  -4.70346022709673E-01  -4.70346022728489E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88166617821552E-08   0.00000000000000E+00   1.88166617821552E-08
      1.47820249799697E-18  -4.20791603968178E-03  -3.94526237769736E-04   0.00000000000000E+00  -5.69282107171251E-12
     -1.15645121456389E-23  -1.20976567012423E-08  -1.21033495223140E-08  -1.16783224907915E-18
      6.99196018861835E-09
      0.00000000000000E+00   1.14630498061342E-11   0.00000000000000E+00  -1.18392590616480E-11  -1.77231409278065E-23
     -1.14512356375508E-08  -1.14630748966125E-08  -4.51291845194797E-19  -4.12951966312538E-01  -4.12951966336053E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35148043424164E-08   0.00000000000000E+00   2.35148043424164E-08
      1.94849858484530E-18  -3.59049751451292E-03   2.06625950217740E-04   0.00000000000000E+00  -1.04056712198458E-11
     -3.21888316774375E-23  -1.20413237745840E-08  -1.20517294458039E-08  -1.49720673965050E-18
      7.01196018861835E-09
      0.00000000000000E+00   1.16848548464904E-11   0.00000000000000E+00  -7.76687611109542E-13  -3.42709023271843E-23
     -1.16840444907596E-08  -1.16848211783708E-08  -6.30846247876049E-19  -3.41505910421449E-01  -3.41505910445072E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36225569371301E-08   0.00000000000000E+00   2.36225569371301E-08
      2.42094972358790E-18  -3.57198572368192E-03   1.89217456201835E-04   0.00000000000000E+00  -1.88347546138757E-11
     -6.35407955375397E-23  -1.19189010041454E-08  -1.19377357587593E-08  -1.79010347571185E-18
      7.03196018861835E-09
      0.00000000000000E+00   9.11136530993548E-12   0.00000000000000E+00   6.00333032872432E-12  -4.11546591474749E-23
     -9.11742240702408E-09  -9.11141907669540E-09  -8.11012346265118E-19  -2.64687718638285E-01  -2.64687718658611E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03258532072040E-08   0.00000000000000E+00   2.03258532072040E-08
      2.82746678773198E-18  -8.37179242286444E-03  -4.83848399970569E-03   0.00000000000000E+00  -3.17568615949753E-11
     -7.72425330474353E-23  -1.11826772689135E-08  -1.12144341305086E-08  -2.01645444146686E-18
      7.05196018861835E-09
      0.00000000000000E+00   7.23975325512050E-12   0.00000000000000E+00   4.19586745882317E-12  -4.33502008449128E-23
     -7.24396702747677E-09  -7.23977116001799E-09  -9.59165859016083E-19  -1.94110536739741E-01  -1.94110536756577E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68360737354519E-08   0.00000000000000E+00   1.68360737354519E-08
      3.16418826244102E-18  -2.37201461790273E-02  -2.06966602720955E-02   0.00000000000000E+00  -4.97298613174430E-11
     -8.50071381525141E-23  -9.54657271411635E-09  -9.59630257543388E-09  -2.20502240342493E-18
      7.07196018861835E-09
      0.00000000000000E+00   5.93023099201559E-12   0.00000000000000E+00   2.73551223943234E-12  -4.51288319288510E-23
     -5.93296992373519E-09  -5.93023441149581E-09  -1.07772632457459E-18  -1.32213716573853E-01  -1.32213716587976E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41228321641844E-08   0.00000000000000E+00   1.41228321641844E-08
      3.44664490572471E-18  -4.69847064954012E-02  -4.44034806451053E-02   0.00000000000000E+00  -7.57680430438232E-11
     -9.36185920993419E-23  -8.11682970964471E-09  -8.19259775268863E-09  -2.36891858115011E-18
      7.07321018861835E-09
      0.00000000000000E+00   5.76224696766302E-12   0.00000000000000E+00   5.92969233201673E-12  -4.52340976934397E-23
     -5.76820581540460E-09  -5.76227612307262E-09  -1.08492649743264E-18  -1.28308249830187E-01  -1.28308249843922E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37348133247511E-08   0.00000000000000E+00   1.37348133247511E-08
      3.46381342238064E-18  -4.85194215222097E-02  -4.60075175433107E-02   0.00000000000000E+00  -8.88309984206721E-11
     -9.41789376479787E-23  -7.88370620325714E-09  -7.97253720167790E-09  -2.37888692494800E-18
      7.07489768861835E-09
      0.00000000000000E+00   5.59958993806849E-12   0.00000000000000E+00   4.22423641015068E-12  -4.53808007069972E-23
     -5.60389623825702E-09  -5.59967200184692E-09  -1.09435672283559E-18  -1.23148989062954E-01  -1.23148989076353E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33988753710982E-08   0.00000000000000E+00   1.33988753710982E-08
      3.48642402456937E-18  -5.06687976864518E-02  -4.82115027847510E-02   0.00000000000000E+00  -9.57567417014056E-11
     -9.49447906179866E-23  -7.70344662754997E-09  -7.79920336925148E-09  -2.39206730173379E-18
      7.07717581361835E-09
      0.00000000000000E+00   5.41020608994657E-12   0.00000000000000E+00   3.54227855387089E-12  -4.55749798626208E-23
     -5.41365693574037E-09  -5.41011465718654E-09  -1.10663022048368E-18  -1.16378732240672E-01  -1.16378732253707E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30354781918146E-08   0.00000000000000E+00   1.30354781918146E-08
      3.51612047332510E-18  -5.36724562226350E-02  -5.12699320080203E-02   0.00000000000000E+00  -9.98056242500952E-11
     -9.59741465098816E-23  -7.52555791037779E-09  -7.62536353462798E-09  -2.40949025284142E-18
      7.08025128236835E-09
      0.00000000000000E+00   5.17508356269530E-12   0.00000000000000E+00   3.20013643378390E-12  -4.58267345570745E-23
     -5.17834706515004E-09  -5.17514692871630E-09  -1.12243976148465E-18  -1.07567076684269E-01  -1.07567076696863E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25935644794425E-08   0.00000000000000E+00   1.25935644794425E-08
      3.55485158733274E-18  -5.78853806795617E-02  -5.55480582844822E-02   0.00000000000000E+00  -1.03881110427825E-10
     -9.73546279283192E-23  -7.31453644029878E-09  -7.41841755072670E-09  -2.43241182584809E-18
      7.08440316518085E-09
      0.00000000000000E+00   4.87640447729643E-12   0.00000000000000E+00   2.98318549799639E-12  -4.61476448897774E-23
     -4.87936129785624E-09  -4.87637811235829E-09  -1.14249248299707E-18  -9.62422298403578E-02  -9.62422298523925E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20346840240711E-08   0.00000000000000E+00   1.20346840240711E-08
      3.60481818508615E-18  -6.38265809060511E-02  -6.15712112742143E-02   0.00000000000000E+00  -1.08917720056595E-10
     -9.92044702087713E-23  -7.04938819165599E-09  -7.15830591171269E-09  -2.46232570208908E-18
      7.09000820697772E-09
      0.00000000000000E+00   4.47724724939251E-12   0.00000000000000E+00   2.95647087853445E-12  -4.65448548118697E-23
     -4.48016268481967E-09  -4.47720621394118E-09  -1.16726635738731E-18  -8.20184068056797E-02  -8.20184068169759E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12962570928378E-08   0.00000000000000E+00   1.12962570928378E-08
      3.66813417823975E-18  -7.22695810959095E-02  -7.01210999959818E-02   0.00000000000000E+00  -1.15035764913312E-10
     -1.01676665805624E-22  -6.70401511398332E-09  -6.81905087889674E-09  -2.50086782085243E-18
      7.09757501340350E-09
      0.00000000000000E+00   3.89366578917589E-12   0.00000000000000E+00   3.27970107543662E-12  -4.70052309237332E-23
     -3.89698798842942E-09  -3.89370828735403E-09  -1.19623420254565E-18  -6.50467403521107E-02  -6.50467403623510E-02
      0.00000000000000E+00   0.00000000000000E+00   1.02403336221807E-08   0.00000000000000E+00   1.02403336221807E-08
      3.74562080049421E-18  -8.44329794763033E-02  -8.24333451492964E-02   0.00000000000000E+00  -1.21362725079683E-10
     -1.04946731663382E-22  -6.22526260974690E-09  -6.34662533482669E-09  -2.54938659794856E-18
      7.10268260774091E-09
      0.00000000000000E+00   3.39109138717630E-12   0.00000000000000E+00   4.35895768541432E-12  -4.72662441818504E-23
     -3.39547129092578E-09  -3.39111233324041E-09  -1.21320483931888E-18  -5.49326599718429E-02  -5.49326599811864E-02
      0.00000000000000E+00   0.00000000000000E+00   9.34354483918598E-09   0.00000000000000E+00   9.34354483918598E-09
      3.79334383720610E-18  -9.30823310667126E-02  -9.12068923937088E-02   0.00000000000000E+00  -1.26456214410658E-10
     -1.07118367054827E-22  -5.82597629153499E-09  -5.95243250594575E-09  -2.58013899788722E-18
      7.10957786009640E-09
      0.00000000000000E+00   2.71364460553359E-12   0.00000000000000E+00   4.44179279613544E-12  -4.75379893416166E-23
     -2.71806403734178E-09  -2.71362224454569E-09  -1.23142861535569E-18  -4.38887332236667E-02  -4.38887332318212E-02
      0.00000000000000E+00   0.00000000000000E+00   8.15459304527681E-09   0.00000000000000E+00   8.15459304527681E-09
      3.84957181410963E-18  -1.05498290504656E-01  -1.03783998179017E-01   0.00000000000000E+00  -1.27249722387383E-10
     -1.09918043747832E-22  -5.31372107834380E-09  -5.44097080073129E-09  -2.61814319875394E-18
      7.11888645077631E-09
      0.00000000000000E+00   1.90173712861905E-12   0.00000000000000E+00   4.01347763367776E-12  -4.77783639164617E-23
     -1.90575846114743E-09  -1.90174498351380E-09  -1.24846455023645E-18  -3.33284283642602E-02  -3.33284283709702E-02
      0.00000000000000E+00   0.00000000000000E+00   6.71002368350112E-09   0.00000000000000E+00   6.71002368350112E-09
      3.91203267803189E-18  -1.23310549922657E-01  -1.21795600136600E-01   0.00000000000000E+00  -1.26096377715023E-10
     -1.13440952168556E-22  -4.68218232227207E-09  -4.80827869998720E-09  -2.66356812779543E-18
      7.13145304819420E-09
      0.00000000000000E+00   1.13905843084775E-12   0.00000000000000E+00   2.82690396820082E-12  -4.79538124875365E-23
     -1.14187055414588E-09  -1.13904365017773E-09  -1.26188292406599E-18  -2.47148878346983E-02  -2.47148878399816E-02
      0.00000000000000E+00   0.00000000000000E+00   5.28325426925533E-09   0.00000000000000E+00   5.28325426925533E-09
      3.97842520748995E-18  -1.48229330951421E-01  -1.46923609072676E-01   0.00000000000000E+00  -1.24665114146484E-10
     -1.17811010564012E-22  -4.01954550493104E-09  -4.14421061907764E-09  -2.71654228342395E-18
      7.14841795470835E-09
      0.00000000000000E+00   6.07736626102204E-13   0.00000000000000E+00   1.46692777123505E-12  -4.80618633512672E-23
     -6.09198124260870E-10  -6.07731196489683E-10  -1.27100808128029E-18  -1.85015766996164E-02  -1.85015767037562E-02
      0.00000000000000E+00   0.00000000000000E+00   4.13987664790127E-09   0.00000000000000E+00   4.13987664790127E-09
      4.04865782780169E-18  -1.81331186299999E-01  -1.80218307393437E-01   0.00000000000000E+00  -1.24599232164052E-10
     -1.23220588695860E-22  -3.40754621924735E-09  -3.53214545141152E-09  -2.77764974652140E-18
      7.16841795470835E-09
      0.00000000000000E+00   3.35416980281888E-13   0.00000000000000E+00   6.39511612857484E-13  -4.81156318781543E-23
     -3.36021211918784E-10  -3.35381700305975E-10  -1.27635534336492E-18  -1.45535432538145E-02  -1.45535432571239E-02
      0.00000000000000E+00   0.00000000000000E+00   3.30936983295128E-09   0.00000000000000E+00   3.30936983295128E-09
      4.11484522446072E-18  -2.17168801510535E-01  -2.16231780060389E-01   0.00000000000000E+00  -1.23633542237582E-10
     -1.28989559205692E-22  -2.85035459040760E-09  -2.97398813264531E-09  -2.83848988109580E-18
      7.18841795470835E-09
      0.00000000000000E+00   2.19141542977159E-13   0.00000000000000E+00   2.73661141003423E-13  -4.81390427875327E-23
     -2.19434117014612E-10  -2.19160455873657E-10  -1.27941012143915E-18  -1.21559293935391E-02  -1.21559293961946E-02
      0.00000000000000E+00   0.00000000000000E+00   2.65550093060847E-09   0.00000000000000E+00   2.65550093060847E-09
      4.16795524307288E-18  -2.47786922374356E-01  -2.47019296664568E-01   0.00000000000000E+00  -1.16192919006385E-10
     -1.33976927816229E-22  -2.32014755572829E-09  -2.43634047473481E-09  -2.88854512163374E-18
      7.20841795470835E-09
      0.00000000000000E+00   1.68351403301397E-13   0.00000000000000E+00   1.20321552584999E-13  -4.81495452288486E-23
     -1.68505513793922E-10  -1.68385192241386E-10  -1.28147512571385E-18  -1.05385829703731E-02  -1.05385829724552E-02
      0.00000000000000E+00   0.00000000000000E+00   2.08204251788233E-09   0.00000000000000E+00   2.08204251788233E-09
      4.20959609343053E-18  -2.72122179440442E-01  -2.71519236635490E-01   0.00000000000000E+00  -1.00068426842905E-10
     -1.38001455173481E-22  -1.81358889879800E-09  -1.91365732564105E-09  -2.92812096771668E-18
      7.22841795470835E-09
      0.00000000000000E+00   1.43094100569327E-13   0.00000000000000E+00   6.12278713432107E-14  -4.81534744276591E-23
     -1.43155903649942E-10  -1.43094675778647E-10  -1.28305434226041E-18  -9.38456057593072E-03  -9.38456057751733E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58661005996811E-09   0.00000000000000E+00   1.58661005996811E-09
      4.24132829462989E-18  -2.90257468580800E-01  -2.89802656170192E-01   0.00000000000000E+00  -7.88412423105516E-11
     -1.41027055035454E-22  -1.36467414187860E-09  -1.44351538418930E-09  -2.95827395236948E-18
      7.24841795470835E-09
      0.00000000000000E+00   1.29317389988198E-13   0.00000000000000E+00   3.45814995145075E-14  -4.81539269632103E-23
     -1.29396003868422E-10  -1.29361422368955E-10  -1.28437413770183E-18  -8.53273440653168E-03  -8.53273440770476E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17307809050144E-09   0.00000000000000E+00   1.17307809050144E-09
      4.26478985643992E-18  -3.02845111701669E-01  -3.02516267497208E-01   0.00000000000000E+00  -5.62508788902677E-11
     -1.43121581446633E-22  -9.87465789242085E-10  -1.04371666813250E-09  -2.98041571873809E-18
      7.26841795470835E-09
      0.00000000000000E+00   1.21602432062765E-13   0.00000000000000E+00   2.07150863381743E-14  -4.81525963862386E-23
     -1.21624551885767E-10  -1.21603836799477E-10  -1.28555012180093E-18  -7.88817596860590E-03  -7.88817596943947E-03
      0.00000000000000E+00   0.00000000000000E+00   8.33563952129645E-10   0.00000000000000E+00   8.33563952129645E-10
      4.28146113548252E-18  -3.10684710089997E-01  -3.10460396208102E-01   0.00000000000000E+00  -3.47191652397324E-11
     -1.44397404543741E-22  -6.77240950090413E-10  -7.11960115330289E-10  -2.99591101368159E-18
      7.28841795470835E-09
      0.00000000000000E+00   1.10489218860655E-13   0.00000000000000E+00   3.04970526991943E-14  -4.81476580292374E-23
     -1.10505467415031E-10  -1.10474970362380E-10  -1.28651273894716E-18  -7.44218122966187E-03  -7.44218123027955E-03
      0.00000000000000E+00   0.00000000000000E+00   6.17681192485244E-10   0.00000000000000E+00   6.17681192485244E-10
      4.29381475933222E-18  -3.15663385318482E-01  -3.15503585757884E-01   0.00000000000000E+00  -2.08016880270944E-11
     -1.45159774463142E-22  -4.86404534095552E-10  -5.07206222122791E-10  -3.00730202038505E-18
      7.30841795470835E-09
      0.00000000000000E+00   9.53348372214128E-14   0.00000000000000E+00   4.25350745797834E-14  -4.81376829972888E-23
     -9.54129994192415E-11  -9.53704643447099E-11  -1.28718254491359E-18  -7.17404874704011E-03  -7.17404874760742E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67308387562722E-10   0.00000000000000E+00   5.67308387562722E-10
      4.30516092708347E-18  -3.20352310666958E-01  -3.20203623351135E-01   0.00000000000000E+00  -1.90725040079679E-11
     -1.45845497587603E-22  -4.52865419209917E-10  -4.71937923218031E-10  -3.01797838216988E-18
      7.32841795470835E-09
      0.00000000000000E+00   8.78954135076031E-14   0.00000000000000E+00   2.47129738677906E-14  -4.81261427656587E-23
     -8.79065152749187E-11  -8.78818023010990E-11  -1.28771236847370E-18  -6.96827281114850E-03  -6.96827281173427E-03
      0.00000000000000E+00   0.00000000000000E+00   5.85767822169900E-10   0.00000000000000E+00   5.85767822169900E-10
      4.31687628352687E-18  -3.25540933163028E-01  -3.25384069912354E-01   0.00000000000000E+00  -2.16615113508751E-11
     -1.46607599442424E-22  -4.76224508517771E-10  -4.97886019868793E-10  -3.02916391505317E-18
}
